# 画面設計書 111-リポジトリ設定

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるリポジトリ設定画面の設計仕様を記載したものである。

### 本画面の処理概要

リポジトリ設定画面は、プロジェクトのリポジトリに関連する各種設定を一元管理するための画面である。ブランチデフォルト設定、ブランチルール、保護ブランチ・タグ、デプロイトークン、デプロイキー、リポジトリミラーリング、リポジトリメンテナンスなど、リポジトリの運用に必要な設定を包括的に行うことができる。

**業務上の目的・背景**：プロジェクトのソースコード管理において、セキュリティとガバナンスを確保しつつ、開発チームの生産性を維持するために必要な設定を一箇所で管理できるようにすることが目的である。保護ブランチによる不正な変更の防止、デプロイトークン/キーによるCI/CDパイプラインからの安全なアクセス、ミラーリングによるリポジトリの冗長化など、エンタープライズ環境で求められる機能を提供する。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「リポジトリ」を選択してアクセスする。または、URL `/:namespace/:project/-/settings/repository` に直接アクセスする。

**主要な操作・処理内容**：
1. ブランチデフォルト設定の編集（デフォルトブランチ名、課題ブランチテンプレート）
2. ブランチルールの表示・編集
3. 保護ブランチの追加・編集・削除
4. 保護タグの追加・編集・削除
5. プッシュルールの設定（EE機能）
6. リポジトリミラーリングの設定（プル/プッシュミラー）
7. デプロイトークンの作成・削除
8. デプロイキーの追加・有効化・削除
9. リポジトリメンテナンス（クリーンアップ）の実行

**画面遷移**：
- 遷移元：プロジェクト設定ページ、プロジェクトサイドバー
- 遷移先：ブランチルール詳細画面、保護ブランチ詳細画面

**権限による表示制御**：
- `admin_project` 権限：ブランチデフォルト設定、ブランチルール、ミラーリング、デプロイキー、メンテナンス機能の表示
- `admin_push_rules` 権限：プッシュルール設定の表示（EE機能）
- `admin_protected_branch` 権限：保護ブランチ設定の表示
- `manage_deploy_tokens` 権限：デプロイトークン設定の表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | 保護ブランチ | 主機能 | ブランチの保護設定、マージ・プッシュ権限の制御 |
| 26 | 保護タグ | 補助機能 | タグの保護設定 |
| 27 | リポジトリミラーリング | 補助機能 | プル/プッシュミラーの設定 |

## 画面種別

設定（複数セクションの折りたたみ式設定画面）

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/repository`
- **HTTPメソッド**: GET（表示）、POST（更新）
- **コントローラー**: `Projects::Settings::RepositoryController`
- **アクション**: `show`、`update`、`cleanup`、`create_deploy_token`

## 入出力項目

### ブランチデフォルト設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| デフォルトブランチ | default_branch | string | はい | プロジェクトのデフォルトブランチ名 |
| 課題ブランチテンプレート | issue_branch_template | string | いいえ | 課題からブランチ作成時のテンプレート |
| 参照済み課題の自動クローズ | autoclose_referenced_issues | boolean | いいえ | マージ時に参照課題を自動クローズするか |

### 保護ブランチ

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ブランチ | name | string | はい | 保護対象のブランチ名またはワイルドカード |
| マージ許可 | merge_access_level | select | はい | マージを許可するロール |
| プッシュ許可 | push_access_level | select | はい | プッシュを許可するロール |
| 強制プッシュ許可 | allow_force_push | boolean | いいえ | 強制プッシュを許可するか |

### デプロイトークン

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 名前 | name | string | はい | トークンの識別名 |
| 有効期限 | expires_at | date | いいえ | トークンの有効期限 |
| ユーザー名 | username | string | いいえ | カスタムユーザー名 |
| リポジトリ読み取り | read_repository | boolean | いいえ | リポジトリ読み取り権限 |
| レジストリ読み取り | read_registry | boolean | いいえ | コンテナレジストリ読み取り権限 |
| レジストリ書き込み | write_registry | boolean | いいえ | コンテナレジストリ書き込み権限 |
| パッケージ読み取り | read_package_registry | boolean | いいえ | パッケージレジストリ読み取り権限 |
| パッケージ書き込み | write_package_registry | boolean | いいえ | パッケージレジストリ書き込み権限 |

## 表示項目

### ブランチルール一覧

| 項目名 | 説明 |
|--------|------|
| ブランチ名/パターン | 保護対象のブランチ名またはワイルドカードパターン |
| 適用ルール数 | 適用されているルールの数 |

### 保護ブランチ一覧

| 項目名 | 説明 |
|--------|------|
| ブランチ名 | 保護されているブランチ名 |
| マージ許可ロール | マージを許可されているロール |
| プッシュ許可ロール | プッシュを許可されているロール |
| 強制プッシュ | 強制プッシュ許可状態 |

### デプロイトークン一覧

| 項目名 | 説明 |
|--------|------|
| 名前 | トークンの識別名 |
| ユーザー名 | トークンのユーザー名 |
| 有効期限 | トークンの有効期限 |
| スコープ | 付与されている権限 |

## イベント仕様

### 1-保護ブランチ追加

保護ブランチの追加フォームで「保護」ボタンを押下すると、指定されたブランチが保護される。

- ProtectedBranchesレコードが新規作成される
- 関連するアクセスレベル（merge_access_levels、push_access_levels）が作成される
- 成功時：画面がリロードされ、保護ブランチ一覧に追加される
- 失敗時：エラーメッセージが表示される

### 2-デプロイトークン作成

デプロイトークン作成フォームで「作成」ボタンを押下すると、新しいデプロイトークンが生成される。

- `Projects::DeployTokens::CreateService`が実行される
- トークン値は作成直後の1回のみ表示される（セキュリティ上の理由）
- 成功時：トークン値が表示され、一覧に追加される
- 失敗時：エラーメッセージが表示される

### 3-リポジトリクリーンアップ

BFG object mapファイルをアップロードして「開始」ボタンを押下すると、リポジトリのクリーンアップ処理が開始される。

- `Projects::CleanupService.enqueue`が呼び出される
- 処理はバックグラウンドで実行される
- 完了時にメール通知が送信される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保護ブランチ追加 | protected_branches | INSERT | 保護ブランチレコード作成 |
| 保護ブランチ追加 | protected_branch_merge_access_levels | INSERT | マージアクセスレベル作成 |
| 保護ブランチ追加 | protected_branch_push_access_levels | INSERT | プッシュアクセスレベル作成 |
| 保護ブランチ削除 | protected_branches | DELETE | 保護ブランチレコード削除 |
| デプロイトークン作成 | deploy_tokens | INSERT | デプロイトークン作成 |
| デプロイトークン作成 | project_deploy_tokens | INSERT | プロジェクトとの関連作成 |
| デプロイトークン削除 | deploy_tokens | UPDATE | 削除日時を設定（論理削除） |
| 設定更新 | projects | UPDATE | プロジェクト設定の更新 |

### テーブル別更新項目詳細

#### protected_branches

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | ブランチ名またはワイルドカード |
| INSERT | project_id | 現在のプロジェクトID | - |
| INSERT | allow_force_push | フォーム入力値（デフォルト: false） | 強制プッシュ許可 |

#### deploy_tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | token | 自動生成されるランダムトークン | 暗号化保存 |
| INSERT | expires_at | フォーム入力値 | NULL許容 |
| INSERT | read_repository | フォーム入力値 | boolean |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-111-01 | 成功 | Your new project deploy token has been created. | デプロイトークン作成成功時 |
| MSG-111-02 | 成功 | Project settings were successfully updated. | 設定更新成功時 |
| MSG-111-03 | 成功 | Repository cleanup has started. You will receive an email once the cleanup operation is complete. | クリーンアップ開始成功時 |
| MSG-111-04 | エラー | Failed to upload object map file | クリーンアップファイルアップロード失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |
| 保護ブランチ名重複 | エラーメッセージを表示し、フォームを再表示 |
| デプロイトークン作成失敗 | エラーメッセージを表示し、フォームを再表示 |

## 備考

- リポジトリ設定画面は複数のセクションで構成され、各セクションは折りたたみ可能
- 一部の機能（プッシュルール等）はEnterprise Edition（EE）専用機能
- デプロイトークンのトークン値は作成時の1回のみ表示される（セキュリティ上の理由）
- リポジトリクリーンアップは処理に時間がかかるため、バックグラウンドで実行される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、保護ブランチとデプロイトークンのデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | protected_branch.rb | `app/models/protected_branch.rb` | 保護ブランチのモデル定義、バリデーション、関連モデル |
| 1-2 | deploy_token.rb | `app/models/deploy_token.rb` | デプロイトークンのモデル定義、スコープ、暗号化 |
| 1-3 | project_deploy_token.rb | `app/models/project_deploy_token.rb` | プロジェクトとデプロイトークンの関連 |

**読解のコツ**: Railsの`has_many`、`belongs_to`の関連定義を追いかけることで、テーブル間の関係を理解できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repository_controller.rb | `app/controllers/projects/settings/repository_controller.rb` | 画面表示・更新処理のエントリーポイント |

**主要処理フロー**:
1. **22-24行目**: `show`アクションで`render_show`を呼び出し
2. **82-96行目**: `render_show`メソッドで各種変数を定義
3. **88-96行目**: `define_variables`でデプロイキー、デプロイトークン、保護ブランチ/タグを準備

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/settings/repository/show.html.haml` | 画面全体の構成、各セクションの条件付き表示 |
| 3-2 | _protected_branches.html.haml | `app/views/projects/settings/repository/_protected_branches.html.haml` | 保護ブランチセクションのUI |

**主要処理フロー**:
- **6-8行目**: admin_project権限があればブランチデフォルト/ルールを表示
- **20-21行目**: admin_protected_branch権限があれば保護ブランチを表示
- **23-24行目**: manage_deploy_tokens権限があればデプロイトークンを表示

#### Step 4: サービス層を理解する

ビジネスロジックを担うサービスクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | create_service.rb | `app/services/projects/deploy_tokens/create_service.rb` | デプロイトークン作成のビジネスロジック |
| 4-2 | cleanup_service.rb | `app/services/projects/cleanup_service.rb` | リポジトリクリーンアップ処理 |

### プログラム呼び出し階層図

```
RepositoryController#show
    │
    ├─ render_show
    │      ├─ define_variables
    │      │      ├─ DeployKeysPresenter.new
    │      │      ├─ define_deploy_token_variables
    │      │      ├─ define_protected_refs
    │      │      │      ├─ fetch_protected_branches
    │      │      │      └─ load_gon_index
    │      │      └─ remote_mirror
    │      └─ render 'show'
    │
RepositoryController#create_deploy_token
    │
    └─ Projects::DeployTokens::CreateService#execute
           ├─ DeployToken.create
           └─ ProjectDeployToken.create
```

### データフロー図

```
[入力]                    [処理]                         [出力]

デプロイトークン ───▶ CreateService#execute ───▶ deploy_tokens テーブル
フォームデータ                │                          │
                             ▼                          ▼
                    DeployToken.create ───▶ 作成されたトークン情報
                             │
                             ▼
                    ProjectDeployToken.create

保護ブランチ ───────▶ ProtectedBranches::CreateService ───▶ protected_branches テーブル
フォームデータ                │                                      │
                             ▼                                      ▼
                    ProtectedBranch.create ───▶ アクセスレベルレコード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repository_controller.rb | `app/controllers/projects/settings/repository_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/settings/repository/show.html.haml` | ビュー | 画面テンプレート |
| protected_branch.rb | `app/models/protected_branch.rb` | モデル | 保護ブランチのデータモデル |
| deploy_token.rb | `app/models/deploy_token.rb` | モデル | デプロイトークンのデータモデル |
| create_service.rb | `app/services/projects/deploy_tokens/create_service.rb` | サービス | デプロイトークン作成ロジック |
| cleanup_service.rb | `app/services/projects/cleanup_service.rb` | サービス | リポジトリクリーンアップ |
| deploy_keys_presenter.rb | `app/presenters/deploy_keys_presenter.rb` | プレゼンター | デプロイキーの表示ロジック |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
