# 画面設計書 112-CI/CD設定

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるCI/CD設定画面の設計仕様を記載したものである。

### 本画面の処理概要

CI/CD設定画面は、プロジェクトの継続的インテグレーション/継続的デリバリーに関連する各種設定を一元管理するための画面である。パイプラインの一般設定、Auto DevOps、Runner、CI/CD変数、パイプライントリガー、デプロイフリーズ、ジョブトークン権限、セキュアファイルなど、CI/CD運用に必要な設定を包括的に行うことができる。

**業務上の目的・背景**：ソフトウェア開発のビルド・テスト・デプロイを自動化するCI/CDパイプラインの設定を管理し、開発チームの生産性向上とリリース品質の確保を実現することが目的である。環境変数によるシークレット管理、Runnerの割り当て、デプロイ期間の制御など、エンタープライズ環境で必要となる機能を提供する。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「CI/CD」を選択してアクセスする。または、URL `/:namespace/:project/-/settings/ci_cd` に直接アクセスする。

**主要な操作・処理内容**：
1. 一般パイプライン設定の編集（タイムアウト、Git戦略、アーティファクト有効期限等）
2. Auto DevOpsの有効化・設定
3. Runnerの有効化・無効化、設定
4. CI/CD変数の追加・編集・削除
5. パイプライントリガートークンの作成・管理
6. デプロイフリーズ期間の設定
7. ジョブトークン権限の設定
8. セキュアファイルのアップロード・管理

**画面遷移**：
- 遷移元：プロジェクト設定ページ、プロジェクトサイドバー
- 遷移先：Runner詳細画面、変数編集画面

**権限による表示制御**：
- `admin_pipeline` 権限：一般設定、Auto DevOps、トリガー、デプロイフリーズ、ジョブトークン権限の表示
- `admin_runners` 権限：Runner設定の表示
- `admin_cicd_variables` 権限：CI/CD変数設定の表示
- `admin_protected_environments` 権限：保護環境設定の表示（EE機能）
- `admin_secure_files` 権限：セキュアファイル設定の表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | CI変数管理 | 主機能 | CI/CD変数の追加・編集・削除 |
| 51 | Runnerレジストレーション | 補助機能 | Runner設定の管理 |
| 54 | トリガー管理 | 補助機能 | パイプライントリガーの管理 |

## 画面種別

設定（複数セクションの折りたたみ式設定画面）

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/ci_cd`
- **HTTPメソッド**: GET（表示）、PATCH/PUT（更新）
- **コントローラー**: `Projects::Settings::CiCdController`
- **アクション**: `show`、`update`、`reset_cache`、`reset_registration_token`

## 入出力項目

### 一般パイプライン設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| CI設定パス | ci_config_path | string | いいえ | .gitlab-ci.ymlのカスタムパス |
| ビルドタイムアウト | build_timeout_human_readable | string | いいえ | ジョブのタイムアウト時間 |
| パブリックパイプライン | public_builds | boolean | いいえ | パイプラインを公開するか |
| Git戦略 | build_allow_git_fetch | boolean | いいえ | git fetch/git cloneの選択 |
| 分離キャッシュ | ci_separated_caches | boolean | いいえ | ブランチごとにキャッシュを分離 |
| 保留パイプラインの自動キャンセル | auto_cancel_pending_pipelines | select | いいえ | 自動キャンセルの動作設定 |
| パイプライン変数の表示 | ci_display_pipeline_variables | boolean | いいえ | パイプライン変数の表示許可 |

### Auto DevOps設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Auto DevOps有効 | auto_devops_enabled | boolean | いいえ | Auto DevOpsの有効化 |
| デプロイ戦略 | deploy_strategy | select | いいえ | デプロイ戦略の選択 |
| ドメイン | domain | string | いいえ | Auto DevOpsドメイン |

### CI/CD変数

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| キー | key | string | はい | 変数名 |
| 値 | value | text | はい | 変数の値 |
| 保護 | protected | boolean | いいえ | 保護ブランチのみで使用 |
| マスク | masked | boolean | いいえ | ログでマスクするか |
| 展開 | raw | boolean | いいえ | 変数展開を無効化 |
| 環境スコープ | environment_scope | string | いいえ | 適用環境 |

### パイプライントリガー

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 説明 | description | string | はい | トリガーの説明 |

### デプロイフリーズ

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フリーズ開始 | freeze_start | string | はい | cron形式の開始時刻 |
| フリーズ終了 | freeze_end | string | はい | cron形式の終了時刻 |
| タイムゾーン | cron_timezone | select | はい | タイムゾーン |

## 表示項目

### Runner一覧

| 項目名 | 説明 |
|--------|------|
| タイプ | Shared/Group/Project Runner |
| 状態 | オンライン/オフライン |
| 名前 | Runnerの識別名 |
| タグ | 割り当てられたタグ |
| 最終コンタクト | 最後の通信時刻 |

### CI/CD変数一覧

| 項目名 | 説明 |
|--------|------|
| キー | 変数名 |
| 保護 | 保護ブランチ限定かどうか |
| マスク | マスク有無 |
| 環境スコープ | 適用環境 |

### パイプライントリガー一覧

| 項目名 | 説明 |
|--------|------|
| トークン | トリガートークン（一部マスク） |
| 説明 | トリガーの説明 |
| 作成者 | 作成したユーザー |
| 最終使用日時 | 最後に使用された日時 |

## イベント仕様

### 1-設定更新

設定フォームで「変更を保存」ボタンを押下すると、プロジェクトのCI/CD設定が更新される。

- `Projects::UpdateService`が実行される
- Auto DevOpsを有効化した場合、自動的にパイプラインが作成される場合がある
- 成功時：成功トーストメッセージが表示され、画面がリロードされる
- 失敗時：エラーメッセージが表示され、設定画面に戻る

### 2-キャッシュリセット

「キャッシュをリセット」ボタンを押下すると、プロジェクトのCI/CDキャッシュがリセットされる。

- `ResetProjectCacheService`が実行される
- 次回パイプライン実行時にキャッシュが再生成される

### 3-Runner登録トークンリセット

「登録トークンをリセット」ボタンを押下すると、新しいRunner登録トークンが生成される。

- `Ci::Runners::ResetRegistrationTokenService`が実行される
- 既存のトークンは無効化される

### 4-CI/CD変数追加

変数追加フォームで「変数を追加」ボタンを押下すると、新しいCI/CD変数が作成される。

- `Ci::Variable`レコードが新規作成される
- 値は暗号化されてデータベースに保存される

### 5-パイプライントリガー作成

トリガー作成フォームで「トリガーを追加」ボタンを押下すると、新しいパイプライントリガーが作成される。

- `Ci::Trigger`レコードが新規作成される
- トークンは自動生成される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定更新 | projects | UPDATE | プロジェクト設定の更新 |
| 設定更新 | project_auto_devops | INSERT/UPDATE | Auto DevOps設定 |
| 設定更新 | project_ci_cd_settings | UPDATE | CI/CD詳細設定 |
| 変数追加 | ci_variables | INSERT | CI/CD変数の作成 |
| 変数更新 | ci_variables | UPDATE | CI/CD変数の更新 |
| 変数削除 | ci_variables | DELETE | CI/CD変数の削除 |
| トリガー作成 | ci_triggers | INSERT | パイプライントリガー作成 |
| トリガー削除 | ci_triggers | DELETE | パイプライントリガー削除 |
| デプロイフリーズ作成 | ci_freeze_periods | INSERT | フリーズ期間作成 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | ci_config_path | フォーム入力値 | NULL許容 |
| UPDATE | build_timeout | 秒に変換された値 | デフォルト3600秒 |
| UPDATE | public_builds | フォーム入力値 | boolean |
| UPDATE | build_allow_git_fetch | フォーム入力値 | boolean |

#### ci_variables

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | key | フォーム入力値 | 変数名 |
| INSERT | encrypted_value | 暗号化された値 | attr_encrypted |
| INSERT | protected | フォーム入力値 | boolean |
| INSERT | masked | フォーム入力値 | boolean |
| INSERT | environment_scope | フォーム入力値 | デフォルト: * |

#### ci_triggers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | description | フォーム入力値 | 必須 |
| INSERT | token | 自動生成 | ランダムトークン |
| INSERT | owner_id | current_user.id | 作成者 |
| INSERT | project_id | 現在のプロジェクトID | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-112-01 | 成功 | Pipelines settings for '(project_name)' were successfully updated. | 設定更新成功時 |
| MSG-112-02 | 成功 | New runners registration token has been generated! | 登録トークンリセット成功時 |
| MSG-112-03 | 成功 | A new Auto DevOps pipeline has been created, go to the Pipelines page for details | Auto DevOps有効化後のパイプライン作成時 |
| MSG-112-04 | 通知 | This repository is currently empty. A new Auto DevOps pipeline will be created after a new file has been pushed to a branch. | 空リポジトリでAuto DevOps有効化時 |
| MSG-112-05 | エラー | Failed to generate export | エクスポート失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |
| 変数キー重複 | エラーメッセージを表示 |
| 無効なcron式 | エラーメッセージを表示 |
| キャッシュリセット失敗 | 400 Bad Requestを返却 |

## 備考

- CI/CD設定画面は複数のセクションで構成され、各セクションは折りたたみ可能
- 一部の機能（保護環境等）はEnterprise Edition（EE）専用機能
- CI/CD変数の値はログにマスクオプションで非表示化可能
- 設定画面アクセス時に監査ログが記録される
- パイプライントリガートークンは作成者に紐づく

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、CI/CD変数とトリガーのデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | variable.rb | `app/models/ci/variable.rb` | CI/CD変数のモデル定義、暗号化、バリデーション |
| 1-2 | trigger.rb | `app/models/ci/trigger.rb` | パイプライントリガーのモデル定義 |
| 1-3 | project_auto_devops.rb | `app/models/project_auto_devops.rb` | Auto DevOps設定のモデル |

**読解のコツ**: `attr_encrypted`による暗号化の仕組みを理解することで、変数値の安全な保存方法がわかる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ci_cd_controller.rb | `app/controllers/projects/settings/ci_cd_controller.rb` | 画面表示・更新処理のエントリーポイント |

**主要処理フロー**:
1. **27-40行目**: `show`アクションで変数、トリガー、バッジを準備
2. **42-56行目**: `update`アクションでプロジェクト設定を更新
3. **58-68行目**: `reset_cache`アクションでキャッシュリセット
4. **70-75行目**: `reset_registration_token`アクションでトークンリセット
5. **103-120行目**: `audit_project_cicd_settings_access`で監査ログ記録

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/settings/ci_cd/show.html.haml` | 画面全体の構成、各セクションの条件付き表示 |

**主要処理フロー**:
- **10-17行目**: admin_pipeline権限で一般パイプライン設定を表示
- **19-30行目**: admin_pipeline権限でAuto DevOps設定を表示
- **35-43行目**: admin_runners権限でRunner設定を表示
- **55-63行目**: admin_cicd_variables権限で変数設定を表示
- **65-73行目**: admin_pipeline権限でトリガー設定を表示

#### Step 4: サービス層を理解する

ビジネスロジックを担うサービスクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update_service.rb | `app/services/projects/update_service.rb` | プロジェクト設定更新のビジネスロジック |
| 4-2 | reset_project_cache_service.rb | `app/services/reset_project_cache_service.rb` | キャッシュリセット処理 |
| 4-3 | reset_registration_token_service.rb | `app/services/ci/runners/reset_registration_token_service.rb` | 登録トークンリセット |

### プログラム呼び出し階層図

```
CiCdController#show
    │
    ├─ define_variables
    │      ├─ define_ci_variables
    │      ├─ define_triggers_variables
    │      ├─ define_badges_variables
    │      └─ define_auto_devops_variables
    │
    └─ audit_project_cicd_settings_access
           └─ Gitlab::Audit::Auditor.audit

CiCdController#update
    │
    ├─ Projects::UpdateService#execute
    │      ├─ Project.update
    │      ├─ ProjectAutoDevops.create/update
    │      └─ ProjectCiCdSetting.update
    │
    └─ run_autodevops_pipeline
           └─ CreatePipelineWorker.perform_async
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CI/CD設定 ──────────▶ UpdateService#execute ──────▶ projects テーブル
フォームデータ                │                           │
                             ▼                           ▼
                    ProjectAutoDevops.save ──────▶ project_auto_devops テーブル

CI/CD変数 ──────────▶ Ci::Variable.create ────────▶ ci_variables テーブル
フォームデータ                │                      (暗号化保存)
                             ▼
                    attr_encrypted による暗号化

トリガー ───────────▶ Ci::Trigger.create ─────────▶ ci_triggers テーブル
フォームデータ                │
                             ▼
                    トークン自動生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ci_cd_controller.rb | `app/controllers/projects/settings/ci_cd_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/settings/ci_cd/show.html.haml` | ビュー | 画面テンプレート |
| variable.rb | `app/models/ci/variable.rb` | モデル | CI/CD変数のデータモデル |
| trigger.rb | `app/models/ci/trigger.rb` | モデル | トリガーのデータモデル |
| project_auto_devops.rb | `app/models/project_auto_devops.rb` | モデル | Auto DevOps設定 |
| update_service.rb | `app/services/projects/update_service.rb` | サービス | プロジェクト更新ロジック |
| reset_project_cache_service.rb | `app/services/reset_project_cache_service.rb` | サービス | キャッシュリセット |
| trigger_serializer.rb | `app/serializers/ci/trigger_serializer.rb` | シリアライザー | トリガーのJSON変換 |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
