# 画面設計書 113-MR設定

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるマージリクエスト設定画面の設計仕様を記載したものである。

### 本画面の処理概要

マージリクエスト設定画面は、プロジェクトのマージリクエストに関連する各種設定を一元管理するための画面である。マージ方法、スカッシュ設定、承認ルール、ターゲットブランチルールなど、コードレビューとマージプロセスに必要な設定を包括的に行うことができる。

**業務上の目的・背景**：ソフトウェア開発においてコードレビューは品質確保の重要な工程である。マージリクエストの設定を適切に管理することで、コードレビュープロセスの標準化、マージ履歴の整理、承認フローの強制など、チーム開発に必要なガバナンスを実現することが目的である。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「マージリクエスト」を選択してアクセスする。または、URL `/:namespace/:project/-/settings/merge_requests` に直接アクセスする。

**主要な操作・処理内容**：
1. マージ方法の選択（Merge commit、Rebase merge、Squash merge）
2. スカッシュオプションの設定
3. マージ可能条件の設定（パイプライン成功必須、すべてのディスカッション解決必須等）
4. マージコミットテンプレート/スカッシュコミットテンプレートの設定
5. 提案コミットメッセージの設定
6. マージリクエストタイトルの正規表現検証設定
7. 承認ルールの設定（EE機能）
8. サジェストレビュアーの設定（EE機能）
9. Duoコードレビューの設定（EE機能）
10. ターゲットブランチルールの設定（EE機能）

**画面遷移**：
- 遷移元：プロジェクト設定ページ、プロジェクトサイドバー
- 遷移先：承認ルール詳細画面

**権限による表示制御**：
- `admin_project` 権限：マージリクエスト設定画面全体へのアクセス
- マージリクエスト機能が無効な場合は404を表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | マージリクエストマージ | 主機能 | マージ方法・条件の設定 |
| 33 | 自動マージ | 補助機能 | 自動マージ関連の設定 |

## 画面種別

設定（フォーム形式の設定画面）

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/merge_requests`
- **HTTPメソッド**: GET（表示）、PATCH/PUT（更新）
- **コントローラー**: `Projects::Settings::MergeRequestsController`
- **アクション**: `show`（暗黙的）、`update`

## 入出力項目

### マージリクエスト設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| マージ方法 | merge_method | select | はい | Merge commit / Rebase merge / Semi-linear merge |
| スカッシュオプション | squash_option | select | はい | スカッシュの許可/強制設定 |
| パイプライン成功時のみマージ | only_allow_merge_if_pipeline_succeeds | boolean | いいえ | パイプライン成功を必須とするか |
| スキップされたパイプラインでのマージ許可 | allow_merge_on_skipped_pipeline | boolean | いいえ | スキップパイプラインでもマージ可能か |
| パイプラインなしでのマージ許可 | allow_merge_without_pipeline | boolean | いいえ | パイプラインがない場合のマージ許可 |
| すべてのディスカッション解決必須 | only_allow_merge_if_all_discussions_are_resolved | boolean | いいえ | 未解決ディスカッションがある場合マージ禁止 |
| 古い差分ディスカッションの自動解決 | resolve_outdated_diff_discussions | boolean | いいえ | コード変更で古いディスカッションを解決 |
| MRリンクの印刷有効化 | printing_merge_request_link_enabled | boolean | いいえ | プッシュ後にMRリンクを表示 |
| マージ後のソースブランチ削除 | remove_source_branch_after_merge | boolean | いいえ | マージ後にソースブランチを自動削除 |
| コミットメッセージ編集許可 | allow_editing_commit_messages | boolean | いいえ | マージコミットメッセージの編集許可 |
| フォークからのMRのターゲットをセルフに | mr_default_target_self | boolean | いいえ | フォークからのMRでターゲットを自プロジェクトに |
| マージコミットテンプレート | merge_commit_template_or_default | text | いいえ | マージコミットのテンプレート |
| スカッシュコミットテンプレート | squash_commit_template_or_default | text | いいえ | スカッシュコミットのテンプレート |
| 提案コミットメッセージ | suggestion_commit_message | text | いいえ | 提案適用時のコミットメッセージ |
| MRタイトル正規表現 | merge_request_title_regex | string | いいえ | MRタイトルの検証正規表現 |
| MRタイトル正規表現説明 | merge_request_title_regex_description | string | いいえ | 正規表現エラー時の説明文 |

## 表示項目

### 現在の設定サマリー

| 項目名 | 説明 |
|--------|------|
| マージ方法 | 現在設定されているマージ方法 |
| スカッシュオプション | 現在のスカッシュ設定 |
| パイプライン要件 | パイプライン成功必須の設定状態 |

## イベント仕様

### 1-設定更新

設定フォームで「変更を保存」ボタンを押下すると、プロジェクトのマージリクエスト設定が更新される。

- `Projects::UpdateService`が実行される
- 成功時：成功メッセージが表示され、設定画面に戻る
- 失敗時：エラーメッセージが表示され、設定画面を再表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定更新 | projects | UPDATE | プロジェクト設定の更新 |
| 設定更新 | project_settings | UPDATE | プロジェクト詳細設定の更新 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | merge_method | フォーム入力値 | enum: merge, rebase_merge, ff |
| UPDATE | only_allow_merge_if_pipeline_succeeds | フォーム入力値 | boolean |
| UPDATE | allow_merge_on_skipped_pipeline | フォーム入力値 | boolean |
| UPDATE | only_allow_merge_if_all_discussions_are_resolved | フォーム入力値 | boolean |
| UPDATE | resolve_outdated_diff_discussions | フォーム入力値 | boolean |
| UPDATE | printing_merge_request_link_enabled | フォーム入力値 | boolean |
| UPDATE | remove_source_branch_after_merge | フォーム入力値 | boolean |
| UPDATE | merge_commit_template | フォーム入力値 | text |
| UPDATE | squash_commit_template | フォーム入力値 | text |
| UPDATE | suggestion_commit_message | フォーム入力値 | text |

#### project_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | squash_option | フォーム入力値 | enum |
| UPDATE | allow_editing_commit_messages | フォーム入力値 | boolean |
| UPDATE | mr_default_target_self | フォーム入力値 | boolean |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-113-01 | 成功 | Project '(project_name)' was successfully updated. | 設定更新成功時 |
| MSG-113-02 | エラー | (各種バリデーションエラー) | 設定更新失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |
| マージリクエスト機能無効 | Not Found画面（404）を表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |

## 備考

- マージリクエスト機能が無効化されている場合、本画面にはアクセスできない
- 一部の機能（承認ルール、サジェストレビュアー、Duoコードレビュー、ターゲットブランチルール）はEnterprise Edition（EE）専用機能
- マージコミットテンプレートでは変数（%{title}、%{source_branch}等）が使用可能
- 正規表現検証はMR作成・更新時に適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、プロジェクトとプロジェクト設定のデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | マージリクエスト関連の属性定義 |
| 1-2 | project_setting.rb | `app/models/project_setting.rb` | squash_option等の詳細設定 |

**読解のコツ**: `enum`定義でマージ方法やスカッシュオプションの選択肢を確認できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests_controller.rb | `app/controllers/projects/settings/merge_requests_controller.rb` | 画面表示・更新処理のエントリーポイント |

**主要処理フロー**:
1. **8行目**: `merge_requests_enabled?`でマージリクエスト機能有効確認
2. **10行目**: `authorize_admin_project!`で権限確認
3. **14-25行目**: `update`アクションでプロジェクト設定を更新
4. **33-36行目**: `project_params`で許可パラメータを定義

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/settings/merge_requests/show.html.haml` | 画面全体の構成 |
| 3-2 | _merge_request_settings.html.haml | `app/views/projects/settings/merge_requests/_merge_request_settings.html.haml` | 設定フォームの詳細（存在前提） |

**主要処理フロー**:
- **5-17行目**: SettingsSectionComponentでマージリクエスト設定セクションを表示
- **14-17行目**: フォームと保存ボタンの表示
- **19-22行目**: EE機能の条件付き表示（承認設定、サジェストレビュアー等）

#### Step 4: サービス層を理解する

ビジネスロジックを担うサービスクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update_service.rb | `app/services/projects/update_service.rb` | プロジェクト設定更新のビジネスロジック |

### プログラム呼び出し階層図

```
MergeRequestsController#show
    │
    └─ render 'show'
           ├─ SettingsSectionComponent
           │      └─ _merge_request_settings partial
           │
           └─ render_if_exists (EE機能)
                  ├─ merge_request_approvals_settings
                  ├─ suggested_reviewers_settings
                  ├─ duo_code_review_settings
                  └─ target_branch_rules_settings

MergeRequestsController#update
    │
    └─ Projects::UpdateService#execute
           ├─ Project.update
           └─ ProjectSetting.update
```

### データフロー図

```
[入力]                    [処理]                         [出力]

MR設定 ────────────▶ UpdateService#execute ──────▶ projects テーブル
フォームデータ                │                           │
                             ▼                           ▼
                    Project.update ─────────────▶ project_settings テーブル
                             │
                             ▼
                    ProjectSetting.update
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| merge_requests_controller.rb | `app/controllers/projects/settings/merge_requests_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/settings/merge_requests/show.html.haml` | ビュー | 画面テンプレート |
| project.rb | `app/models/project.rb` | モデル | プロジェクトのデータモデル |
| project_setting.rb | `app/models/project_setting.rb` | モデル | プロジェクト設定のデータモデル |
| update_service.rb | `app/services/projects/update_service.rb` | サービス | プロジェクト更新ロジック |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
