# 画面設計書 114-運用設定

## 概要

本ドキュメントは、GitLabのプロジェクト設定における運用設定画面（Monitor Settings）の設計仕様を記載したものである。

### 本画面の処理概要

運用設定画面は、プロジェクトの運用監視に関連する各種設定を一元管理するための画面である。エラートラッキング、アラート管理、インシデント管理などのモニタリング機能の設定を包括的に行うことができる。

**業務上の目的・背景**：本番環境で稼働するアプリケーションの安定運用を確保するため、エラーの検出・追跡、アラートの受信・管理、インシデントの対応を効率化することが目的である。Sentryとの連携やPagerDuty/Webhookによるアラート通知など、運用チームに必要な機能を提供する。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「モニター」を選択してアクセスする。または、URL `/:namespace/:project/-/settings/operations` に直接アクセスする。

**主要な操作・処理内容**：
1. エラートラッキングの有効化・設定（Sentry連携）
2. 統合エラートラッキングの有効化
3. アラート管理の設定（HTTP統合、Prometheus統合）
4. インシデント管理の設定（自動インシデント作成、PagerDuty統合）
5. ステータスページの設定（EE機能）
6. Observabilityの設定（EE機能）

**画面遷移**：
- 遷移元：プロジェクト設定ページ、プロジェクトサイドバー
- 遷移先：インシデント一覧、アラート一覧

**権限による表示制御**：
- `admin_operations` 権限：運用設定画面全体へのアクセス

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 131 | アラート管理 | 主機能 | アラート統合の設定・管理 |
| 132 | エラートラッキング | 補助機能 | エラートラッキングの設定 |

## 画面種別

設定（複数セクションの折りたたみ式設定画面）

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/operations`
- **HTTPメソッド**: GET（表示）、PATCH/PUT（更新）
- **コントローラー**: `Projects::Settings::OperationsController`
- **アクション**: `show`（暗黙的）、`update`、`reset_pagerduty_token`

## 入出力項目

### エラートラッキング設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 有効 | enabled | boolean | いいえ | エラートラッキングの有効化 |
| 統合モード | integrated | boolean | いいえ | GitLab統合エラートラッキングを使用 |
| APIホスト | api_host | string | いいえ | Sentry APIのホストURL |
| トークン | token | string | いいえ | Sentry認証トークン |
| プロジェクト | project | object | いいえ | Sentryプロジェクト情報 |

### アラート管理設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| HTTP統合 | http_integrations | array | いいえ | HTTP統合設定の配列 |
| Prometheus統合 | prometheus_integration | object | いいえ | Prometheus統合設定 |

### インシデント管理設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| アラートから自動インシデント作成 | create_issue | boolean | いいえ | アラート時に自動でインシデント作成 |
| テンプレート | issue_template_key | string | いいえ | インシデント作成時のテンプレート |
| 重大度ごとの自動作成 | send_email | boolean | いいえ | 重大度に基づく通知 |
| PagerDuty統合有効 | pagerduty_active | boolean | いいえ | PagerDuty統合の有効化 |
| PagerDutyトークン | pagerduty_token | string | いいえ | PagerDuty Webhookトークン |

## 表示項目

### エラートラッキング状態

| 項目名 | 説明 |
|--------|------|
| 接続状態 | Sentryとの接続状態 |
| 統合DSN | GitLab統合エラートラッキングのDSN |
| プロジェクト一覧 | 利用可能なSentryプロジェクト |

### アラート統合一覧

| 項目名 | 説明 |
|--------|------|
| 統合名 | 統合の識別名 |
| タイプ | HTTP/Prometheus |
| 状態 | アクティブ/非アクティブ |
| エンドポイントURL | Webhook受信URL |

## イベント仕様

### 1-設定更新

設定フォームで「変更を保存」ボタンを押下すると、プロジェクトの運用設定が更新される。

- `Projects::Operations::UpdateService`が実行される
- インシデント管理のトラッキングイベントが記録される
- 成功時：成功メッセージが表示され、設定画面にリダイレクト
- 失敗時：エラーメッセージを含むJSON/HTMLレスポンス

### 2-PagerDutyトークンリセット

「トークンをリセット」ボタンを押下すると、新しいPagerDuty Webhookトークンが生成される。

- `Projects::Operations::UpdateService`で`regenerate_token: true`を指定
- 新しいトークンとWebhook URLがJSONで返却される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エラートラッキング設定更新 | project_error_tracking_settings | INSERT/UPDATE | エラートラッキング設定 |
| インシデント管理設定更新 | project_incident_management_settings | INSERT/UPDATE | インシデント管理設定 |

### テーブル別更新項目詳細

#### project_error_tracking_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | enabled | フォーム入力値 | boolean |
| INSERT/UPDATE | integrated | フォーム入力値 | boolean |
| INSERT/UPDATE | api_host | フォーム入力値 | Sentry URL |
| INSERT/UPDATE | encrypted_token | 暗号化されたトークン | attr_encrypted |

#### project_incident_management_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | create_issue | フォーム入力値 | boolean |
| INSERT/UPDATE | issue_template_key | フォーム入力値 | テンプレートキー |
| INSERT/UPDATE | pagerduty_active | フォーム入力値 | boolean |
| INSERT/UPDATE | encrypted_pagerduty_token | 暗号化されたトークン | attr_encrypted |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-114-01 | 成功 | Your changes have been saved | 設定更新成功時 |
| MSG-114-02 | エラー | (各種バリデーションエラー) | 設定更新失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |
| エラートラッキング機能が無効 | 404を返却（Feature flag無効時） |
| Sentry接続失敗 | エラーメッセージを表示 |

## 備考

- 運用設定画面は複数のセクションで構成され、各セクションは折りたたみ可能
- 一部の機能（ステータスページ、Observability）はEnterprise Edition（EE）専用機能
- PagerDutyトークンは暗号化されて保存される
- `hide_error_tracking_features`フィーチャーフラグでエラートラッキング機能を無効化可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エラートラッキングとインシデント管理のデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | error_tracking_setting.rb | `app/models/error_tracking/project_error_tracking_setting.rb` | エラートラッキング設定のモデル |
| 1-2 | incident_management_setting.rb | `app/models/incident_management/project_incident_management_setting.rb` | インシデント管理設定のモデル |

**読解のコツ**: `attr_encrypted`による暗号化の仕組みを理解することで、トークンの安全な保存方法がわかる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | operations_controller.rb | `app/controllers/projects/settings/operations_controller.rb` | 画面表示・更新処理のエントリーポイント |

**主要処理フロー**:
1. **7行目**: `authorize_admin_operations!`で権限確認
2. **21-26行目**: `update`アクションで設定を更新
3. **28-41行目**: `reset_pagerduty_token`でトークンリセット
4. **100-126行目**: `permitted_project_params`で許可パラメータを定義

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/settings/operations/show.html.haml` | 画面全体の構成 |
| 3-2 | _error_tracking.html.haml | `app/views/projects/settings/operations/_error_tracking.html.haml` | エラートラッキングセクション |
| 3-3 | _alert_management.html.haml | `app/views/projects/settings/operations/_alert_management.html.haml` | アラート管理セクション |
| 3-4 | _incidents.html.haml | `app/views/projects/settings/operations/_incidents.html.haml` | インシデント管理セクション |

**主要処理フロー**:
- **5行目**: render_if_existsでObservability設定（EE機能）
- **6行目**: エラートラッキング設定パーシャル
- **7行目**: アラート管理設定パーシャル
- **8行目**: インシデント管理設定パーシャル

#### Step 4: サービス層を理解する

ビジネスロジックを担うサービスクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update_service.rb | `app/services/projects/operations/update_service.rb` | 運用設定更新のビジネスロジック |

### プログラム呼び出し階層図

```
OperationsController#show
    │
    └─ render 'show'
           ├─ render_if_exists 'observability'
           ├─ _error_tracking partial
           │      └─ .js-error-tracking-form (Vue component)
           ├─ _alert_management partial
           │      └─ .js-alerts-settings (Vue component)
           └─ _incidents partial
                  └─ .js-incidents-settings (Vue component)

OperationsController#update
    │
    ├─ Projects::Operations::UpdateService#execute
    │      ├─ ErrorTrackingSetting.update
    │      └─ IncidentManagementSetting.update
    │
    └─ track_events
           └─ Gitlab::Tracking::IncidentManagement.track_from_params
```

### データフロー図

```
[入力]                    [処理]                         [出力]

エラートラッキング ──▶ UpdateService#execute ───▶ project_error_tracking_settings
設定データ                   │                           テーブル
                            │
                            ▼
インシデント管理 ──────▶ IncidentManagementSetting ──▶ project_incident_management_settings
設定データ                   .update                     テーブル

PagerDutyトークン ─────▶ regenerate_token: true ──────▶ 新しいトークンJSON
リセット要求                  │
                            ▼
                    pagerduty_webhook_url + token
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| operations_controller.rb | `app/controllers/projects/settings/operations_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/settings/operations/show.html.haml` | ビュー | 画面テンプレート |
| _error_tracking.html.haml | `app/views/projects/settings/operations/_error_tracking.html.haml` | ビュー | エラートラッキングセクション |
| _alert_management.html.haml | `app/views/projects/settings/operations/_alert_management.html.haml` | ビュー | アラート管理セクション |
| _incidents.html.haml | `app/views/projects/settings/operations/_incidents.html.haml` | ビュー | インシデントセクション |
| update_service.rb | `app/services/projects/operations/update_service.rb` | サービス | 設定更新ロジック |
| project_error_tracking_setting.rb | `app/models/error_tracking/project_error_tracking_setting.rb` | モデル | エラートラッキング設定 |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
