# 画面設計書 115-パッケージ設定

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるパッケージ・レジストリ設定画面の設計仕様を記載したものである。

### 本画面の処理概要

パッケージ・レジストリ設定画面は、プロジェクトのパッケージレジストリとコンテナレジストリに関連する各種設定を一元管理するための画面である。パッケージの保護設定、コンテナイメージのクリーンアップポリシー、レジストリの可視性設定などを包括的に行うことができる。

**業務上の目的・背景**：ソフトウェア開発において、パッケージやコンテナイメージの管理は重要な運用課題である。不要なイメージの自動削除によるストレージ最適化、重要なパッケージの保護、アクセス権限の制御など、レジストリ運用に必要な機能を提供することが目的である。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「パッケージとレジストリ」を選択してアクセスする。または、URL `/:namespace/:project/-/settings/packages_and_registries` に直接アクセスする。

**主要な操作・処理内容**：
1. パッケージレジストリの有効化・無効化
2. パッケージリクエスト転送の設定
3. パッケージ保護ルールの設定
4. コンテナレジストリの有効化・無効化
5. コンテナレジストリの可視性設定
6. コンテナイメージのクリーンアップポリシー設定
7. コンテナ保護ルールの設定

**画面遷移**：
- 遷移元：プロジェクト設定ページ、プロジェクトサイドバー
- 遷移先：クリーンアップタグ設定画面

**権限による表示制御**：
- `admin_project` 権限：パッケージ・レジストリ設定画面へのアクセス
- `view_package_registry_project_settings` 権限：パッケージ設定の表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | パッケージレジストリの設定管理 |
| 63 | コンテナレジストリ | 補助機能 | コンテナレジストリの設定管理 |

## 画面種別

設定（Vueコンポーネントベースの設定画面）

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/packages_and_registries`
- **HTTPメソッド**: GET（表示）
- **コントローラー**: `Projects::Settings::PackagesAndRegistriesController`
- **アクション**: `show`、`cleanup_tags`

## 入出力項目

### パッケージレジストリ設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| パッケージレジストリ有効 | packages_enabled | boolean | いいえ | パッケージレジストリの有効化 |
| リクエスト転送 | package_forwarding_enabled | boolean | いいえ | パッケージリクエストの転送設定 |

### パッケージ保護ルール

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| パッケージ名パターン | package_name_pattern | string | はい | 保護対象のパッケージ名パターン |
| パッケージタイプ | package_type | select | はい | npm、Maven等のパッケージタイプ |
| 最小アクセスレベル | minimum_access_level_for_push | select | はい | プッシュに必要な最小アクセスレベル |

### コンテナレジストリ設定

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| コンテナレジストリ有効 | container_registry_enabled | boolean | いいえ | コンテナレジストリの有効化 |
| 可視性 | container_registry_access_level | select | いいえ | プライベート/有効/無効 |

### コンテナイメージクリーンアップポリシー

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| クリーンアップ有効 | enabled | boolean | いいえ | 自動クリーンアップの有効化 |
| 実行間隔 | cadence | select | はい | クリーンアップ実行の間隔 |
| 保持パターン | keep_regex | string | いいえ | 保持するタグの正規表現パターン |
| 削除パターン | remove_regex | string | いいえ | 削除するタグの正規表現パターン |
| 保持数 | keep_n | integer | いいえ | 保持するタグの数 |
| 古いタグの期限 | older_than | select | いいえ | この期間より古いタグを削除 |

## 表示項目

### パッケージ保護ルール一覧

| 項目名 | 説明 |
|--------|------|
| パッケージ名パターン | 保護対象のパターン |
| パッケージタイプ | パッケージの種類 |
| 最小アクセスレベル | 必要な権限レベル |

### コンテナ保護ルール一覧

| 項目名 | 説明 |
|--------|------|
| リポジトリパスパターン | 保護対象のパターン |
| 最小プッシュアクセスレベル | プッシュに必要な権限 |
| 最小削除アクセスレベル | 削除に必要な権限 |

## イベント仕様

### 1-設定更新

設定を変更すると、GraphQL APIを通じてプロジェクト設定が更新される。

- VueコンポーネントからGraphQL mutationが実行される
- 成功時：成功メッセージが表示される
- 失敗時：エラーメッセージが表示される

### 2-クリーンアップポリシー設定

クリーンアップポリシーを設定すると、定期的にコンテナイメージが削除される。

- `ContainerExpirationPolicy`が更新される
- スケジュールに従ってクリーンアップジョブが実行される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パッケージ設定更新 | project_features | UPDATE | パッケージ機能設定 |
| 保護ルール追加 | packages_protection_rules | INSERT | パッケージ保護ルール作成 |
| 保護ルール削除 | packages_protection_rules | DELETE | パッケージ保護ルール削除 |
| コンテナ設定更新 | project_features | UPDATE | コンテナレジストリ機能設定 |
| クリーンアップポリシー更新 | container_expiration_policies | UPDATE | クリーンアップポリシー設定 |
| コンテナ保護ルール追加 | container_registry_protection_rules | INSERT | コンテナ保護ルール作成 |

### テーブル別更新項目詳細

#### project_features

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | package_registry_access_level | フォーム入力値 | enum: disabled/private/enabled |
| UPDATE | container_registry_access_level | フォーム入力値 | enum: disabled/private/enabled |

#### container_expiration_policies

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enabled | フォーム入力値 | boolean |
| UPDATE | cadence | フォーム入力値 | 実行間隔 |
| UPDATE | keep_n | フォーム入力値 | 保持数 |
| UPDATE | older_than | フォーム入力値 | 期限設定 |
| UPDATE | name_regex_keep | フォーム入力値 | 保持パターン |
| UPDATE | name_regex_delete | フォーム入力値 | 削除パターン |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-115-01 | 成功 | Settings saved successfully | 設定更新成功時 |
| MSG-115-02 | エラー | (GraphQLエラーメッセージ) | 設定更新失敗時 |
| MSG-115-03 | 警告 | Cleanup policy is not enabled | クリーンアップ未有効時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |
| パッケージレジストリ設定不可 | Not Found画面（404）を表示 |
| 無効な正規表現パターン | バリデーションエラーを表示 |

## 備考

- 設定画面はVueコンポーネント（`#js-registry-settings`）で実装
- 設定の変更はGraphQL APIを通じて行われる
- クリーンアップポリシーはバックグラウンドジョブで実行される
- パッケージ保護ルールはFeature flag（`packages_protected_packages_delete`）で制御される場合がある
- コンテナ保護ルールの削除機能はFeature flag（`container_registry_protected_containers_delete`）で制御される場合がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パッケージ・コンテナレジストリ関連のデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | container_expiration_policy.rb | `app/models/container_expiration_policy.rb` | クリーンアップポリシーのモデル |
| 1-2 | packages_protection_rule.rb | `app/models/packages/protection/rule.rb` | パッケージ保護ルールのモデル |
| 1-3 | container_registry_protection_rule.rb | `app/models/container_registry/protection/rule.rb` | コンテナ保護ルールのモデル |

**読解のコツ**: `enum`定義でcadence（実行間隔）やolder_than（期限）の選択肢を確認できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | packages_and_registries_controller.rb | `app/controllers/projects/settings/packages_and_registries_controller.rb` | 画面表示処理のエントリーポイント |

**主要処理フロー**:
1. **8行目**: `authorize_admin_project!`で権限確認
2. **9行目**: `packages_and_registries_settings_enabled!`で設定可能か確認
3. **10-11行目**: Feature flagのプッシュ
4. **16行目**: `show`アクション（空実装、Vueで処理）

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/settings/packages_and_registries/show.html.haml` | 画面全体の構成 |

**主要処理フロー**:
- **7行目**: `#js-registry-settings`でVueコンポーネントをマウント
- `settings_data(@project)`でコンポーネントにデータを渡す

#### Step 4: フロントエンド（Vue）を理解する

実際の設定UIを実装しているVueコンポーネントを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.js | `app/assets/javascripts/packages_and_registries/settings/project/` | Vueアプリのエントリーポイント |
| 4-2 | GraphQL mutations | `app/graphql/mutations/` | 設定更新のGraphQL mutation |

### プログラム呼び出し階層図

```
PackagesAndRegistriesController#show
    │
    └─ render 'show'
           └─ #js-registry-settings (Vue component mount)
                  │
                  ├─ PackageRegistrySettings
                  │      └─ GraphQL queries/mutations
                  │
                  ├─ ContainerRegistrySettings
                  │      └─ GraphQL queries/mutations
                  │
                  └─ CleanupPolicySettings
                         └─ GraphQL mutations
                                └─ ContainerExpirationPolicy.update
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Vue設定フォーム ──────▶ GraphQL mutation ────────▶ データベース
                            │                         テーブル
                            ▼
                    Resolver#resolve
                            │
                            ▼
                    Model.update
                            │
                            ▼
                    container_expiration_policies
                    packages_protection_rules
                    container_registry_protection_rules
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| packages_and_registries_controller.rb | `app/controllers/projects/settings/packages_and_registries_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/projects/settings/packages_and_registries/show.html.haml` | ビュー | 画面テンプレート |
| container_expiration_policy.rb | `app/models/container_expiration_policy.rb` | モデル | クリーンアップポリシー |
| rule.rb | `app/models/packages/protection/rule.rb` | モデル | パッケージ保護ルール |
| settings_helper.rb | `app/helpers/projects/settings/packages_and_registries_helper.rb` | ヘルパー | 設定データ準備 |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
