# 画面設計書 116-インテグレーション一覧

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるインテグレーション一覧画面の設計仕様を記載したものである。

### 本画面の処理概要

インテグレーション一覧画面は、プロジェクトで利用可能な外部連携（インテグレーション）の一覧を表示し、各インテグレーションの設定画面へのナビゲーションを提供する画面である。Slack、Jira、Mattermost、GitHubなど様々な外部サービスとの連携設定を管理できる。

**業務上の目的・背景**：ソフトウェア開発においては、コミュニケーションツール、課題追跡システム、デプロイツールなど様々な外部サービスと連携して作業を行う。これらの連携を一元的に管理し、プロジェクトのワークフローを効率化することが目的である。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「インテグレーション」を選択してアクセスする。または、URL `/:namespace/:project/-/settings/integrations` に直接アクセスする。

**主要な操作・処理内容**：
1. 利用可能なインテグレーションの一覧表示
2. 各インテグレーションの有効/無効状態の確認
3. インテグレーション設定画面への遷移
4. インテグレーションの検索・フィルタリング

**画面遷移**：
- 遷移元：プロジェクト設定ページ、プロジェクトサイドバー
- 遷移先：各インテグレーション編集画面（No.117）、Webhook設定画面

**権限による表示制御**：
- `admin_integrations` 権限：インテグレーション一覧画面へのアクセス

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | Slack連携 | 主機能 | Slack連携の設定管理 |
| 96 | Jira連携 | 補助機能 | Jira連携の設定管理 |
| 97 | Mattermost連携 | 補助機能 | Mattermost連携の設定管理 |

## 画面種別

一覧

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/integrations`
- **HTTPメソッド**: GET
- **コントローラー**: `Projects::Settings::IntegrationsController`
- **アクション**: `index`

## 入出力項目

なし（一覧表示のみ）

## 表示項目

### インテグレーション一覧

| 項目名 | 説明 |
|--------|------|
| インテグレーション名 | 連携サービスの名称 |
| アイコン | 連携サービスのアイコン |
| 説明 | 連携サービスの簡単な説明 |
| 状態 | 有効/無効/継承の状態 |

### 利用可能なインテグレーション例

- Asana
- Assembla
- Bamboo CI
- Bugzilla
- Buildkite
- Campfire
- Confluence Workspace
- Custom issue tracker
- Discord Notifications
- Drone CI
- Emails on push
- External wiki
- GitHub
- Google Chat
- HangoutsChat
- Harbor
- irker (IRC gateway)
- Jenkins
- Jira
- Mattermost notifications
- Mattermost slash commands
- Microsoft Teams notifications
- Packagist
- Pipelines emails
- Pivotal Tracker
- Prometheus
- Pumble
- Pushover
- Redmine
- Slack notifications
- Slack slash commands
- Squash TM
- Teamcity CI
- Telegram
- Unify Circuit
- Webex Teams
- YouTrack

## イベント仕様

### 1-インテグレーション選択

インテグレーション一覧から任意のインテグレーションをクリックすると、そのインテグレーションの編集画面に遷移する。

- 遷移先: `/:namespace/:project/-/settings/integrations/:id/edit`

## データベース更新仕様

なし（読み取り専用画面）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-116-01 | 情報 | (Slack Notifications非推奨警告) | Slack Notifications使用時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |

## 備考

- インテグレーション一覧はVueコンポーネント（`.js-integrations-list`）で表示
- グループレベルやインスタンスレベルで設定されたデフォルト設定を継承可能
- 一部のインテグレーションは非推奨（deprecated）となっている場合がある
- Webhookは別画面（`/:namespace/:project/hooks`）で管理
- インテグレーションの有効化にはテスト機能が提供されている場合がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インテグレーションのデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | integration.rb | `app/models/integration.rb` | インテグレーションの基底モデル |
| 1-2 | integrations/ | `app/models/integrations/` | 各インテグレーションの実装 |

**読解のコツ**: 単一テーブル継承（STI）で実装されており、`type`カラムでインテグレーション種別を判別している。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | integrations_controller.rb | `app/controllers/projects/settings/integrations_controller.rb` | 画面表示処理のエントリーポイント |

**主要処理フロー**:
1. **9行目**: `authorize_admin_integrations!`で権限確認
2. **27-29行目**: `index`アクションでインテグレーション一覧を取得

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/settings/integrations/index.html.haml` | 画面全体の構成 |
| 3-2 | _index.html.haml | `app/views/shared/integrations/_index.html.haml` | インテグレーション一覧のVueコンポーネント |

**主要処理フロー**:
- **5行目**: Slack Notifications非推奨警告の表示
- **7-13行目**: PageHeadingComponentでヘッダー表示
- **15行目**: shared/integrations/indexパーシャルでインテグレーション一覧を表示

#### Step 4: フロントエンド（Vue）を理解する

実際の一覧UIを実装しているVueコンポーネントを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | integration_list_data | ヘルパー | 一覧データの準備 |

### プログラム呼び出し階層図

```
IntegrationsController#index
    │
    ├─ @integrations = @project.find_or_initialize_integrations
    │
    └─ render 'index'
           ├─ shared/integrations/slack_notifications_deprecation_alert
           │
           ├─ PageHeadingComponent
           │
           └─ shared/integrations/_index
                  └─ .js-integrations-list (Vue component)
                         │
                         └─ integration_list_data(integrations)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト ──────▶ IntegrationsController ──────▶ インテグレーション一覧
                            │                           （HTML/Vue）
                            ▼
                    Project#find_or_initialize_integrations
                            │
                            ▼
                    Integration.all (STI)
                            │
                            ▼
                    各Integrationサブクラス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| integrations_controller.rb | `app/controllers/projects/settings/integrations_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/projects/settings/integrations/index.html.haml` | ビュー | 画面テンプレート |
| _index.html.haml | `app/views/shared/integrations/_index.html.haml` | ビュー | インテグレーション一覧 |
| integration.rb | `app/models/integration.rb` | モデル | インテグレーション基底クラス |
| integrations_helper.rb | `app/helpers/integrations_helper.rb` | ヘルパー | 一覧データ準備 |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
