# 画面設計書 117-インテグレーション編集

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるインテグレーション編集画面の設計仕様を記載したものである。

### 本画面の処理概要

インテグレーション編集画面は、個別のインテグレーション（外部連携）の設定を編集するための画面である。各インテグレーション固有の設定項目を入力し、連携の有効化・無効化、接続テスト、設定の保存を行うことができる。

**業務上の目的・背景**：外部サービスとの連携を適切に設定し、プロジェクトのワークフローを自動化・効率化することが目的である。Webhookの設定、認証情報の管理、イベントトリガーの選択など、インテグレーションごとに異なる設定を柔軟に行えるようにする。

**画面へのアクセス方法**：インテグレーション一覧画面から任意のインテグレーションを選択してアクセスする。または、URL `/:namespace/:project/-/settings/integrations/:id/edit` に直接アクセスする。

**主要な操作・処理内容**：
1. インテグレーションの有効化・無効化
2. 接続URL、トークン、APIキー等の認証情報設定
3. トリガーイベントの選択
4. 接続テストの実行
5. 設定の保存
6. グループ/インスタンスレベルの設定継承
7. Webhookログの確認（対応インテグレーションのみ）

**画面遷移**：
- 遷移元：インテグレーション一覧画面（No.116）
- 遷移先：インテグレーション一覧画面、Webhookログ詳細画面

**権限による表示制御**：
- `admin_integrations` 権限：インテグレーション編集画面へのアクセス

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | Slack連携 | 主機能 | 各インテグレーション設定の編集 |

## 画面種別

編集

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/integrations/:id/edit`
- **HTTPメソッド**: GET（表示）、PATCH/PUT（更新）
- **コントローラー**: `Projects::Settings::IntegrationsController`
- **アクション**: `edit`、`update`、`test`

## 入出力項目

### 共通設定項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 有効 | active | boolean | いいえ | インテグレーションの有効化 |
| デフォルト設定を継承 | inherit_from_id | integer | いいえ | グループ/インスタンスの設定を継承 |

### インテグレーション固有設定（例：Slack）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| Webhook URL | webhook | string | はい | SlackのWebhook URL |
| ユーザー名 | username | string | いいえ | メッセージの表示名 |
| チャンネル | channel | string | いいえ | 投稿先チャンネル |
| 通知アイコン | icon | string | いいえ | アイコンURL |
| ブランチフィルター | branches_to_be_notified | select | いいえ | 通知対象ブランチ |

### インテグレーション固有設定（例：Jira）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| URL | url | string | はい | JiraインスタンスのURL |
| ユーザー名 | username | string | はい | Jiraユーザー名 |
| パスワード/APIトークン | password | string | はい | 認証情報 |
| Jira課題遷移ID | jira_issue_transition_id | string | いいえ | 課題遷移時のID |

### トリガーイベント（通知系インテグレーション共通）

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| プッシュ | push_events | boolean | いいえ | プッシュ時に通知 |
| 課題 | issues_events | boolean | いいえ | 課題操作時に通知 |
| コンフィデンシャル課題 | confidential_issues_events | boolean | いいえ | 機密課題操作時に通知 |
| マージリクエスト | merge_requests_events | boolean | いいえ | MR操作時に通知 |
| ノート | note_events | boolean | いいえ | コメント時に通知 |
| コンフィデンシャルノート | confidential_note_events | boolean | いいえ | 機密コメント時に通知 |
| タグプッシュ | tag_push_events | boolean | いいえ | タグプッシュ時に通知 |
| パイプライン | pipeline_events | boolean | いいえ | パイプライン完了時に通知 |
| Wiki | wiki_page_events | boolean | いいえ | Wikiページ操作時に通知 |
| デプロイ | deployment_events | boolean | いいえ | デプロイ時に通知 |
| リリース | releases_events | boolean | いいえ | リリース時に通知 |

## 表示項目

### Webhookログ一覧（対応インテグレーションのみ）

| 項目名 | 説明 |
|--------|------|
| 実行日時 | Webhook実行の日時 |
| リクエストURL | 送信先URL |
| トリガー | トリガーイベント |
| ステータス | HTTP応答ステータスコード |
| 経過時間 | リクエストにかかった時間 |

## イベント仕様

### 1-設定更新

設定フォームで「変更を保存」ボタンを押下すると、インテグレーション設定が更新される。

- インテグレーションモデルの`save`が実行される
- デフォルト設定を継承する場合、`Integrations::Propagation::BulkUpdateService`が実行される
- 成功時：成功メッセージが表示される
- 失敗時：エラーメッセージが表示され、フォームが再表示される

### 2-接続テスト

「テスト設定」ボタンを押下すると、設定された接続情報でテストが実行される。

- `Integrations::Test::ProjectService`が実行される
- レート制限（`project_testing_integration`）が適用される
- 成功時：成功レスポンス（JSON）が返却される
- 失敗時：エラーメッセージを含むJSONが返却される

### 3-デフォルト設定継承

「デフォルト設定を使用」を選択すると、グループまたはインスタンスレベルの設定が適用される。

- `inherit_from_id`にデフォルト設定のIDが設定される
- `Integrations::Propagation::BulkUpdateService`で設定が同期される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定更新 | integrations | UPDATE | インテグレーション設定の更新 |
| Webhookログ作成 | web_hook_logs | INSERT | テスト/実行時のログ作成 |

### テーブル別更新項目詳細

#### integrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | active | フォーム入力値 | boolean |
| UPDATE | inherit_from_id | 継承元のID or NULL | 継承設定 |
| UPDATE | properties | JSON形式の設定値 | インテグレーション固有設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-117-01 | 成功 | (Integration) settings saved and active. | インテグレーション有効化成功時 |
| MSG-117-02 | 成功 | (Integration) settings saved, but not active. | インテグレーション無効状態で保存時 |
| MSG-117-03 | エラー | Validations failed. | バリデーションエラー時 |
| MSG-117-04 | エラー | Connection failed. Check your integration settings. | 接続テスト失敗時 |
| MSG-117-05 | エラー | This endpoint has been requested too many times. Try again later. | レート制限超過時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| インテグレーション未検出 | Not Found画面（404）を表示 |
| Prometheus（remove_monitor_metrics有効時） | Not Found画面（404）を表示 |
| 接続タイムアウト | 接続エラーメッセージを表示 |
| レート制限超過 | 429 Too Many Requestsを返却 |

## 備考

- インテグレーションごとに設定項目は大きく異なる
- 一部のインテグレーションはPrometheus等のメトリクス系機能と連携
- Webhookログは対応するインテグレーション（service_hookを持つもの）でのみ表示
- 接続テストにはレート制限が適用される
- デフォルト設定の継承元はグループまたはインスタンスレベルの設定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インテグレーションのデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | integration.rb | `app/models/integration.rb` | インテグレーションの基底モデル、属性定義 |
| 1-2 | 各インテグレーションモデル | `app/models/integrations/` | インテグレーション固有の実装 |

**読解のコツ**: `properties`カラムにJSON形式でインテグレーション固有の設定が保存される。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | integrations_controller.rb | `app/controllers/projects/settings/integrations_controller.rb` | 画面表示・更新処理のエントリーポイント |

**主要処理フロー**:
1. **10行目**: `ensure_integration_enabled`でインテグレーション有効確認
2. **11行目**: `integration`でインテグレーションを取得
3. **12行目**: `default_integration`でデフォルト設定を取得
4. **31行目**: `edit`アクションで編集画面表示
5. **33-62行目**: `update`アクションで設定更新
6. **64-71行目**: `test`アクションで接続テスト

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/projects/settings/integrations/edit.html.haml` | 画面全体の構成 |
| 3-2 | _form.html.haml | `app/views/projects/settings/integrations/_form.html.haml` | フォームの構成 |

**主要処理フロー**:
- **5行目**: フォームパーシャルの表示
- **7-9行目**: Webhookログの表示（対応インテグレーションのみ）

#### Step 4: サービス層を理解する

ビジネスロジックを担うサービスクラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | project_service.rb | `app/services/integrations/test/project_service.rb` | 接続テストのロジック |
| 4-2 | bulk_update_service.rb | `app/services/integrations/propagation/bulk_update_service.rb` | 設定継承の同期 |

### プログラム呼び出し階層図

```
IntegrationsController#edit
    │
    ├─ integration (find_or_initialize_integration)
    ├─ default_integration
    └─ web_hook_logs
           └─ render 'edit'
                  └─ _form partial

IntegrationsController#update
    │
    ├─ use_inherited_settings?
    │      └─ Integrations::Propagation::BulkUpdateService
    │
    └─ integration.save(context: :manual_change)
           └─ redirect/render

IntegrationsController#test
    │
    ├─ check_rate_limit!
    │
    └─ Integrations::Test::ProjectService#execute
           ├─ integration.test
           └─ HTTP request to external service
```

### データフロー図

```
[入力]                    [処理]                         [出力]

設定フォーム ──────────▶ IntegrationsController#update ───▶ integrations テーブル
                              │
                              ▼
継承設定選択 ──────────▶ BulkUpdateService ───────────────▶ 設定同期
                              │
                              ▼
テスト実行 ────────────▶ Integrations::Test::ProjectService
                              │
                              ▼
                    HTTP request to external service
                              │
                              ▼
                    web_hook_logs テーブル（ログ記録）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| integrations_controller.rb | `app/controllers/projects/settings/integrations_controller.rb` | コントローラー | リクエスト処理 |
| edit.html.haml | `app/views/projects/settings/integrations/edit.html.haml` | ビュー | 画面テンプレート |
| _form.html.haml | `app/views/projects/settings/integrations/_form.html.haml` | ビュー | フォームパーシャル |
| integration.rb | `app/models/integration.rb` | モデル | インテグレーション基底クラス |
| project_service.rb | `app/services/integrations/test/project_service.rb` | サービス | 接続テスト |
| bulk_update_service.rb | `app/services/integrations/propagation/bulk_update_service.rb` | サービス | 設定継承 |
| params.rb | `app/controllers/concerns/integrations/params.rb` | concern | パラメータ処理 |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
