# 画面設計書 119-ブランチルール一覧

## 概要

本ドキュメントは、GitLabのプロジェクト設定におけるブランチルール一覧画面の設計仕様を記載したものである。

### 本画面の処理概要

ブランチルール一覧画面は、プロジェクトのブランチに適用されているルール（保護ブランチ、承認ルール、ステータスチェックなど）を一覧表示するための画面である。各ブランチルールの詳細設定へのナビゲーションを提供し、ブランチ保護の全体像を把握できる。

**業務上の目的・背景**：複数のブランチ保護設定を一元的に管理し、プロジェクトのブランチポリシーを可視化することが目的である。保護ブランチ、マージリクエストの承認ルール、ステータスチェックなど、異なる設定画面に分散した情報を統合的に確認できる。

**画面へのアクセス方法**：プロジェクトのサイドバーから「設定」→「リポジトリ」を選択し、「ブランチルール」セクションから「詳細を見る」をクリックしてアクセスする。または、URL `/:namespace/:project/-/settings/branch_rules` に直接アクセスする。

**主要な操作・処理内容**：
1. ブランチルールの一覧表示
2. 各ブランチルールの詳細確認
3. 保護ブランチ設定へのナビゲーション
4. 承認ルール設定へのナビゲーション
5. マッチするブランチ数の確認

**画面遷移**：
- 遷移元：リポジトリ設定画面（No.111）
- 遷移先：保護ブランチ設定、承認ルール設定、ステータスチェック設定

**権限による表示制御**：
- `admin_project` 権限：ブランチルール一覧画面へのアクセス
- `admin_protected_branch` 権限：保護ブランチの編集リンク表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | ブランチ保護 | 主機能 | ブランチルールの表示・管理 |

## 画面種別

一覧

## URL/ルーティング

- **URL**: `/:namespace/:project/-/settings/branch_rules`
- **HTTPメソッド**: GET
- **コントローラー**: `Projects::Settings::BranchRulesController`
- **アクション**: `index`

## 入出力項目

本画面は一覧表示のみであり、入力項目は存在しない。

## 表示項目

### ブランチルール一覧

| 項目名 | 説明 |
|--------|------|
| ブランチ名/パターン | ルールが適用されるブランチ名またはワイルドカードパターン |
| 保護状態 | ブランチが保護されているかどうか |
| デフォルトブランチ | デフォルトブランチであるかどうか |
| マッチするブランチ数 | パターンにマッチするブランチの数 |
| 承認者数 | 設定されている承認ルールの数（EE機能） |
| ステータスチェック数 | 設定されているステータスチェックの数（EE機能） |
| コードオーナー | コードオーナーが設定されているか（EE機能） |

### 全ブランチルール（All branches）

| 項目名 | 説明 |
|--------|------|
| All branches | すべてのブランチに適用されるルール |
| スカッシュオプション | マージ時のスカッシュ設定 |

## イベント仕様

### 1-ブランチルール詳細表示

ブランチルール一覧の各行をクリックすると、該当するブランチルールの詳細画面または関連設定画面へ遷移する。

- 保護ブランチの場合：保護ブランチ設定セクションへ遷移
- 承認ルールが設定されている場合：承認ルール設定へ遷移
- ステータスチェックが設定されている場合：ステータスチェック設定へ遷移

## データベース更新仕様

本画面は参照のみであり、データベース更新は発生しない。

### 参照テーブル一覧

| テーブル名 | 参照内容 |
|-----------|---------|
| protected_branches | 保護ブランチ情報の取得 |
| protected_branch_push_access_levels | プッシュアクセスレベル |
| protected_branch_merge_access_levels | マージアクセスレベル |
| approval_rules | 承認ルール（EE） |
| external_status_checks | ステータスチェック（EE） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-119-01 | 情報 | No branch rules configured | ブランチルールが未設定時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| 権限不足 | アクセス拒否画面（403）を表示 |
| プロジェクト未検出 | Not Found画面（404）を表示 |

## 備考

- ブランチルールはGraphQL APIを通じて取得される
- Vueコンポーネント（`#js-branch-rules`）でフロントエンド描画
- ページネーションはGraphQLのカーソルベースページネーションを使用
- 「All branches」ルールはすべてのブランチに適用されるデフォルトルール
- EE機能（承認ルール、ステータスチェック、コードオーナー）はCE版では非表示
- `edit_branch_rules` フィーチャーフラグで編集機能の有効化を制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ブランチルールのデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | branch_rule.rb | `app/models/projects/branch_rule.rb` | ブランチルールのラッパーモデル |
| 1-2 | all_branches_rule.rb | `app/models/projects/all_branches_rule.rb` | 全ブランチ対象ルール |
| 1-3 | protected_branch.rb | `app/models/protected_branch.rb` | 保護ブランチモデル |

**読解のコツ**: `Projects::BranchRule`は`ProtectedBranch`をラップし、`matching_branches_count`でマッチするブランチ数を計算する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | branch_rules_controller.rb | `app/controllers/projects/settings/branch_rules_controller.rb` | 画面表示のエントリーポイント |

**主要処理フロー**:
1. **6行目**: `authorize_admin_project!`で権限確認
2. **7-9行目**: `edit_branch_rules`フィーチャーフラグをフロントエンドに渡す
3. **13行目**: `index`アクションで画面表示（ロジックはVue側）

#### Step 3: ビューテンプレートを理解する

画面の構成要素を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/settings/branch_rules/index.html.haml` | 画面全体の構成 |
| 3-2 | branch_rules_helper.rb | `app/helpers/projects/settings/branch_rules_helper.rb` | Vueコンポーネントへのデータ提供 |

**主要処理フロー**:
- **1-2行目**: パンくずリストの設定（リポジトリ設定 → ブランチルール）
- **6行目**: `#js-branch-rules`でVueコンポーネントをマウント
- **ヘルパー7-19行目**: `branch_rules_data`でVueに渡すデータを準備

#### Step 4: GraphQL APIを理解する

データ取得のためのGraphQL APIを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | branch_rules_resolver.rb | `app/graphql/resolvers/projects/branch_rules_resolver.rb` | ブランチルール取得のResolver |
| 4-2 | branch_rules_finder.rb | `app/finders/projects/branch_rules_finder.rb` | ブランチルール検索ロジック |

### プログラム呼び出し階層図

```
BranchRulesController#index
    │
    └─ render 'index'
           └─ #js-branch-rules (Vue component)
                  │
                  └─ GraphQL query: project.branchRules
                         │
                         └─ BranchRulesResolver#resolve_with_lookahead
                                │
                                ├─ custom_branch_rules (AllBranchesRule)
                                │
                                └─ BranchRulesFinder#execute
                                       ├─ custom_rules (pagination)
                                       └─ protected_branches (pagination)
                                              └─ Projects::BranchRule.new
```

### データフロー図

```
[フロントエンド]               [バックエンド]                [データベース]

Vue Component ──────────▶ GraphQL API ─────────────▶ protected_branches
(#js-branch-rules)              │                    テーブル
       │                        │
       │                        ├─ AllBranchesRule
       │                        │      (仮想ルール)
       │                        │
       ▼                        └─▶ Projects::BranchRule
branch_rules_data                    (ProtectedBranchのラッパー)
(Vue props)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| branch_rules_controller.rb | `app/controllers/projects/settings/branch_rules_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/projects/settings/branch_rules/index.html.haml` | ビュー | 画面テンプレート |
| branch_rules_helper.rb | `app/helpers/projects/settings/branch_rules_helper.rb` | ヘルパー | Vueデータ準備 |
| branch_rule.rb | `app/models/projects/branch_rule.rb` | モデル | ブランチルールラッパー |
| all_branches_rule.rb | `app/models/projects/all_branches_rule.rb` | モデル | 全ブランチルール |
| branch_rules_resolver.rb | `app/graphql/resolvers/projects/branch_rules_resolver.rb` | GraphQL | ブランチルール取得 |
| branch_rules_finder.rb | `app/finders/projects/branch_rules_finder.rb` | Finder | ブランチルール検索 |
| protected_branch.rb | `app/models/protected_branch.rb` | モデル | 保護ブランチ |
| project.rb | `config/routes/project.rb` | 設定 | ルーティング定義 |
