# 画面設計書 121-Webhook一覧

## 概要

本ドキュメントは、GitLabプロジェクトにおけるWebhook一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

Webhook一覧画面は、プロジェクトに設定されているWebhookの一覧表示と新規Webhook作成機能を提供する画面です。Webhookは、GitLabで発生した特定のイベント（プッシュ、マージリクエスト、イシュー作成など）を外部システムに自動通知するための仕組みです。

**業務上の目的・背景**：この画面は、CI/CDパイプラインとの連携、Slack等のチャットツールへの通知、外部のプロジェクト管理ツールとの同期など、GitLabと外部システムを連携させるために必要不可欠です。開発チームは、コード変更やイシュー更新などのイベントを外部サービスにリアルタイムで通知することで、開発ワークフローの自動化と効率化を実現できます。

**画面へのアクセス方法**：プロジェクトのサイドメニューから「設定」→「Webhooks」を選択してアクセスします。URLパターンは `/:namespace/:project/-/hooks` です。

**主要な操作・処理内容**：
1. 既存Webhookの一覧表示（URL、トリガーイベント、有効状態など）
2. 新規Webhookの作成フォーム入力（URL、シークレットトークン、トリガーイベント選択など）
3. 各Webhookの詳細設定画面への遷移
4. Webhookの有効/無効切り替え
5. Webhookのテスト実行

**画面遷移**：プロジェクト設定画面から遷移可能。各Webhookをクリックすると編集画面（122-Webhook編集）へ遷移します。Webhookログ詳細画面へも遷移可能です。

**権限による表示制御**：`read_web_hook`権限を持つユーザーのみ閲覧可能。`admin_web_hook`権限を持つユーザーのみWebhookの作成・編集・削除が可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | プロジェクトWebhook | 主機能 | Webhook設定の一覧表示 |

## 画面種別

一覧 / 登録

## URL/ルーティング

- パス: `/:namespace/:project/-/hooks`
- コントローラー: `Projects::HooksController#index`
- HTTPメソッド: GET

## 入出力項目

### 新規Webhook作成フォーム

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| URL | url | 入力 | string | ○ | Webhookの送信先URL |
| シークレットトークン | token | 入力 | string | - | 認証用のシークレットトークン |
| トリガーイベント | trigger | 入力 | checkbox | ○ | 通知を送信するイベントの選択 |
| SSL検証 | enable_ssl_verification | 入力 | boolean | - | SSL証明書の検証を行うか |
| カスタムテンプレート | custom_webhook_template | 入力 | text | - | カスタムWebhookテンプレート |

## 表示項目

### Webhook一覧

| 項目名 | 説明 |
|--------|------|
| URL | Webhookの送信先URL |
| トリガーイベント | 設定されているイベントタイプのリスト |
| 有効状態 | Webhookが有効か無効か |
| 最終実行結果 | 最後にWebhookを実行した際のステータス |
| 操作 | 編集・削除・テストボタン |

## イベント仕様

### 1-新規Webhook追加

「Add webhook」ボタン押下時の処理:

1. フォームバリデーション実行
2. URLの形式チェック
3. ProjectHookレコードの作成
4. 成功時: 一覧に新規Webhookを表示
5. 失敗時: エラーメッセージを表示

### 2-Webhookテスト

「Test」ボタン押下時の処理:

1. `TestHooks::ProjectService`によるテスト実行
2. 指定されたトリガーイベントでテストリクエストを送信
3. 実行結果をフラッシュメッセージで表示

### 3-Webhook削除

「Delete」ボタン押下時の処理:

1. 確認ダイアログ表示
2. 確認後、DELETEリクエスト送信
3. ProjectHookレコードの削除
4. 一覧から該当Webhookを削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Webhook追加 | web_hooks | INSERT | 新規Webhookレコードの作成 |
| Webhook削除 | web_hooks | DELETE | Webhookレコードの削除 |
| Webhook削除 | web_hook_logs | DELETE | 関連するログレコードの削除 |

### テーブル別更新項目詳細

#### web_hooks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | url | フォーム入力値 | 送信先URL |
| INSERT | token | フォーム入力値 | 暗号化して保存 |
| INSERT | project_id | 現在のプロジェクトID | |
| INSERT | push_events | チェック状態 | |
| INSERT | issues_events | チェック状態 | |
| INSERT | merge_requests_events | チェック状態 | |
| INSERT | enable_ssl_verification | チェック状態 | |
| INSERT | custom_webhook_template | フォーム入力値 | |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | Webhook was created | Webhook作成成功時 |
| 成功 | Hook executed successfully | テスト実行成功時 |
| エラー | Hook execution failed | テスト実行失敗時 |
| 情報 | No webhooks enabled. Select trigger events above. | Webhookが未設定時 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | 404エラーページを表示 |
| URL形式エラー | バリデーションエラーメッセージを表示 |
| レート制限 | テスト実行時にレート制限エラーを表示 |

## 備考

- Webhookのシークレットトークンは暗号化して保存される
- 利用可能なトリガーイベント: push_events, issues_events, merge_requests_events, note_events, tag_push_events, job_events, pipeline_events, wiki_page_events, deployment_events, feature_flag_events, release_events等
- Webhookの最大数はプロジェクト単位で制限される場合がある（Limitableモジュール）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Webhookのデータ構造とトリガーイベントの定義を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_hook.rb | `app/models/hooks/project_hook.rb` | AVAILABLE_HOOKSで利用可能なイベントタイプを確認 |
| 1-2 | web_hook.rb | `app/models/hooks/web_hook.rb` | 基底クラスでの共通属性とバリデーションを確認 |

**読解のコツ**: ProjectHookはWebHookを継承しており、プロジェクト固有のトリガーイベント(AVAILABLE_HOOKS)を定義しています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hooks_controller.rb | `app/controllers/projects/hooks_controller.rb` | indexアクションとbefore_actionの認可処理を確認 |

**主要処理フロー**:
1. **7行目**: `authorize_read_hook!` - 閲覧権限チェック
2. **8行目**: `authorize_admin_hook!` - 管理権限チェック
3. **17-24行目**: `test`アクション - Webhookのテスト実行

#### Step 3: Concernによる共通処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hook_actions.rb | `app/controllers/concerns/web_hooks/hook_actions.rb` | index, create, edit, update, destroyの共通実装 |

**主要処理フロー**:
- CRUDアクションの共通ロジックがこのConcernに集約されている

#### Step 4: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.html.haml | `app/views/projects/hooks/index.html.haml` | メインビューの構成 |
| 4-2 | _index.html.haml | `app/views/shared/web_hooks/_index.html.haml` | 一覧表示とフォームのパーシャル |
| 4-3 | _form.html.haml | `app/views/shared/web_hooks/_form.html.haml` | フォーム入力部分 |

### プログラム呼び出し階層図

```
Projects::HooksController#index
    │
    ├─ authorize_read_hook! (権限チェック)
    │
    ├─ relation (@project.hooks)
    │      └─ ProjectHook.for_projects
    │
    └─ View: index.html.haml
           └─ shared/web_hooks/_index.html.haml
                  ├─ shared/web_hooks/_hook.html.haml (各Webhook表示)
                  └─ shared/web_hooks/_form.html.haml (新規作成フォーム)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URL/トリガー設定 ───▶ HooksController#create ───▶ ProjectHook (DB)
                        │
                        └─ WebHooks::HookActions
                               └─ @hook.save

テストボタン押下 ───▶ HooksController#test ───▶ テスト結果
                        │
                        └─ TestHooks::ProjectService
                               └─ HTTP POST to webhook URL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hooks_controller.rb | `app/controllers/projects/hooks_controller.rb` | コントローラー | メインコントローラー |
| hook_actions.rb | `app/controllers/concerns/web_hooks/hook_actions.rb` | Concern | CRUD共通処理 |
| project_hook.rb | `app/models/hooks/project_hook.rb` | モデル | Webhookモデル |
| web_hook.rb | `app/models/hooks/web_hook.rb` | モデル | 基底モデル |
| index.html.haml | `app/views/projects/hooks/index.html.haml` | ビュー | メインビュー |
| _index.html.haml | `app/views/shared/web_hooks/_index.html.haml` | パーシャル | 一覧表示 |
| _form.html.haml | `app/views/shared/web_hooks/_form.html.haml` | パーシャル | フォーム |
| project_service.rb | `app/services/test_hooks/project_service.rb` | サービス | テスト実行 |
