# 画面設計書 122-Webhook編集

## 概要

本ドキュメントは、GitLabプロジェクトにおけるWebhook編集画面の設計仕様を定義するものです。

### 本画面の処理概要

Webhook編集画面は、既存のWebhook設定を編集・更新するための画面です。WebhookのURL、シークレットトークン、トリガーイベント、SSL検証設定などを変更できます。また、Webhookの実行ログ履歴の確認やテスト実行、Webhookの削除も可能です。

**業務上の目的・背景**：この画面は、既に設定済みのWebhook連携を保守・管理するために必要です。外部システムのURL変更、セキュリティトークンのローテーション、通知対象イベントの追加・削除、問題発生時のデバッグのためのログ確認など、Webhook運用における様々なニーズに対応します。開発・運用チームは本画面を通じて、外部連携の健全性を維持し、必要に応じて設定を最適化できます。

**画面へのアクセス方法**：Webhook一覧画面（121-Webhook一覧）から特定のWebhookをクリックして遷移します。URLパターンは `/:namespace/:project/-/hooks/:id/edit` です。

**主要な操作・処理内容**：
1. Webhook設定の編集（URL、トークン、トリガーイベント、SSL検証など）
2. 設定変更の保存
3. Webhookのテスト実行
4. Webhookの削除
5. Webhook実行ログの履歴確認

**画面遷移**：Webhook一覧画面から遷移。「Close」ボタンで一覧画面に戻る。削除後も一覧画面に戻る。ログ詳細をクリックするとHookログ詳細画面（133-Hookログ詳細）へ遷移します。

**権限による表示制御**：`admin_web_hook`権限を持つユーザーのみアクセス可能。編集・削除・テスト実行の全操作には管理者権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | プロジェクトWebhook | 主機能 | Webhook設定の編集 |

## 画面種別

編集

## URL/ルーティング

- パス: `/:namespace/:project/-/hooks/:id/edit`
- コントローラー: `Projects::HooksController#edit`
- HTTPメソッド: GET（表示）、PATCH/PUT（更新）

## 入出力項目

### Webhook編集フォーム

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| URL | url | 入力 | string | ○ | Webhookの送信先URL |
| シークレットトークン | token | 入力 | string | - | 認証用のシークレットトークン |
| トリガーイベント | trigger | 入力 | checkbox | ○ | 通知を送信するイベントの選択 |
| SSL検証 | enable_ssl_verification | 入力 | boolean | - | SSL証明書の検証を行うか |
| カスタムテンプレート | custom_webhook_template | 入力 | text | - | カスタムWebhookテンプレート |

## 表示項目

### Webhook詳細情報

| 項目名 | 説明 |
|--------|------|
| URL | 現在設定されている送信先URL |
| トリガーイベント | 有効なイベントタイプのリスト |
| SSL検証状態 | SSL検証の有効/無効 |

### Webhook実行ログ一覧

| 項目名 | 説明 |
|--------|------|
| トリガーイベント | ログのトリガーとなったイベント |
| URL | リクエスト送信先URL |
| 実行日時 | Webhookが実行された日時 |
| レスポンスステータス | HTTPレスポンスコード |
| 実行時間 | リクエストの実行時間 |

## イベント仕様

### 1-設定保存

「Save changes」ボタン押下時の処理:

1. フォームバリデーション実行
2. URLの形式チェック
3. ProjectHookレコードの更新
4. 成功時: 成功メッセージを表示
5. 失敗時: エラーメッセージを表示し、フォームを再表示

### 2-Webhookテスト

「Test」ボタン押下時の処理:

1. `TestHooks::ProjectService`によるテスト実行
2. 指定されたトリガーイベントでテストリクエストを送信
3. 実行結果をフラッシュメッセージで表示
4. 実行ログに記録

### 3-Webhook削除

「Delete」ボタン押下時の処理:

1. 確認ダイアログ「Are you sure you want to delete this project hook?」を表示
2. 確認後、DELETEリクエスト送信
3. ProjectHookレコードと関連するweb_hook_logsレコードを削除
4. Webhook一覧画面へリダイレクト

### 4-ログ詳細表示

ログ一覧から特定のログをクリック:

1. Hookログ詳細画面へ遷移
2. リクエスト/レスポンス内容の詳細を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | web_hooks | UPDATE | Webhook設定の更新 |
| Webhookテスト | web_hook_logs | INSERT | テスト実行ログの記録 |
| Webhook削除 | web_hooks | DELETE | Webhookレコードの削除 |
| Webhook削除 | web_hook_logs | DELETE | 関連するログレコードの削除 |

### テーブル別更新項目詳細

#### web_hooks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | url | フォーム入力値 | 送信先URL |
| UPDATE | token | フォーム入力値 | 暗号化して保存 |
| UPDATE | push_events | チェック状態 | |
| UPDATE | issues_events | チェック状態 | |
| UPDATE | merge_requests_events | チェック状態 | |
| UPDATE | enable_ssl_verification | チェック状態 | |
| UPDATE | custom_webhook_template | フォーム入力値 | |

#### web_hook_logs

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | web_hook_id | 対象WebhookのID | テスト実行時 |
| INSERT | trigger | 実行したトリガーイベント | |
| INSERT | url | リクエスト送信先URL | |
| INSERT | response_status | HTTPレスポンスコード | |
| INSERT | execution_duration | 実行時間（秒） | |
| INSERT | request_headers | リクエストヘッダー | JSON形式 |
| INSERT | request_data | リクエストボディ | JSON形式 |
| INSERT | response_headers | レスポンスヘッダー | JSON形式 |
| INSERT | response_body | レスポンスボディ | |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | Hook was successfully updated | 設定保存成功時 |
| 成功 | Hook executed successfully | テスト実行成功時 |
| エラー | Hook execution failed | テスト実行失敗時 |
| 確認 | Are you sure you want to delete this project hook? | 削除ボタン押下時 |
| 警告 | Recent failures (エラー詳細) | Webhook実行エラーがある場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | 404エラーページを表示 |
| Webhookが見つからない | 404エラーページを表示 |
| URL形式エラー | バリデーションエラーメッセージを表示 |
| レート制限 | テスト実行時にレート制限エラーを表示 |

## 備考

- Webhookエラー情報は画面上部に警告として表示される（_hook_errors パーシャル）
- ログ一覧はページネーション付きで表示される
- シークレットトークンは一度保存すると画面上では表示されない（セキュリティ上の理由）
- テスト実行には`web_hook_test`のレート制限が適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Webhook編集に関連するデータモデルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_hook.rb | `app/models/hooks/project_hook.rb` | Webhookモデルの構造 |
| 1-2 | web_hook_log.rb | `app/models/web_hook_log.rb` | ログモデルの構造 |

**読解のコツ**: web_hook_logsテーブルはWebhookの実行履歴を保持し、デバッグに重要な情報を提供します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | hooks_controller.rb | `app/controllers/projects/hooks_controller.rb` | editアクションとupdateアクション |

**主要処理フロー**:
1. **8行目**: `authorize_admin_hook!` - 管理者権限チェック
2. **32-34行目**: `hook`メソッド - 編集対象Webhookの取得

#### Step 3: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/projects/hooks/edit.html.haml` | 編集画面のメインビュー |
| 3-2 | _hook_errors.html.haml | `app/views/shared/web_hooks/_hook_errors.html.haml` | エラー表示パーシャル |
| 3-3 | _form.html.haml | `app/views/shared/web_hooks/_form.html.haml` | フォーム入力部分 |
| 3-4 | _index.html.haml | `app/views/shared/hook_logs/_index.html.haml` | ログ一覧パーシャル |

**主要処理フロー**:
- **10-11行目**: gitlab_ui_form_forでフォーム生成
- **15行目**: 保存ボタン
- **16行目**: テストボタン
- **18行目**: 削除ボタン（confirm付き）
- **23行目**: ログ一覧パーシャルの表示

#### Step 4: テスト実行サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | project_service.rb | `app/services/test_hooks/project_service.rb` | テスト実行ロジック |

### プログラム呼び出し階層図

```
Projects::HooksController#edit
    │
    ├─ authorize_admin_hook! (権限チェック)
    │
    ├─ hook (@project.hooks.find(params[:id]))
    │
    └─ View: edit.html.haml
           ├─ shared/web_hooks/_hook_errors.html.haml
           ├─ shared/web_hooks/_form.html.haml
           ├─ shared/web_hooks/_test_button.html.haml
           └─ shared/hook_logs/_index.html.haml

Projects::HooksController#update
    │
    ├─ authorize_admin_hook!
    │
    └─ WebHooks::HookActions#update (Concern)
           └─ @hook.update(hook_params)

Projects::HooksController#test
    │
    ├─ authorize_admin_hook!
    │
    └─ TestHooks::ProjectService#execute
           └─ WebHook#execute (HTTP POST)
```

### データフロー図

```
[入力]               [処理]                    [出力]

編集フォーム ───▶ HooksController#update ───▶ web_hooks (UPDATE)
                        │
                        └─ WebHooks::HookActions
                               └─ @hook.update

テストボタン ───▶ HooksController#test ───▶ 外部URL (HTTP POST)
                        │                         │
                        │                         ▼
                        └─ TestHooks::ProjectService ─▶ web_hook_logs (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| hooks_controller.rb | `app/controllers/projects/hooks_controller.rb` | コントローラー | メインコントローラー |
| hook_actions.rb | `app/controllers/concerns/web_hooks/hook_actions.rb` | Concern | CRUD共通処理 |
| edit.html.haml | `app/views/projects/hooks/edit.html.haml` | ビュー | 編集画面 |
| _hook_errors.html.haml | `app/views/shared/web_hooks/_hook_errors.html.haml` | パーシャル | エラー表示 |
| _form.html.haml | `app/views/shared/web_hooks/_form.html.haml` | パーシャル | フォーム |
| _test_button.html.haml | `app/views/shared/web_hooks/_test_button.html.haml` | パーシャル | テストボタン |
| _index.html.haml | `app/views/shared/hook_logs/_index.html.haml` | パーシャル | ログ一覧 |
| project_service.rb | `app/services/test_hooks/project_service.rb` | サービス | テスト実行 |
| web_hook_log.rb | `app/models/web_hook_log.rb` | モデル | ログモデル |
