# 画面設計書 123-デプロイキー編集

## 概要

本ドキュメントは、GitLabプロジェクトにおけるデプロイキー編集画面の設計仕様を定義するものです。

### 本画面の処理概要

デプロイキー編集画面は、プロジェクトに設定されているデプロイキーの情報を編集するための画面です。デプロイキーは、CI/CDパイプラインやスクリプトがSSH経由でリポジトリにアクセスするための認証キーであり、本画面ではそのタイトル（名前）の変更や、書き込み権限の付与・取り消しを行えます。

**業務上の目的・背景**：デプロイキーは、パスワードなしでGitリポジトリにアクセスするための重要な認証手段です。本番デプロイメントの自動化、CI/CDパイプラインでのコード取得、外部サービスとのリポジトリ連携など、様々なユースケースで利用されます。キーの識別を容易にするためのタイトル変更や、セキュリティポリシーに応じた書き込み権限の制御が必要となるため、この編集画面が提供されています。

**画面へのアクセス方法**：プロジェクト設定の「リポジトリ」セクション内「デプロイキー」設定から、既存のデプロイキーの編集アイコンをクリックして遷移します。URLパターンは `/:namespace/:project/-/deploy_keys/:id/edit` です。

**主要な操作・処理内容**：
1. デプロイキーのタイトル（名前）の編集
2. フィンガープリント（SHA256/MD5）の確認
3. 有効期限の確認
4. 書き込み権限（Grant write permissions）の有効/無効設定
5. 設定変更の保存

**画面遷移**：プロジェクト設定のリポジトリ設定画面から遷移。保存後はリポジトリ設定画面の「デプロイキー」セクションへリダイレクトされます。キャンセルボタンでも同様にリダイレクトされます。

**権限による表示制御**：`admin_project`権限と`update_deploy_key`または`update_deploy_keys_project`権限を持つユーザーのみアクセス可能。タイトル変更は`update_deploy_key_title`権限を持つユーザーのみ可能で、権限がない場合はタイトル欄が読み取り専用となります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 57 | デプロイキー管理 | 主機能 | デプロイキーの編集 |

## 画面種別

編集

## URL/ルーティング

- パス: `/:namespace/:project/-/deploy_keys/:id/edit`
- コントローラー: `Projects::DeployKeysController#edit`
- HTTPメソッド: GET（表示）、PATCH/PUT（更新）

## 入出力項目

### デプロイキー編集フォーム

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| タイトル | title | 入力 | string | ○ | デプロイキーの識別名（権限がない場合は読み取り専用） |
| フィンガープリント(SHA256) | fingerprint_sha256 | 表示 | string | - | キーのSHA256フィンガープリント（読み取り専用） |
| フィンガープリント(MD5) | fingerprint | 表示 | string | - | キーのMD5フィンガープリント（読み取り専用） |
| 有効期限 | expires_at | 表示 | date | - | キーの有効期限（読み取り専用） |
| 書き込み権限 | can_push | 入力 | boolean | - | このキーでプッシュを許可するか |

## 表示項目

### デプロイキー情報

| 項目名 | 説明 |
|--------|------|
| タイトル | デプロイキーの名前 |
| フィンガープリント(SHA256) | 64文字の16進数フィンガープリント |
| フィンガープリント(MD5) | コロン区切りの16進数フィンガープリント |
| 有効期限 | キーの有効期限日（設定されている場合） |
| 書き込み権限チェックボックス | 現在の書き込み権限状態 |

## イベント仕様

### 1-設定保存

「Save changes」ボタン押下時の処理:

1. フォームバリデーション実行
2. DeployKeyレコードおよびDeployKeysProjectレコードの更新
3. 成功時: 「Deploy key was successfully updated.」メッセージを表示し、リポジトリ設定画面へリダイレクト
4. 失敗時: エラーメッセージを表示し、編集画面を再表示

### 2-キャンセル

「Cancel」ボタン押下時の処理:

1. 入力内容を破棄
2. リポジトリ設定画面（デプロイキーセクション）へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | keys | UPDATE | デプロイキータイトルの更新（権限がある場合） |
| 設定保存 | deploy_keys_projects | UPDATE | 書き込み権限設定の更新 |

### テーブル別更新項目詳細

#### keys

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | フォーム入力値 | `update_deploy_key_title`権限が必要 |

#### deploy_keys_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | can_push | チェックボックス状態 | true: 書き込み許可、false: 読み取り専用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | Deploy key was successfully updated. | 設定保存成功時 |
| エラー | バリデーションエラーメッセージ | 入力値が不正な場合 |
| ヘルプ | Paste a public key here. How do I generate it? | キー入力欄（新規作成時のみ表示） |
| ヘルプ | Allow this key to push to this repository | 書き込み権限チェックボックスのヘルプテキスト |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | アクセス拒否エラー（access_denied!） |
| デプロイキーが見つからない | 404エラーページを表示 |

## 備考

- デプロイキーの公開鍵自体は編集画面では変更できない（セキュリティ上の理由）
- 新規作成時は公開鍵と有効期限が入力可能だが、編集時はこれらは読み取り専用
- 複数プロジェクトで共有されているデプロイキーの場合、タイトル変更は全プロジェクトに影響する
- フィンガープリントはキーの識別に使用され、画面で変更することはできない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デプロイキーに関連するデータモデルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_key.rb | `app/models/deploy_key.rb` | DeployKeyモデルの構造、Keyを継承していることを確認 |
| 1-2 | deploy_keys_project.rb | `app/models/deploy_keys_project.rb` | プロジェクトとの関連、can_push属性 |

**読解のコツ**: DeployKeyはKeyモデルを継承し、deploy_keys_projectsを通じてプロジェクトと多対多の関係を持ちます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deploy_keys_controller.rb | `app/controllers/projects/deploy_keys_controller.rb` | edit/updateアクションの実装 |

**主要処理フロー**:
1. **9行目**: `authorize_admin_project!` - プロジェクト管理権限チェック
2. **10行目**: `authorize_update_deploy_key!` - デプロイキー更新権限チェック
3. **66行目**: `edit`アクション - 空実装（ビュー表示のみ）
4. **68-76行目**: `update`アクション - 更新処理

#### Step 3: 権限チェックの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | deploy_keys_controller.rb | `app/controllers/projects/deploy_keys_controller.rb` | 128-133行目 `authorize_update_deploy_key!` |

**主要処理フロー**:
- `update_deploy_key`権限または`update_deploy_keys_project`権限のいずれかが必要

#### Step 4: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.html.haml | `app/views/projects/deploy_keys/edit.html.haml` | 編集画面のメインビュー |
| 4-2 | _form.html.haml | `app/views/shared/deploy_keys/_form.html.haml` | フォーム入力部分 |

**主要処理フロー**:
- **6行目**: gitlab_ui_form_forでフォーム生成
- **9行目**: 保存ボタン
- **10行目**: キャンセルボタン（リポジトリ設定へのリンク）

### プログラム呼び出し階層図

```
Projects::DeployKeysController#edit
    │
    ├─ authorize_admin_project!
    │
    ├─ authorize_update_deploy_key!
    │      ├─ can?(:update_deploy_key, deploy_key)
    │      └─ can?(:update_deploy_keys_project, deploy_keys_project)
    │
    └─ View: edit.html.haml
           └─ shared/deploy_keys/_form.html.haml

Projects::DeployKeysController#update
    │
    ├─ authorize_admin_project!
    │
    ├─ authorize_update_deploy_key!
    │
    ├─ deploy_key.update(update_params)
    │      └─ accepts_nested_attributes_for :deploy_keys_projects
    │
    └─ redirect_to_repository (成功時)
           └─ project_settings_repository_path(@project, anchor: 'js-deploy-keys-settings')
```

### データフロー図

```
[入力]               [処理]                    [出力]

タイトル ───▶ DeployKeysController#update ───▶ keys.title (UPDATE)
                        │
can_push ───▶          │───────────────────▶ deploy_keys_projects.can_push (UPDATE)
                        │
                        └─ update_params
                               ├─ title (権限チェック後)
                               └─ deploy_keys_projects_attributes
                                      └─ can_push
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deploy_keys_controller.rb | `app/controllers/projects/deploy_keys_controller.rb` | コントローラー | メインコントローラー |
| deploy_key.rb | `app/models/deploy_key.rb` | モデル | デプロイキーモデル |
| deploy_keys_project.rb | `app/models/deploy_keys_project.rb` | モデル | プロジェクト関連モデル |
| edit.html.haml | `app/views/projects/deploy_keys/edit.html.haml` | ビュー | 編集画面 |
| _form.html.haml | `app/views/shared/deploy_keys/_form.html.haml` | パーシャル | フォーム |
| key.rb | `app/models/key.rb` | モデル | 基底キーモデル |
