# 画面設計書 125-セキュリティ設定

## 概要

本ドキュメントは、GitLabプロジェクトにおけるセキュリティ設定画面の設計仕様を定義するものです。

### 本画面の処理概要

セキュリティ設定画面は、プロジェクトのセキュリティ機能の設定状態を確認し、各種セキュリティスキャン機能を有効化・設定するための画面です。SAST（静的解析）、DAST（動的解析）、依存関係スキャン、シークレット検出、コンテナスキャンなどのセキュリティ機能の状態と設定オプションを一元管理できます。

**業務上の目的・背景**：現代のソフトウェア開発では、セキュリティはコードと一緒に管理されるべき重要な要素です。DevSecOpsの実践において、開発パイプラインにセキュリティスキャンを統合することで、脆弱性を早期に発見し、セキュリティインシデントを未然に防ぐことができます。本画面は、プロジェクトで利用可能なセキュリティ機能の全体像を把握し、適切なセキュリティ対策を講じるための中心的な管理画面です。

**画面へのアクセス方法**：プロジェクトのサイドメニューから「セキュア」→「セキュリティ設定」を選択してアクセスします。URLパターンは `/:namespace/:project/-/security/configuration` です。

**主要な操作・処理内容**：
1. 各種セキュリティ機能の有効化状態確認
2. SAST（静的アプリケーションセキュリティテスト）の設定
3. DAST（動的アプリケーションセキュリティテスト）の設定
4. 依存関係スキャンの設定
5. シークレット検出の設定
6. コンテナスキャンの設定
7. 脆弱性トレーニングの設定
8. セキュリティポリシーの設定へのリンク

**画面遷移**：プロジェクトセキュリティメニューから遷移。各セキュリティ機能の「Configure」ボタンから、それぞれの詳細設定画面やCI設定エディタへ遷移します。

**権限による表示制御**：`read_security_configuration`権限を持つユーザーのみアクセス可能。セキュリティ属性の読み取りには`read_security_attribute`権限、管理には`admin_security_attributes`権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | 脆弱性スキャン | 主機能 | セキュリティ設定の管理 |
| 66 | 依存関係スキャン | 補助機能 | 依存関係スキャン設定 |
| 67 | シークレット検出 | 補助機能 | シークレット検出設定 |

## 画面種別

設定 / 一覧

## URL/ルーティング

- パス: `/:namespace/:project/-/security/configuration`
- コントローラー: `Projects::Security::ConfigurationController#show`
- HTTPメソッド: GET

## 入出力項目

本画面は主に表示と設定ナビゲーションを提供するため、直接的な入力項目は少ない。各セキュリティ機能の詳細設定は別画面で行う。

## 表示項目

### セキュリティ機能一覧

| 項目名 | 説明 |
|--------|------|
| SAST | 静的アプリケーションセキュリティテストの状態 |
| DAST | 動的アプリケーションセキュリティテストの状態 |
| 依存関係スキャン | サードパーティ依存関係の脆弱性スキャン状態 |
| コンテナスキャン | Dockerイメージの脆弱性スキャン状態 |
| シークレット検出 | コード内の秘密情報検出状態 |
| API Fuzzing | APIファジングテストの状態 |
| Coverage Fuzzing | コードカバレッジファジングの状態 |
| ライセンスコンプライアンス | ライセンス準拠チェックの状態 |

### 機能ごとの表示要素

| 項目名 | 説明 |
|--------|------|
| 機能名 | セキュリティ機能の名称 |
| 説明 | 機能の概要説明 |
| 有効状態 | Enabled/Not enabled/Not available |
| 設定ボタン | Configure/Enable/Manage等のアクションボタン |
| ドキュメントリンク | 機能の詳細ドキュメントへのリンク |

## イベント仕様

### 1-Configure/Enableボタン押下

各セキュリティ機能の設定ボタン押下時の処理:

1. 機能によって異なる遷移先へ移動
   - CI設定ファイルエディタ（パイプラインエディタ）
   - 機能固有の設定画面
   - 外部ドキュメントページ
2. 一部機能はMRを自動生成するウィザードを表示

### 2-脆弱性トレーニング設定

脆弱性トレーニングの有効化/無効化:

1. トレーニングプロバイダの選択
2. 設定の保存
3. プロジェクト設定への反映

### 3-アップグレード

一部の高度なセキュリティ機能（Ultimate限定）:

1. アップグレードパスの表示
2. 価格ページへのリンク

## データベース更新仕様

### 操作別データベース影響一覧

本画面自体はビュー表示が主であり、直接的なデータベース更新は限定的です。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| トレーニング設定変更 | project_security_settings | UPDATE | セキュリティ設定の更新（EE） |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | This feature is not available | 機能が利用不可の場合 |
| 情報 | Requires Ultimate | Ultimate限定機能の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | 403エラーページを表示 |
| プロジェクトが見つからない | 404エラーページを表示 |

## 備考

- 画面の大部分はVue.jsアプリケーション（#js-security-configuration）でレンダリング
- ConfigurationPresenterがバックエンドからフロントエンドへのデータ変換を担当
- セキュリティ機能の多くはGitLab Ultimate（EE）ライセンスが必要
- 脆弱性トレーニングドキュメントへのリンクは`vulnerability_training_docs_path`で提供
- アップグレードパスは`security_upgrade_path`で提供
- グループ単位のセキュリティ属性管理は`group_manage_attributes_path`で提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セキュリティ設定に関連するプレゼンターを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration_presenter.rb | `app/presenters/projects/security/configuration_presenter.rb` | プレゼンターの構造、to_html_data_attribute |

**読解のコツ**: ConfigurationPresenterはVue.jsコンポーネントに渡すデータを整形します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configuration_controller.rb | `app/controllers/projects/security/configuration_controller.rb` | showアクションの実装 |

**主要処理フロー**:
1. **12行目**: 権限チェック（`read_security_configuration`）
2. **14行目**: ConfigurationPresenterの生成
3. **16-20行目**: HTML/JSONレスポンスの分岐

#### Step 3: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/security/configuration/show.html.haml` | メインビューの構成 |

**主要処理フロー**:
- **4行目**: Vue.jsマウントポイント（#js-security-configuration）
- **4-11行目**: data属性でバックエンドデータをフロントエンドに渡す

#### Step 4: フロントエンドの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.js | `app/assets/javascripts/security_configuration/` | Vue.jsアプリのエントリーポイント |

### プログラム呼び出し階層図

```
Projects::Security::ConfigurationController#show
    │
    ├─ can?(current_user, :read_security_configuration, project)
    │      └─ 権限チェック
    │
    ├─ configuration_presenter
    │      └─ Projects::Security::ConfigurationPresenter.new
    │             └─ to_html_data_attribute
    │
    └─ View: show.html.haml
           └─ #js-security-configuration (Vue.js)
                  ├─ configuration data
                  ├─ vulnerability_training_docs_path
                  ├─ upgrade_path
                  ├─ project_full_path
                  ├─ group_full_path
                  ├─ can_read_attributes
                  ├─ can_manage_attributes
                  └─ group_manage_attributes_path
```

### データフロー図

```
[バックエンド]                [フロントエンド]

ConfigurationPresenter
        │
        ├─ to_html_data_attribute ───▶ data属性
        │                                   │
        │                                   ▼
        └─────────────────────────▶ Vue.js App
                                          │
                                          ├─ セキュリティ機能一覧表示
                                          ├─ 状態バッジ表示
                                          └─ アクションボタン表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configuration_controller.rb | `app/controllers/projects/security/configuration_controller.rb` | コントローラー | メインコントローラー |
| configuration_presenter.rb | `app/presenters/projects/security/configuration_presenter.rb` | プレゼンター | データ整形 |
| show.html.haml | `app/views/projects/security/configuration/show.html.haml` | ビュー | メインビュー |
| security_configuration/ | `app/assets/javascripts/security_configuration/` | JavaScript | Vue.jsアプリ |
| security_and_compliance_permissions.rb | `app/controllers/concerns/security_and_compliance_permissions.rb` | Concern | 権限処理 |
