# 画面設計書 126-使用量クォータ

## 概要

本ドキュメントは、GitLabプロジェクトにおける使用量クォータ画面の設計仕様を定義するものです。

### 本画面の処理概要

使用量クォータ画面は、プロジェクトのリソース使用状況を確認するための画面です。ストレージ使用量、リポジトリサイズ、CI/CDアーティファクトのサイズ、パッケージレジストリのサイズなど、プロジェクトが消費しているリソースの詳細を確認できます。また、転送量やObservabilityの使用状況、GitLab Pagesの使用状況なども表示されます（プランにより異なる）。

**業務上の目的・背景**：GitLabの各プランには、ストレージやデータ転送量に関するクォータ制限があります。本画面は、プロジェクト管理者がリソース使用状況を監視し、クォータ超過を事前に検知して適切な対策を講じるために必要です。大規模なリポジトリやCI/CDアーティファクトの蓄積による容量オーバーを防ぎ、プロジェクト運用の継続性を確保します。また、コスト管理の観点からも、どのリソースがどの程度使用されているかを把握することは重要です。

**画面へのアクセス方法**：プロジェクトのサイドメニューから「設定」→「使用量クォータ」を選択してアクセスします。URLパターンは `/:namespace/:project/-/usage_quotas` です。

**主要な操作・処理内容**：
1. ストレージ使用量の確認（リポジトリ、LFS、アーティファクト等の内訳）
2. ストレージ使用量の再計算リクエスト
3. 転送量の確認（EE機能）
4. Observability使用量の確認（EE機能）
5. GitLab Pages使用量の確認（EE機能）

**画面遷移**：プロジェクト設定メニューから遷移。詳細情報へのリンクからヘルプドキュメントへ遷移可能です。

**権限による表示制御**：`read_usage_quotas`権限を持つユーザーのみアクセス可能。通常はプロジェクトのOwnerとMaintainerがアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | プロジェクト統計 | 主機能 | プロジェクト使用量の表示 |

## 画面種別

一覧 / 表示

## URL/ルーティング

- パス: `/:namespace/:project/-/usage_quotas`
- コントローラー: `Projects::UsageQuotasController#index`
- HTTPメソッド: GET

## 入出力項目

本画面は主に表示を目的としており、直接的な入力項目はありません。

## 表示項目

### ストレージ使用量

| 項目名 | 説明 |
|--------|------|
| 総使用量 | プロジェクト全体のストレージ使用量 |
| リポジトリ | Gitリポジトリのサイズ |
| LFS | Git LFSオブジェクトのサイズ |
| アーティファクト | CI/CDジョブアーティファクトのサイズ |
| パッケージ | パッケージレジストリのサイズ |
| Wikiリポジトリ | Wikiのサイズ |
| スニペット | スニペットのサイズ |
| アップロード | アップロードファイルのサイズ |

### 転送量（EE機能）

| 項目名 | 説明 |
|--------|------|
| 総転送量 | 月間の総転送量 |
| リポジトリ | Gitリポジトリの転送量 |
| パッケージ | パッケージレジストリの転送量 |

### GitLab Pages（EE機能）

| 項目名 | 説明 |
|--------|------|
| 使用量 | GitLab Pagesのストレージ使用量 |

## イベント仕様

### 1-ストレージ再計算

再計算ボタン押下時の処理（JavaScript経由）:

1. バックグラウンドジョブを起動してストレージ使用量を再計算
2. 「Repository usage recalculation started」アラートを表示
3. 数分後に画面をリフレッシュして最新値を確認

## データベース更新仕様

### 操作別データベース影響一覧

本画面は主に参照のみであり、直接的なデータベース更新は行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ストレージ再計算 | project_statistics | UPDATE | バックグラウンドジョブで更新 |

### テーブル別更新項目詳細

#### project_statistics

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | repository_size | リポジトリサイズ | 表示用 |
| SELECT | lfs_objects_size | LFSサイズ | 表示用 |
| SELECT | build_artifacts_size | アーティファクトサイズ | 表示用 |
| SELECT | packages_size | パッケージサイズ | 表示用 |
| SELECT | wiki_size | Wikiサイズ | 表示用 |
| SELECT | snippets_size | スニペットサイズ | 表示用 |
| SELECT | uploads_size | アップロードサイズ | 表示用 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 情報 | Repository usage recalculation started | 再計算開始時 |
| 情報 | To view usage, refresh this page in a few minutes. | 再計算中 |
| 情報 | Usage of project resources across the [プロジェクト名] project. | 画面サブタイトル |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | 403または404エラーページを表示 |
| 統計情報が未計算 | 「計算中」または「データなし」を表示 |

## 備考

- ストレージ使用量の詳細はVue.jsアプリケーション（#js-storage-usage-app）でレンダリング
- 転送量タブ、Observabilityタブ、GitLab Pagesタブは別パーシャル/EEモジュールで提供
- `project_repositories_health_ui`フィーチャーフラグで追加機能が制御される場合がある
- レイアウトは`project_settings`を使用
- 検索設定は非表示（`@hide_search_settings = true`）
- 詳細な使用量クォータのドキュメントへのリンクが提供される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

使用量統計に関連するモデルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_statistics.rb | `app/models/project_statistics.rb` | 統計情報の構造、各サイズカラム |

**読解のコツ**: project_statisticsテーブルはプロジェクトごとの各種サイズを保持し、定期的に更新されます。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | usage_quotas_controller.rb | `app/controllers/projects/usage_quotas_controller.rb` | indexアクションの実装 |

**主要処理フロー**:
1. **5行目**: `authorize_read_usage_quotas!` - 権限チェック
2. **6-8行目**: フィーチャーフラグのプッシュ
3. **15-17行目**: `index`アクション - 検索設定非表示

#### Step 3: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/usage_quotas/index.html.haml` | メインビューの構成 |
| 3-2 | _index.html.haml | `app/views/shared/usage_quotas/_index.html.haml` | 共通レイアウト |

**主要処理フロー**:
- **1-6行目**: 再計算開始アラートの定義
- **8-13行目**: サブタイトルの定義
- **15-19行目**: タブコンテンツの定義
- **21行目**: 共通インデックスパーシャルの読み込み

### プログラム呼び出し階層図

```
Projects::UsageQuotasController#index
    │
    ├─ authorize_read_usage_quotas!
    │
    ├─ push_frontend_feature_flag(:project_repositories_health_ui)
    │
    ├─ @hide_search_settings = true
    │
    └─ View: index.html.haml
           │
           ├─ content_for :usage_quotas_alerts
           │      └─ 再計算アラート
           │
           ├─ content_for :usage_quotas_subtitle
           │      └─ プロジェクト使用量の説明
           │
           ├─ content_for :usage_quotas_tabs
           │      ├─ #js-storage-usage-app (Vue.js)
           │      ├─ transfer_tab_content (EE)
           │      ├─ observability (EE)
           │      └─ pages (EE)
           │
           └─ shared/usage_quotas/_index.html.haml
```

### データフロー図

```
[データソース]              [処理]                    [出力]

project_statistics ───▶ UsageQuotasController ───▶ JSON data属性
        │                       │
        │                       ▼
        └──────────────▶ Vue.js App (#js-storage-usage-app)
                               │
                               ├─ ストレージ使用量表示
                               ├─ カテゴリ別内訳
                               └─ 再計算トリガー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| usage_quotas_controller.rb | `app/controllers/projects/usage_quotas_controller.rb` | コントローラー | メインコントローラー |
| index.html.haml | `app/views/projects/usage_quotas/index.html.haml` | ビュー | メインビュー |
| _index.html.haml | `app/views/shared/usage_quotas/_index.html.haml` | パーシャル | 共通レイアウト |
| project_statistics.rb | `app/models/project_statistics.rb` | モデル | 統計モデル |
| storage_usage_app/ | `app/assets/javascripts/usage_quotas/storage/` | JavaScript | Vue.jsアプリ |
