# 画面設計書 127-Pages設定

## 概要

本ドキュメントは、GitLabプロジェクトにおけるPages設定画面の設計仕様を定義するものです。

### 本画面の処理概要

Pages設定画面は、GitLab Pagesの設定と管理を行うための画面です。GitLab Pagesは、プロジェクトのリポジトリから静的Webサイトを直接公開できる機能です。本画面では、Pagesのデプロイ状態の確認、カスタムドメインの設定、アクセス制御（公開/非公開）の設定、HTTPS設定などを管理できます。

**業務上の目的・背景**：GitLab Pagesは、ドキュメントサイト、プロジェクトWebサイト、静的アプリケーションなどをGitLabのインフラ上で直接ホスティングするための機能です。CI/CDパイプラインと連携して、コードプッシュ時に自動的にサイトを更新できます。本画面は、Pagesサイトのライフサイクル管理（デプロイ確認、ドメイン設定、アクセス制御、削除）を一元的に行うために必要です。

**画面へのアクセス方法**：プロジェクトのサイドメニューから「デプロイ」→「Pages」を選択してアクセスします。URLパターンは `/:namespace/:project/pages` です。なお、Pagesが未デプロイの場合はオンボーディング画面（new.html.haml）へリダイレクトされます。

**主要な操作・処理内容**：
1. Pagesデプロイ状態の確認
2. カスタムドメインの一覧表示と新規追加
3. アクセス制御設定（公開/メンバー限定）
4. HTTPS設定
5. 一意ドメインの有効化/再生成
6. プライマリドメインの設定
7. Pagesの削除

**画面遷移**：プロジェクトメニューから遷移。カスタムドメイン追加でドメイン新規作成画面（129-Pagesドメイン新規作成）へ、ドメイン詳細でドメイン詳細画面（128-Pagesドメイン詳細）へ遷移します。

**権限による表示制御**：`read_pages`権限を持つユーザーは閲覧可能。`update_pages`権限を持つユーザーは設定変更が可能。`remove_pages`権限を持つユーザーはPagesの削除が可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 129 | GitLab Pages | 主機能 | GitLab Pages設定の管理 |

## 画面種別

設定 / 一覧

## URL/ルーティング

- パス: `/:namespace/:project/pages`
- コントローラー: `Projects::PagesController#show`
- HTTPメソッド: GET（表示）、PATCH（更新）

## 入出力項目

### Pages設定フォーム

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| HTTPS強制 | pages_https_only | 入力 | boolean | - | HTTPSのみを強制するか |
| 一意ドメイン有効化 | pages_unique_domain_enabled | 入力 | boolean | - | 一意ドメインを使用するか |
| プライマリドメイン | pages_primary_domain | 入力 | select | - | プライマリとして使用するドメイン |

## 表示項目

### Pages概要タブ

| 項目名 | 説明 |
|--------|------|
| アクセスURL | Pagesサイトのアクセス先URL |
| デプロイ状態 | 現在のデプロイ状態 |
| 最終デプロイ日時 | 最後にデプロイされた日時 |
| 一意ドメイン | プロジェクト固有のサブドメイン |

### ドメイン設定タブ

| 項目名 | 説明 |
|--------|------|
| カスタムドメイン一覧 | 設定済みカスタムドメインのリスト |
| ドメイン名 | カスタムドメイン名 |
| 検証状態 | ドメイン所有権の検証状態 |
| 証明書状態 | SSL証明書の状態（Let's Encrypt/ユーザー提供） |
| 操作 | 編集・削除ボタン |

## イベント仕様

### 1-設定保存

「Save changes」ボタン（設定セクション）押下時の処理:

1. フォームバリデーション実行
2. Project設定およびProjectSetting更新
3. 成功時: 「Your changes have been saved」メッセージを表示
4. 失敗時: エラーメッセージを表示

### 2-一意ドメイン再生成

「Regenerate unique domain」ボタン押下時の処理:

1. 権限チェック（update_pages）
2. 一意ドメイン有効化状態チェック
3. 新しい一意ドメインを生成
4. 成功時: 「Successfully regenerated unique domain」メッセージを表示
5. 失敗時: 「Failed to regenerate unique domain」メッセージを表示

### 3-Pages削除

「Delete Pages」ボタン押下時の処理:

1. 確認処理
2. `Pages::DeleteService`でPages削除
3. 成功時: 「Pages were scheduled for removal」メッセージを表示し、Pages画面へリダイレクト

### 4-カスタムドメイン追加

「Add domain」ボタン押下時の処理:

1. ドメイン新規作成画面（129-Pagesドメイン新規作成）へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | projects | UPDATE | pages_https_only設定 |
| 設定保存 | project_settings | UPDATE | pages_unique_domain_enabled, pages_primary_domain |
| 一意ドメイン再生成 | project_settings | UPDATE | pages_unique_domain |
| Pages削除 | pages_deployments | DELETE | デプロイ情報の削除 |
| Pages削除 | pages_domains | DELETE | カスタムドメインの削除 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | pages_https_only | チェックボックス状態 | HTTPS強制設定 |

#### project_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | pages_unique_domain_enabled | チェックボックス状態 | 一意ドメイン有効化 |
| UPDATE | pages_unique_domain | 生成されたドメイン文字列 | 再生成時 |
| UPDATE | pages_primary_domain | 選択したドメイン | プライマリドメイン設定 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | Your changes have been saved | 設定保存成功時 |
| 成功 | Successfully regenerated unique domain | 一意ドメイン再生成成功時 |
| 成功 | Pages were scheduled for removal | Pages削除成功時 |
| エラー | Failed to regenerate unique domain | 一意ドメイン再生成失敗時 |
| 警告 | SSL limitations warning | サブドメインにドットを含む場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | 403エラーまたは機能を非表示 |
| Pagesが未デプロイ | オンボーディング画面へリダイレクト |
| Pages機能が無効 | Pages機能無効エラーを表示 |

## 備考

- Pagesデプロイ状態によって表示内容が変わる（`pages_deployed?`で判定）
- 未デプロイ時は「waiting」パーシャルを表示
- 概要タブはVue.jsアプリ（#js-pages）でレンダリング
- カスタムドメインは`Gitlab.config.pages.custom_domain_mode`設定で有効化される
- サブドメインにドットを含む場合はSSL制限の警告が表示される
- Pagesドメインは`present`メソッドでプレゼンターオブジェクトとして提供される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Pages関連のモデルを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages_domain.rb | `app/models/pages_domain.rb` | カスタムドメインモデルの構造 |
| 1-2 | project_setting.rb | `app/models/project_setting.rb` | Pages関連設定カラム |

**読解のコツ**: pages_domainsテーブルがカスタムドメイン、project_settingsテーブルがPages設定を保持します。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pages_controller.rb | `app/controllers/projects/pages_controller.rb` | show/update/destroyアクション |

**主要処理フロー**:
1. **4行目**: `require_pages_enabled!` - Pages機能有効チェック
2. **5-7行目**: 各アクションの権限チェック
3. **19-28行目**: `show`アクション - デプロイ状態判定とドメイン取得
4. **40-54行目**: `update`アクション - 設定更新処理

#### Step 3: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/pages/show.html.haml` | メインビューの構成 |

**主要処理フロー**:
- **3-4行目**: デプロイ状態による分岐
- **8-12行目**: タブ構成（Overview, Domains & settings）
- **14-31行目**: タブコンテンツ

### プログラム呼び出し階層図

```
Projects::PagesController#show
    │
    ├─ require_pages_enabled!
    │
    ├─ authorize_read_pages!
    │
    ├─ pages_show_onboarding?
    │      └─ true → redirect_to action: 'new'
    │
    ├─ pages_deployed?
    │      ├─ false → render 'waiting'
    │      └─ true → render 'show' with tabs
    │
    ├─ @domains = @project.pages_domains.order(:domain).present
    │
    └─ View: show.html.haml
           ├─ _header.html.haml
           ├─ Tab: Overview
           │      └─ #js-pages (Vue.js)
           └─ Tab: Domains & settings
                  ├─ _ssl_limitations_warning.html.haml
                  ├─ _list.html.haml (ドメイン一覧)
                  ├─ _access.html.haml
                  ├─ _pages_settings.html.haml
                  └─ _destroy.html.haml
```

### データフロー図

```
[入力]               [処理]                    [出力]

設定フォーム ───▶ PagesController#update ───▶ projects (UPDATE)
                        │                        project_settings (UPDATE)
                        │
                        └─ Projects::UpdateService

再生成ボタン ───▶ PagesController#regenerate_unique_domain ───▶ project_settings (UPDATE)
                        │
                        └─ Gitlab::Pages.generate_unique_domain

削除ボタン ───▶ PagesController#destroy ───▶ Pages::DeleteService
                        │
                        └─ pages_deployments, pages_domains (DELETE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pages_controller.rb | `app/controllers/projects/pages_controller.rb` | コントローラー | メインコントローラー |
| show.html.haml | `app/views/projects/pages/show.html.haml` | ビュー | メインビュー |
| _waiting.html.haml | `app/views/projects/pages/_waiting.html.haml` | パーシャル | 待機画面 |
| _header.html.haml | `app/views/projects/pages/_header.html.haml` | パーシャル | ヘッダー |
| _list.html.haml | `app/views/projects/pages/_list.html.haml` | パーシャル | ドメイン一覧 |
| _access.html.haml | `app/views/projects/pages/_access.html.haml` | パーシャル | アクセス設定 |
| _pages_settings.html.haml | `app/views/projects/pages/_pages_settings.html.haml` | パーシャル | Pages設定 |
| _destroy.html.haml | `app/views/projects/pages/_destroy.html.haml` | パーシャル | 削除セクション |
| pages_domain.rb | `app/models/pages_domain.rb` | モデル | ドメインモデル |
| delete_service.rb | `app/services/pages/delete_service.rb` | サービス | 削除処理 |
