# 画面設計書 128-Pagesドメイン詳細

## 概要

本ドキュメントは、GitLabプロジェクトにおけるPagesドメイン詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

Pagesドメイン詳細画面は、GitLab Pagesに設定されたカスタムドメインの詳細情報確認と設定編集を行うための画面です。ドメインの検証状態、DNS設定情報、SSL証明書の設定（自動/手動）、検証コードの確認などが可能です。

**業務上の目的・背景**：カスタムドメインをGitLab Pagesで使用するには、ドメイン所有権の検証とSSL証明書の設定が必要です。本画面は、これらの設定を行い、設定状態を確認するために必要です。ドメイン所有権の検証はDNSレコードを使用して行われ、TXTレコードを追加することで所有を証明します。SSL証明書はLet's Encryptによる自動取得、またはユーザー提供の証明書を設定できます。

**画面へのアクセス方法**：Pages設定画面（127-Pages設定）のドメイン一覧から特定のドメインをクリックして遷移します。URLパターンは `/:namespace/:project/pages/domains/:domain` です。

**主要な操作・処理内容**：
1. ドメイン情報の確認（URL、検証状態、証明書状態）
2. DNS設定情報の確認（CNAMEレコード、TXTレコード）
3. ドメイン検証の実行
4. SSL証明書の設定（Let's Encrypt自動/ユーザー提供）
5. SSL証明書の削除（クリア）
6. Let's Encrypt証明書の再取得リトライ
7. ドメイン設定の更新

**画面遷移**：Pages設定画面から遷移。保存後はPages設定画面へリダイレクトされます。キャンセルボタンでも同様にリダイレクトされます。

**権限による表示制御**：`update_pages`権限を持つユーザーのみアクセス可能。ドメインの編集・削除操作には同権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 130 | Pagesドメイン管理 | 主機能 | カスタムドメインの詳細表示 |

## 画面種別

詳細 / 編集

## URL/ルーティング

- パス: `/:namespace/:project/pages/domains/:domain`
- コントローラー: `Projects::PagesDomainsController#show`
- HTTPメソッド: GET（表示）、PATCH（更新）

## 入出力項目

### ドメイン設定フォーム

| 項目名 | 項目ID | 入出力 | 型 | 必須 | 説明 |
|--------|--------|--------|-----|------|------|
| ドメイン名 | domain | 表示 | string | - | カスタムドメイン名（読み取り専用） |
| 自動SSL有効化 | auto_ssl_enabled | 入力 | boolean | - | Let's Encryptによる自動SSL |
| 証明書 | user_provided_certificate | 入力 | text | - | ユーザー提供のSSL証明書（PEM形式） |
| 秘密鍵 | user_provided_key | 入力 | text | - | 証明書の秘密鍵（PEM形式） |

## 表示項目

### ドメイン情報

| 項目名 | 説明 |
|--------|------|
| ドメインURL | カスタムドメインのアクセスURL |
| 検証状態 | Verified/Unverified |
| 有効状態 | Enabled/Disabled |

### DNS設定情報

| 項目名 | 説明 |
|--------|------|
| CNAMEレコード | 設定すべきCNAMEレコードの値 |
| TXTレコード | ドメイン検証用TXTレコードの値 |
| 検証ドメイン | TXTレコードを設定するホスト名 |

### SSL証明書情報

| 項目名 | 説明 |
|--------|------|
| 証明書ソース | Let's Encrypt/User provided |
| 有効期限 | 証明書の有効期限日 |
| サブジェクト | 証明書のサブジェクト情報 |
| 自動SSL状態 | 自動SSLの有効/無効/失敗状態 |

## イベント仕様

### 1-設定保存

「Save changes」ボタン押下時の処理:

1. フォームバリデーション実行
2. 証明書の整合性チェック（証明書と秘密鍵のマッチング）
3. `Pages::Domains::UpdateService`でドメイン更新
4. 成功時: 「Domain was updated」メッセージを表示し、Pages設定画面へリダイレクト
5. 失敗時: エラーメッセージを表示し、編集画面を再表示

### 2-ドメイン検証

「Verify」ボタン（または検証リクエスト）押下時の処理:

1. `VerifyPagesDomainService`によるドメイン検証
2. DNS TXTレコードの確認
3. 成功時: 「Successfully verified domain ownership」メッセージを表示
4. 失敗時: 「Failed to verify domain ownership」メッセージを表示

### 3-Let's Encrypt証明書リトライ

「Retry」ボタン押下時の処理:

1. `Pages::Domains::RetryAcmeOrderService`による証明書取得リトライ
2. Let's Encryptへの証明書要求
3. 画面をリフレッシュして状態を確認

### 4-証明書クリア

「Clean certificate」リンク押下時の処理:

1. ユーザー提供証明書の削除
2. user_provided_certificate, user_provided_keyをnullに設定
3. 画面をリフレッシュ

### 5-キャンセル

「Cancel」ボタン押下時の処理:

1. 入力内容を破棄
2. Pages設定画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定保存 | pages_domains | UPDATE | ドメイン設定の更新 |
| 検証成功 | pages_domains | UPDATE | verified_at, enabled_untilの更新 |
| 証明書クリア | pages_domains | UPDATE | 証明書関連カラムをnullに |

### テーブル別更新項目詳細

#### pages_domains

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | auto_ssl_enabled | チェックボックス状態 | Let's Encrypt自動取得 |
| UPDATE | certificate | PEM形式証明書 | ユーザー提供時 |
| UPDATE | key | PEM形式秘密鍵（暗号化） | ユーザー提供時 |
| UPDATE | certificate_source | 'user_provided' / 'gitlab_provided' | |
| UPDATE | verified_at | 検証成功時のタイムスタンプ | 検証成功時 |
| UPDATE | enabled_until | 有効期限 | 検証成功時 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|-----------|----------|
| 成功 | Domain was updated | 設定更新成功時 |
| 成功 | Successfully verified domain ownership | 検証成功時 |
| エラー | Failed to verify domain ownership | 検証失敗時 |
| 警告 | This domain is not verified. You will need to verify ownership before access is enabled. | 未検証ドメインの場合 |
| 情報 | Support for custom certificates is disabled. Ask your system's administrator to enable it. | カスタム証明書が無効な場合 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足 | 403エラーを表示 |
| ドメインが見つからない | 404エラーを表示 |
| 証明書と秘密鍵の不一致 | バリデーションエラーを表示 |
| 証明書形式エラー | バリデーションエラーを表示 |

## 備考

- ドメイン名自体は編集不可（読み取り専用）
- 検証コードはプロジェクト作成時に生成され、`gitlab-pages-verification-code`プレフィックスが付く
- SSL証明書の秘密鍵は暗号化して保存（attr_encrypted）
- Let's Encrypt証明書は自動更新される（30日前から更新処理）
- 検証は定期的に再確認され、3日以内に再検証が必要
- 証明書の最大キー長は8192バイト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Pagesドメインモデルの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages_domain.rb | `app/models/pages_domain.rb` | ドメインモデルの構造、検証・証明書関連メソッド |

**読解のコツ**: `verification_code`, `verified_at`, `enabled_until`, `auto_ssl_enabled`などのカラムが検証とSSL管理の核心です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pages_domains_controller.rb | `app/controllers/projects/pages_domains_controller.rb` | show/update/verifyアクション |

**主要処理フロー**:
1. **7行目**: `authorize_update_pages!` - 権限チェック
2. **8行目**: `domain` before_action - ドメインの取得
3. **14-18行目**: `show`アクション - 未検証警告表示
4. **56-66行目**: `update`アクション - 設定更新処理
5. **24-33行目**: `verify`アクション - ドメイン検証

#### Step 3: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/pages_domains/show.html.haml` | 詳細画面のメインビュー |
| 3-2 | _form.html.haml | `app/views/projects/pages_domains/_form.html.haml` | フォーム部分 |
| 3-3 | _dns.html.haml | `app/views/projects/pages_domains/_dns.html.haml` | DNS設定情報 |
| 3-4 | _certificate.html.haml | `app/views/projects/pages_domains/_certificate.html.haml` | 証明書設定 |

### プログラム呼び出し階層図

```
Projects::PagesDomainsController#show
    │
    ├─ authorize_update_pages!
    │
    ├─ domain (@project.pages_domains.find_by_domain!)
    │
    ├─ domain_presenter (domain.present)
    │
    ├─ needs_verification? → flash[:warning]
    │
    └─ View: show.html.haml
           ├─ _helper_text.html.haml
           ├─ _form.html.haml
           │      ├─ _dns.html.haml (検証済み時)
           │      └─ _certificate.html.haml
           ├─ Save changes button
           └─ Cancel button

Projects::PagesDomainsController#verify
    │
    ├─ VerifyPagesDomainService#execute
    │
    └─ redirect with flash

Projects::PagesDomainsController#update
    │
    ├─ Pages::Domains::UpdateService#execute
    │
    └─ redirect or re-render
```

### データフロー図

```
[入力]               [処理]                    [出力]

auto_ssl_enabled ───▶ PagesDomainsController#update ───▶ pages_domains (UPDATE)
certificate     ───▶        │
key             ───▶        │
                            └─ Pages::Domains::UpdateService

Verify button ───▶ PagesDomainsController#verify ───▶ pages_domains.verified_at (UPDATE)
                        │
                        └─ VerifyPagesDomainService
                               └─ DNS TXTレコード確認

Retry button ───▶ PagesDomainsController#retry_auto_ssl ───▶ ACME order
                        │
                        └─ Pages::Domains::RetryAcmeOrderService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pages_domains_controller.rb | `app/controllers/projects/pages_domains_controller.rb` | コントローラー | メインコントローラー |
| show.html.haml | `app/views/projects/pages_domains/show.html.haml` | ビュー | 詳細画面 |
| _form.html.haml | `app/views/projects/pages_domains/_form.html.haml` | パーシャル | フォーム |
| _dns.html.haml | `app/views/projects/pages_domains/_dns.html.haml` | パーシャル | DNS情報 |
| _certificate.html.haml | `app/views/projects/pages_domains/_certificate.html.haml` | パーシャル | 証明書設定 |
| pages_domain.rb | `app/models/pages_domain.rb` | モデル | ドメインモデル |
| verify_pages_domain_service.rb | `app/services/verify_pages_domain_service.rb` | サービス | 検証処理 |
| update_service.rb | `app/services/pages/domains/update_service.rb` | サービス | 更新処理 |
| retry_acme_order_service.rb | `app/services/pages/domains/retry_acme_order_service.rb` | サービス | 証明書リトライ |
