# 画面設計書 13-課題一覧

## 概要

本ドキュメントは、GitLabダッシュボードの課題一覧画面（Dashboard Issues）の画面設計を定義したものである。

### 本画面の処理概要

ログインユーザーに関連する課題（Issue）の一覧を横断的に表示し、タスク管理を支援するダッシュボード画面である。

**業務上の目的・背景**：開発者やプロジェクトマネージャーは、複数のプロジェクトにまたがる課題を管理する必要がある。本画面は、ユーザーに割り当てられた課題、作成した課題、メンションされた課題などを一元的に確認できる。これにより、プロジェクト横断的なタスク管理と優先順位付けが可能になる。

**画面へのアクセス方法**：ログイン後、サイドバーまたはトップナビゲーションから「Issues」メニューを選択。直接URLアクセスの場合は `/dashboard/issues` へアクセスする。

**主要な操作・処理内容**：
1. 課題一覧の表示（ページネーション対応）
2. 課題のフィルタリング（Assigned、Created、Mentionedなど）
3. ラベル・マイルストーン・状態による絞り込み
4. ソート順の変更（作成日、更新日、Due date等）
5. 各課題の詳細画面への遷移
6. 新規課題作成画面への遷移
7. ATOMフィードによるRSS購読

**画面遷移**：
- 遷移元：ログイン画面、サイドバー、トップナビゲーション
- 遷移先：課題詳細画面、課題新規作成画面

**権限による表示制御**：ログインユーザーのみアクセス可能。表示される課題はユーザーがアクセス権限を持つプロジェクトの課題に限定される。フィルタ条件が設定されていない場合は、デフォルトで自分に割り当てられた課題が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 124 | Todoリスト | 主機能 | 割り当てられた課題の一覧表示 |
| 36 | イシュー作成 | 遷移先機能 | 課題詳細画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/dashboard/issues` | GET | 課題一覧（HTML） |
| `/dashboard/issues.atom` | GET | 課題一覧（ATOMフィード） |
| `/dashboard/issues.ics` | GET | 課題カレンダー（ICS形式） |

## 入出力項目

### 入力項目（検索・フィルタ）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| assignee_username | string | No | 担当者でフィルタ |
| author_username | string | No | 作成者でフィルタ |
| state | string | No | 状態（opened, closed, all） |
| label_name | string[] | No | ラベルでフィルタ |
| milestone_title | string | No | マイルストーンでフィルタ |
| sort | string | No | ソート順 |
| search | string | No | 検索キーワード |
| page | integer | No | ページ番号 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| issues | Array | 課題一覧 |
| @state | string | 現在の状態フィルタ |
| @sort | string | 現在のソート順 |

## 表示項目

### 課題一覧

| 項目名 | 説明 | 備考 |
|--------|------|------|
| 課題タイトル | 課題のタイトル | リンク |
| プロジェクト名 | 所属プロジェクトのフルパス | リンク |
| ラベル | 課題に設定されたラベル | バッジ表示 |
| マイルストーン | 関連マイルストーン | |
| 担当者 | 課題の担当者 | アバター表示 |
| Due date | 期限日 | |
| 作成日時 | 課題作成日時 | 相対時間表示 |
| 更新日時 | 最終更新日時 | 相対時間表示 |
| コメント数 | コメント数 | アイコン付き |
| リアクション数 | 絵文字リアクション数 | |
| 状態 | Open/Closed | アイコン表示 |

## イベント仕様

### 1-課題リストの読み込み

Vue.jsアプリケーション（`.js-issues-dashboard`）がマウントされ、APIを通じて課題一覧を取得する。

**処理フロー**：
1. ページ読み込み時にVueアプリケーションが初期化
2. `dashboard_issues_list_data`からアプリケーション設定を取得
3. IssuableFinderを通じて課題一覧を非同期取得
4. フィルタ・ソート条件に基づいてリストを表示

### 2-フィルタ変更

フィルタ条件を変更すると、URLパラメータが更新され、課題一覧が再取得される。

### 3-ソート順変更

ソート条件を変更すると、URLパラメータが更新され、課題一覧が再取得される。

### 4-新規課題作成

「New issue」ボタンをクリックすると、プロジェクト選択ドロップダウンが表示され、選択後に課題作成画面へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | issues | SELECT | フィルタ条件に合致する課題を取得 |
| ページ表示 | label_links | SELECT | 課題に関連するラベルを取得 |
| ページ表示 | milestones | SELECT | 関連マイルストーン情報を取得 |

### テーブル別更新項目詳細

#### issues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, state, author_id, assignee_id, milestone_id, due_date, created_at, updated_at | IssuesFinder経由 | フィルタ条件による絞り込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | "No issues found" | 検索結果が0件の場合 |
| MSG-002 | 情報 | "Select a filter to see issues" | フィルタ未設定時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 未ログイン | ログイン画面へリダイレクト | - |
| フィルタ未設定 | フィルタ選択を促すメッセージ表示 | "Select a filter to see issues" |
| API通信エラー | エラーメッセージ表示 | "Something went wrong. Please try again." |

## 備考

- Vue.jsベースのSPA実装（`.js-issues-dashboard`）
- ATOMフィード/ICSカレンダーによるRSS購読・カレンダー連携に対応
- SAML再認証が必要なグループの通知表示機能あり（EE機能）
- PageHeadingComponentによる統一されたページヘッダー
- 新規課題作成時はプロジェクト選択UIを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、課題のデータ構造とFinderパターンを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | Issueモデルの定義、アソシエーション |
| 1-2 | issues_finder.rb | `app/finders/issues_finder.rb` | 課題検索ロジック、フィルタリング条件 |

**読解のコツ**: IssueはIssuableモジュールを含み、ラベル、マイルストーン、担当者など多くの関連を持つ。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dashboard_controller.rb | `app/controllers/dashboard_controller.rb` | issuesアクション、IssuableCollectionsAction concern |

**主要処理フロー**:
1. **Line 9**: `prepend_before_action`でRSS認証を処理
2. **Line 10**: ICS形式のカレンダー認証
3. **Line 13-15**: before_actionでプロジェクト取得、表示設定、フィルタチェック

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | issues.html.haml | `app/views/dashboard/issues.html.haml` | HAMLテンプレート、Vue.jsアプリのマウントポイント |

**主要処理フロー**:
- **Line 1-6**: ページタイトル、ブレッドクラム、スタイル設定
- **Line 14-16**: PageHeadingComponentとアクションボタン
- **Line 18**: Vue.jsアプリのマウント

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dashboard.rb | `config/routes/dashboard.rb` | ダッシュボード課題関連のルート定義 |

**主要処理フロー**:
- **Line 5-6**: ICS/HTML形式の課題ルート定義

### プログラム呼び出し階層図

```
DashboardController#issues
    |
    +-- authenticate_sessionless_user!(:rss) [ATOMフィード時]
    |
    +-- authenticate_sessionless_user!(:ics) [ICSカレンダー時]
    |
    +-- projects (before_action)
    |
    +-- set_show_full_reference (before_action)
    |
    +-- check_filters_presence! (before_action)
    |
    +-- render 'dashboard/issues'
           |
           +-- render ::Layouts::PageHeadingComponent
           |
           +-- render 'shared/new_project_item_vue_select'
           |
           +-- .js-issues-dashboard (Vue.js)
                  |
                  +-- dashboard_issues_list_data (ヘルパー)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ DashboardController#issues ───▶ HTMLレスポンス
(assignee,                |                         (Vue.jsアプリ)
 state, sort等)           |
                          v
                    IssuesFinder
                          |
                          v
                    Issue (Model)
                          |
                          v
                    PostgreSQL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dashboard_controller.rb | `app/controllers/dashboard_controller.rb` | コントローラ | リクエスト処理 |
| issues.html.haml | `app/views/dashboard/issues.html.haml` | ビュー | 画面テンプレート |
| issues_finder.rb | `app/finders/issues_finder.rb` | ファインダー | 課題検索ロジック |
| issue.rb | `app/models/issue.rb` | モデル | 課題データ定義 |
| dashboard.rb | `config/routes/dashboard.rb` | ルート | URL定義 |
| issuable_collections_action.rb | `app/controllers/concerns/issuable_collections_action.rb` | Concern | Issuable共通処理 |
