# 画面設計書 130-Runner一覧

## 概要

本ドキュメントは、GitLabプロジェクトにおけるRunner詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

Runner一覧画面（プロジェクトRunner詳細）は、プロジェクトで使用可能なCI/CD Runnerの詳細情報を表示するための画面です。Runnerの状態（オンライン/オフライン/停止中）、タグ、実行中のジョブ、関連するプロジェクトなどの詳細情報を確認できます。

**業務上の目的・背景**：CI/CD Runnerは、GitLabパイプラインのジョブを実行する重要なコンポーネントです。本画面は、プロジェクトで使用しているRunnerの健全性と設定状態を確認し、問題発生時の診断やRunner管理を行うために必要です。Runnerの接続状態、タグ設定、実行ステータスを把握することで、パイプラインの実行環境を適切に維持管理できます。

**画面へのアクセス方法**：プロジェクトのCI/CD設定画面のRunner一覧から特定のRunnerをクリックして遷移します。URLパターンは `/:namespace/:project/-/runners/:id` です。

**主要な操作・処理内容**：
1. Runnerの詳細情報表示（ID、説明、タイプ、状態など）
2. Runnerの編集画面への遷移
3. Runnerの状態確認（オンライン/オフライン/停止中/ステイル）
4. 関連するプロジェクト/グループの確認

**画面遷移**：CI/CD設定画面から遷移。編集ボタンで編集画面（132-Runner編集）へ遷移。パンくずリストからCI/CD設定画面へ戻ることができます。

**権限による表示制御**：`read_runner`権限を持つユーザーのみアクセス可能。編集操作には`update_runner`権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | Runnerレジストレーション | 主機能 | プロジェクトRunnerの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/:namespace/:project/-/runners/:id`
- コントローラー: `Projects::RunnersController#show`
- HTTPメソッド: GET

## 入出力項目

本画面は詳細表示が主目的であり、直接的な入力項目はありません。

## 表示項目

### Runner基本情報

| 項目名 | 説明 |
|--------|------|
| Runner ID | Runnerの一意識別子（#形式で表示） |
| 説明 | Runnerの説明文 |
| ステータス | オンライン/オフライン/停止中（paused）/ステイル/未接続 |
| 最終接続日時 | Runnerが最後にGitLabと通信した日時 |
| タイプ | Instance/Group/Project（Runnerの種別） |
| タグ | Runnerに設定されているタグリスト |
| 実行環境 | Runnerが動作するプラットフォーム情報 |
| IPアドレス | Runnerが接続しているIPアドレス |
| バージョン | GitLab Runnerのバージョン |

### 設定情報

| 項目名 | 説明 |
|--------|------|
| 保護ブランチのみ | 保護ブランチのジョブのみ実行するか |
| タグなしジョブ | タグなしジョブを実行するか |
| ロック状態 | 現在のプロジェクトにロックされているか |
| 最大タイムアウト | ジョブの最大実行時間 |

### 関連プロジェクト（プロジェクトRunnerの場合）

| 項目名 | 説明 |
|--------|------|
| プロジェクト名 | Runnerを使用しているプロジェクト |
| パス | プロジェクトのフルパス |

## イベント仕様

### 1-編集ボタン押下

「Edit」ボタン押下時の処理:

1. Runner編集画面へ遷移
2. `edit_project_runner_path`へリダイレクト

### 2-パンくずリスト遷移

「CI/CD Settings」リンク押下時の処理:

1. CI/CD設定画面へ遷移
2. `project_settings_ci_cd_path`へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

本画面は参照のみであり、データベースの更新は行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | ci_runners | SELECT | Runner情報の取得 |
| 表示 | ci_runner_projects | SELECT | 関連プロジェクトの取得 |
| 表示 | ci_runner_namespaces | SELECT | 関連グループの取得 |

## メッセージ仕様

本画面では特定のメッセージ表示はありません。情報表示が主目的です。

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 権限不足（read_runner） | アクセス拒否エラーを表示 |
| Runnerが見つからない | 404エラーページを表示 |

## 備考

- 画面の大部分はVue.jsアプリケーション（#js-project-runner-show）でレンダリング
- Runner IDはトークンの先頭8文字（short_sha）で表示される場合がある
- Runnerの状態は定期的に更新され、2時間以上接続がない場合はオフラインとなる
- 7日以上接続がない場合はステイル（stale）状態となる
- プロジェクトRunnerは複数のプロジェクトに割り当て可能
- Runner詳細からCI/CD設定へ戻るパスは`project_settings_ci_cd_path`を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Runnerモデルの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runner.rb | `app/models/ci/runner.rb` | Runnerモデルの基本構造、状態管理、関連 |

**読解のコツ**: `runner_type`（instance_type, group_type, project_type）、`status`（online, offline, stale, never_contacted）の定義を理解することが重要です。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | runners_controller.rb | `app/controllers/projects/runners_controller.rb` | showアクションの実装 |

**主要処理フロー**:
1. **9-11行目**: `authorize_runner!(:read_runner)` - 閲覧権限チェック
2. **58行目**: `show`アクション - 空実装（ビュー表示のみ）
3. **79-81行目**: `runner`メソッド - Runnerの取得

#### Step 3: ビューの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/runners/show.html.haml` | 詳細画面のメインビュー |

**主要処理フロー**:
- **1-5行目**: パンくずリスト設定
- **7行目**: Vue.jsマウントポイント（#js-project-runner-show）

#### Step 4: フロントエンドの構成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | project_runner_show/ | `app/assets/javascripts/ci/runner/project_runner_show/` | Vue.jsアプリのエントリーポイント |

### プログラム呼び出し階層図

```
Projects::RunnersController#show
    │
    ├─ authorize_runner!(:read_runner)
    │      └─ can?(current_user, :read_runner, runner)
    │
    ├─ runner (Ci::Runner.find)
    │
    └─ View: show.html.haml
           │
           ├─ breadcrumb設定
           │      └─ CI/CD Settings
           │
           └─ #js-project-runner-show (Vue.js)
                  │
                  ├─ runner_id: @runner.id
                  ├─ runners_path: project_settings_ci_cd_path
                  └─ edit_path: edit_project_runner_path
```

### データフロー図

```
[データソース]              [処理]                    [出力]

ci_runners ───▶ RunnersController#show ───▶ data属性
        │               │
        │               ▼
        └──────▶ Vue.js App (#js-project-runner-show)
                        │
                        ├─ GraphQL Query (runnerDetails)
                        │
                        ├─ Runner基本情報表示
                        ├─ ステータス表示
                        ├─ タグ表示
                        └─ 関連プロジェクト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| runners_controller.rb | `app/controllers/projects/runners_controller.rb` | コントローラー | メインコントローラー |
| show.html.haml | `app/views/projects/runners/show.html.haml` | ビュー | 詳細画面 |
| runner.rb | `app/models/ci/runner.rb` | モデル | Runnerモデル |
| runner_project.rb | `app/models/ci/runner_project.rb` | モデル | プロジェクト関連 |
| runner_namespace.rb | `app/models/ci/runner_namespace.rb` | モデル | グループ関連 |
| project_runner_show/ | `app/assets/javascripts/ci/runner/project_runner_show/` | JavaScript | Vue.jsアプリ |
| runner_details.graphql | GraphQL | クエリ | Runner詳細取得 |
