# 画面設計書 134-インポート設定

## 概要

本ドキュメントは、GitLabにおけるプロジェクトインポート状態表示画面の設計を定義するものである。

### 本画面の処理概要

**業務上の目的・背景**：外部リポジトリやGitLabエクスポートファイルからプロジェクトをインポートする際、その進行状況を確認する必要がある。この画面では、インポートジョブの実行状態をリアルタイムで表示し、ユーザーがインポート完了を待機できるようにする。インポートは時間がかかる処理であり、ユーザーに進捗フィードバックを提供することで、操作の確実性と安心感を向上させる。

**画面へのアクセス方法**：プロジェクト作成時にインポートを選択した後、自動的にこの画面にリダイレクトされる。または、インポート開始画面からインポートを実行した後にリダイレクトされる。URLパスは `/:namespace/:project/import` となる。

**主要な操作・処理内容**：
1. インポートジョブの進行状況を表示
2. インポート元リポジトリURL（外部インポートの場合）を表示
3. 自動リフレッシュでインポート完了を検知
4. インポート完了時にプロジェクト画面へリダイレクト
5. インポート失敗時にインポート開始画面へリダイレクト

**画面遷移**：
- 遷移元：プロジェクト新規作成画面（インポート選択）、インポート開始画面
- 遷移先：プロジェクト詳細画面（成功時）、インポート開始画面（失敗時）、continue_params指定先（設定時）

**権限による表示制御**：プロジェクトの管理者権限（`admin_project`）を持つユーザー、またはネームスペースへのインポート権限（`import_projects`）を持つユーザーがアクセスできる。テンプレートからの作成の場合は、ネームスペースへのプロジェクト作成権限（`create_projects`）が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | プロジェクトインポート状態の表示 |

## 画面種別

詳細（状態表示）

## URL/ルーティング

| メソッド | パス | コントローラ#アクション |
|---------|------|------------------------|
| GET | `/:namespace_id/:project_id/import` | `projects/imports#show` |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入出力 | バリデーション | 説明 |
|--------|--------|-----|------|--------|---------------|------|
| プロジェクトID | project_id | String | Yes | 入力 | プロジェクト存在チェック | インポート対象プロジェクト |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ページタイトル | page_title | String | import_in_progress_titleヘルパーで生成 |
| ローディングアイコン | - | Icon | 読み込み中を示すアイコン |
| インポート状態メッセージ | - | String | import_in_progress_titleヘルパーで生成 |
| Gitクローンコマンド | - | String | 外部インポート時のgit cloneコマンド表示 |
| 待機メッセージ | - | String | import_wait_and_refresh_messageヘルパーで生成 |

## イベント仕様

### 1-自動リフレッシュ

**トリガー**：ページ読み込み後、JavaScriptによる定期リフレッシュ

**処理フロー**：
1. ページ読み込み完了後、インポート状態をチェック
2. 定期的に（またはWebSocket経由で）インポート状態を確認
3. インポート完了時：continue_paramsの遷移先、またはプロジェクト詳細画面へリダイレクト
4. インポート失敗時：インポート開始画面へリダイレクト
5. インポート中：引き続き待機表示を継続

### 2-インポート完了検知

**トリガー**：import_finished? が true を返す

**処理フロー**：
1. continue_params[:to] が設定されている場合、その URL へリダイレクト
2. continue_params[:notice] が設定されている場合、フラッシュメッセージを表示
3. 設定がない場合、プロジェクト詳細画面へリダイレクト
4. フォークの場合は「The project was successfully forked.」、通常インポートは「The project was successfully imported.」を表示

### 3-インポート失敗検知

**トリガー**：import_failed? が true を返す

**処理フロー**：
1. インポート開始画面（new_project_import_path）へリダイレクト
2. ユーザーは再度インポート設定を行う

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 状態表示 | projects | SELECT | インポート状態の確認 |
| 状態表示 | project_import_state | SELECT | インポート状態詳細の取得 |

この画面自体はデータベースの更新を行わない（読み取り専用）。インポート処理はバックグラウンドジョブで実行される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | The project was successfully imported. | インポート完了時（通常） |
| MSG002 | 成功 | The project was successfully forked. | インポート完了時（フォーク） |
| MSG003 | 情報 | import_wait_and_refresh_message | インポート進行中 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| プロジェクト未検出 | 404 Not Found | Not Found画面 |
| 権限不足 | 404 Not Found（render_404） | Not Found画面 |
| インポートなし（リポジトリ存在） | リダイレクト | プロジェクト詳細画面 |
| インポート失敗 | リダイレクト | インポート開始画面 |

## 備考

- この画面はインポート処理中のみ表示される
- リポジトリが既に存在し、インポート処理がない場合はプロジェクト詳細画面にリダイレクト
- 外部インポートの場合、`git clone --bare` コマンドが表示される（セキュリティのためURLはサニタイズ）
- CI/CDのみのインポートパラメータがある場合、git cloneコマンドは表示されない
- continue_params によりカスタムリダイレクト先とメッセージを設定可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクトのインポート状態管理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | import_finished?、import_failed?、import_in_progress?メソッド |
| 1-2 | project_import_state.rb | `app/models/project_import_state.rb` | インポート状態の詳細管理 |

**読解のコツ**: `import_state` がnilでない場合にインポート処理中。`import_state.status` で現在の状態（scheduled, started, finished, failed）を確認。

#### Step 2: エントリーポイントを理解する

ビューテンプレートとコントローラの処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/projects/imports/show.html.haml` | インポート状態表示画面のビュー |
| 2-2 | imports_controller.rb | `app/controllers/projects/imports_controller.rb` | showアクションの処理フロー |

**主要処理フロー**:
1. **行9**: `require_namespace_project_creation_permission` で権限チェック
2. **行12**: `redirect_if_no_import` でインポートなしの場合リダイレクト
3. **行25-37**: `show` アクションでインポート状態に応じた分岐処理

#### Step 3: ヘルパーメソッドを理解する

インポート関連のヘルパーメソッドを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | imports_helper.rb | `app/helpers/imports_helper.rb` | import_in_progress_title、import_wait_and_refresh_message等 |

### プログラム呼び出し階層図

```
projects/imports/show.html.haml
    │
    ├─ import_in_progress_title
    │      └─ ヘルパーメソッドでタイトル生成
    │
    ├─ gl_loading_icon
    │      └─ ローディングアイコン表示
    │
    ├─ @project.external_import? チェック
    │      │
    │      └─ true の場合
    │             └─ git clone --bare コマンド表示
    │                    └─ @project.safe_import_url
    │
    └─ import_wait_and_refresh_message
           └─ 待機・リフレッシュメッセージ

ImportsController#show
    │
    ├─ import_finished?
    │      │
    │      └─ true
    │             ├─ continue_params[:to] あり → カスタムリダイレクト
    │             └─ なし → プロジェクト詳細画面
    │
    ├─ import_failed?
    │      │
    │      └─ true → インポート開始画面
    │
    └─ 進行中 → 待機表示継続
```

### データフロー図

```
[入力]                    [処理]                         [出力]

project_id ──────▶ ImportsController#show ──────▶ インポート状態チェック
                           │
                           ├─ import_finished? ──────▶ プロジェクト詳細へリダイレクト
                           │
                           ├─ import_failed? ──────▶ インポート開始画面へリダイレクト
                           │
                           └─ 進行中 ──────▶ ビューレンダリング
                                                    │
                                                    ▼
                                        save-project-loader表示
                                        （ローディング + メッセージ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/projects/imports/show.html.haml` | テンプレート | インポート状態表示画面 |
| imports_controller.rb | `app/controllers/projects/imports_controller.rb` | コントローラ | HTTPリクエスト処理 |
| imports_helper.rb | `app/helpers/imports_helper.rb` | ヘルパー | インポート関連ヘルパー |
| project.rb | `app/models/project.rb` | モデル | プロジェクトエンティティ |
| project_import_state.rb | `app/models/project_import_state.rb` | モデル | インポート状態管理 |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（行259） |
| continue_params.rb | `app/controllers/concerns/continue_params.rb` | Concern | リダイレクト先パラメータ処理 |
