# 画面設計書 135-インポート開始

## 概要

本ドキュメントは、GitLabにおけるプロジェクトリポジトリインポート開始画面の設計を定義するものである。

### 本画面の処理概要

**業務上の目的・背景**：既存のGitリポジトリをGitLabプロジェクトにインポートする必要がある場合、この画面を使用する。HTTP/HTTPS/Gitプロトコル経由でアクセス可能な外部リポジトリのURLを指定し、認証情報（必要な場合）を入力することで、リポジトリの内容をGitLabプロジェクトにコピーできる。これにより、他のGitホスティングサービスからの移行や、ローカルリポジトリのホスティングが可能となる。

**画面へのアクセス方法**：空のプロジェクト作成後、または既存のリポジトリを持たないプロジェクトで「Import repository」リンクをクリックすることでアクセスできる。また、インポート失敗時にこの画面にリダイレクトされる。URLパスは `/:namespace/:project/import/new` となる。

**主要な操作・処理内容**：
1. インポート元リポジトリのURLを入力
2. 認証が必要な場合、ユーザー名とパスワードを入力
3. 「Start import」ボタンでインポート処理を開始
4. インポート状態表示画面へ遷移

**画面遷移**：
- 遷移元：プロジェクト詳細画面、プロジェクト作成画面
- 遷移先：インポート状態表示画面

**権限による表示制御**：プロジェクトの管理者権限（`admin_project`）を持つユーザーのみがこの画面にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | GitHubインポート | 主機能 | インポート開始処理 |

## 画面種別

登録

## URL/ルーティング

| メソッド | パス | コントローラ#アクション |
|---------|------|------------------------|
| GET | `/:namespace_id/:project_id/import/new` | `projects/imports#new` |
| POST | `/:namespace_id/:project_id/import` | `projects/imports#create` |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入出力 | バリデーション | 説明 |
|--------|--------|-----|------|--------|---------------|------|
| リポジトリURL | import_url | String | Yes | 入力 | URLフォーマット、http/https/git | インポート元リポジトリURL |
| ユーザー名 | import_url_user | String | No | 入力 | - | 認証用ユーザー名 |
| パスワード | import_url_password | String | No | 入力 | - | 認証用パスワード |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ページタイトル | page_title | String | 「Import repository」 |
| ページ見出し | heading | String | 「Import repository」 |
| 説明リスト | info_list | HTML | インポート要件の説明 |
| GitリポジトリURLフィールド | import_url | TextInput | URL入力欄 |
| ユーザー名フィールド | import_url_user | TextInput | ユーザー名入力欄（オプション） |
| パスワードフィールド | import_url_password | PasswordInput | パスワード入力欄（オプション） |
| エラーメッセージ | error_alert | Alert | URL検証エラー時に表示 |

## イベント仕様

### 1-インポート開始

**トリガー**：「Start import」ボタンクリック

**処理フロー**：
1. フロントエンドでフォームをサブミット
2. ImportsController#create アクションを実行
3. プロジェクトのimport_url、認証情報を更新
4. import_state.reset.schedule でインポートジョブをスケジュール
5. インポート状態表示画面（project_import_path）へリダイレクト

**データフロー**：
```
Form Submit -> ImportsController#create -> Project.update(import_params)
    -> ImportState.reset.schedule -> Redirect to import show
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インポート開始 | projects | UPDATE | import_url等の設定 |
| インポート開始 | project_import_state | UPDATE | インポート状態をscheduledに |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | import_url | 入力されたURL（認証情報含む） | 暗号化保存 |
| UPDATE | import_type | 'git' または指定値 | インポート種別 |
| UPDATE | updated_at | 現在時刻 | 更新日時 |

#### project_import_state

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status | 'scheduled' | インポートスケジュール済み |
| UPDATE | jid | Sidekiqジョブ ID | バックグラウンドジョブID |
| UPDATE | updated_at | 現在時刻 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | The repository must be accessible over http://, https:// or git://. | 常時表示（説明） |
| MSG002 | 情報 | When using the http:// or https:// protocols, please provide the exact URL to the repository. HTTP redirects will not be followed. | 常時表示（説明） |
| MSG003 | 情報 | If your HTTP repository is not publicly accessible, add your credentials. | 常時表示（説明） |
| MSG004 | 警告 | Import will time out after X minutes. For repositories that take longer, use a clone/push combination. | 常時表示（説明） |
| MSG005 | エラー | There is not a valid Git repository at this URL. If your HTTP repository is not publicly accessible, verify your credentials. | URL検証失敗時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| プロジェクト未検出 | 404 Not Found | Not Found画面 |
| 権限不足 | 404 Not Found（render_404） | Not Found画面 |
| リポジトリ既存 | リダイレクト | プロジェクト詳細画面 |
| インポート進行中 | リダイレクト | インポート状態表示画面 |
| バリデーションエラー | エラーメッセージ表示 | 同一画面 |

## 備考

- リポジトリが既に存在する場合、この画面にはアクセスできない（require_no_repoでチェック）
- インポートが進行中の場合もアクセスできない（redirect_if_progressでチェック）
- 認証情報はURLに埋め込まれる形式で保存され、暗号化される
- GitLab::UrlSanitizer でURLのサニタイズ・検証が行われる
- SVNリポジトリのインポートには別途svn2gitツールの使用が推奨される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロジェクトのインポート設定に関連するカラムを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | import_url、import_type等のカラム定義 |
| 1-2 | import_url_params.rb | `app/controllers/concerns/import_url_params.rb` | import_url_paramsの処理 |

**読解のコツ**: `import_url` は `attr_encrypted` で暗号化されている場合がある。`unsafe_import_url` でサニタイズ前のURLを取得できる。

#### Step 2: エントリーポイントを理解する

ビューテンプレートとコントローラの処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new.html.haml | `app/views/projects/imports/new.html.haml` | インポート開始画面のビュー |
| 2-2 | imports_controller.rb | `app/controllers/projects/imports_controller.rb` | new、createアクション |
| 2-3 | _import_form.html.haml | `app/views/shared/_import_form.html.haml` | インポートフォームの共有パーシャル |

**主要処理フロー**:
1. **行8**: `authorize_admin_project!` で権限チェック（before_action）
2. **行10**: `require_no_repo` でリポジトリ存在チェック
3. **行11**: `redirect_if_progress` でインポート進行中チェック
4. **行17**: `new` アクションは空（ビューレンダリングのみ）
5. **行19-23**: `create` アクションでインポートを開始

#### Step 3: 共有パーシャルを理解する

インポートフォームの共有コンポーネントを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | _import_form.html.haml | `app/views/shared/_import_form.html.haml` | フォームフィールド、説明文、バリデーションエラー表示 |

**主要処理フロー**:
1. **行1**: ci_cd_only ローカル変数のデフォルト値設定
2. **行2**: UrlSanitizerでURLをサニタイズ
3. **行5-17**: 説明リスト（インポート要件）
4. **行18-23**: import_url入力フィールド
5. **行24-28**: エラーアラート
6. **行30-41**: ユーザー名・パスワードフィールド

### プログラム呼び出し階層図

```
projects/imports/new.html.haml
    │
    ├─ Layouts::PageHeadingComponent
    │      └─ 「Import repository」見出し
    │
    └─ gitlab_ui_form_for @project
           │
           └─ shared/_import_form.html.haml
                  │
                  ├─ info-well（説明リスト）
                  │      ├─ http/https/git プロトコル説明
                  │      ├─ HTTPリダイレクト非対応の説明
                  │      ├─ 認証情報の説明
                  │      └─ タイムアウト警告
                  │
                  ├─ import_url フィールド
                  │      └─ URLサニタイズ表示
                  │
                  ├─ エラーアラート（js-import-url-error）
                  │
                  └─ 認証情報フィールド
                         ├─ import_url_user
                         └─ import_url_password

ImportsController#create
    │
    ├─ @project.update(import_params)
    │      └─ import_url等を更新
    │
    ├─ @project.import_state.reset.schedule
    │      └─ インポートジョブをスケジュール
    │
    └─ redirect_to project_import_path(@project)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

import_url ──────▶ ImportsController#new ──────▶ フォーム表示
import_url_user              │
import_url_password          │
                             │
                             ▼
                    ImportsController#create
                             │
                             ├─ import_url_params マージ
                             │      └─ URL + 認証情報を結合
                             │
                             ├─ @project.update
                             │      └─ import_url保存（暗号化）
                             │
                             └─ import_state.reset.schedule
                                    │
                                    ▼
                             バックグラウンドジョブ登録
                                    │
                                    ▼
                             インポート状態表示画面へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new.html.haml | `app/views/projects/imports/new.html.haml` | テンプレート | インポート開始画面 |
| imports_controller.rb | `app/controllers/projects/imports_controller.rb` | コントローラ | HTTPリクエスト処理 |
| _import_form.html.haml | `app/views/shared/_import_form.html.haml` | パーシャル | インポートフォーム |
| import_url_params.rb | `app/controllers/concerns/import_url_params.rb` | Concern | URL・認証情報処理 |
| url_sanitizer.rb | `lib/gitlab/url_sanitizer.rb` | ライブラリ | URLサニタイズ処理 |
| project.rb | `app/models/project.rb` | モデル | プロジェクトエンティティ |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（行259） |
