# 画面設計書 136-Jiraインポート

## 概要

本ドキュメントは、GitLabにおけるJiraインポート設定画面の設計を定義するものである。

### 本画面の処理概要

**業務上の目的・背景**：Jiraを課題管理ツールとして使用していた組織がGitLabに移行する際、既存のJira課題をGitLabのイシューとしてインポートする必要がある。この画面では、Jira連携が設定されたプロジェクトにおいて、Jiraプロジェクトを選択し、課題データをGitLabにインポートするための設定と実行を行う。これにより、チームは過去の課題履歴を失うことなくGitLabに移行できる。

**画面へのアクセス方法**：プロジェクト画面から「プロジェクト情報」>「Jiraからインポート」または課題一覧画面のインポートオプションからアクセスできる。URLパスは `/:namespace/:project/-/import/jira` となる。

**主要な操作・処理内容**：
1. Jira連携の設定状態を確認
2. インポート対象のJiraプロジェクトを選択
3. インポートを実行
4. インポート状態を確認

**画面遷移**：
- 遷移元：課題一覧画面、プロジェクトメニュー
- 遷移先：課題一覧画面、Jira連携設定画面（未設定時）

**権限による表示制御**：プロジェクトの読み取り権限（`read_project`）を持つユーザーがアクセスできる。ただし、インポート実行にはより高い権限が必要な場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 96 | Jira連携 | 主機能 | Jiraインポート設定・実行 |

## 画面種別

設定

## URL/ルーティング

| メソッド | パス | コントローラ#アクション |
|---------|------|------------------------|
| GET | `/:namespace_id/:project_id/-/import/jira` | `projects/import/jira#show` |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入出力 | バリデーション | 説明 |
|--------|--------|-----|------|--------|---------------|------|
| プロジェクトID | project_id | String | Yes | 入力 | プロジェクト存在チェック | 対象プロジェクト |
| Jiraプロジェクトキー | jira_project_key | String | Yes | 入力 | - | インポート元Jiraプロジェクト |

## 表示項目

この画面はVue.jsコンポーネント（`.js-jira-import-root`）によりレンダリングされる。

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| プロジェクトパス | project_path | String | data属性で渡される |
| 課題一覧パス | issues_path | String | インポート後の遷移先 |
| Jira連携設定パス | jira_integration_path | String | 連携設定画面へのリンク |
| Jira設定状態 | is_jira_configured | Boolean | Jira連携が設定済みか |
| プロジェクトID | project_id | Integer | 対象プロジェクトID |
| セットアップイラスト | setup_illustration | String | 設定画面のイラスト画像パス |

## イベント仕様

### 1-Jiraプロジェクト選択

**トリガー**：Vueコンポーネント内のJiraプロジェクトドロップダウン変更

**処理フロー**：
1. Jira API経由でプロジェクト一覧を取得
2. ドロップダウンにプロジェクト一覧を表示
3. ユーザーがプロジェクトを選択
4. 選択されたプロジェクトキーを保持

### 2-インポート開始

**トリガー**：「Import」ボタンクリック

**処理フロー**：
1. 選択されたJiraプロジェクトキーでGraphQL Mutationを呼び出し
2. バックエンドでJiraインポートジョブをスケジュール
3. インポート状態を表示
4. 完了後、課題一覧画面へ遷移可能

### 3-Jira連携設定へ遷移

**トリガー**：Jira未設定時の設定リンククリック

**処理フロー**：
1. Jira連携設定画面（edit_project_settings_integration_path）へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | integrations | SELECT | Jira連携状態の確認 |
| インポート開始 | jira_imports | INSERT | インポートジョブの登録 |
| インポート実行 | issues | INSERT | Jira課題からイシュー作成 |

この画面自体での主要なDB更新はインポート開始時に行われ、実際のデータインポートはバックグラウンドジョブで実行される。

### テーブル別更新項目詳細

#### jira_imports（インポート開始時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id | 対象プロジェクトID | FK |
| INSERT | user_id | current_user.id | 実行者 |
| INSERT | jira_project_key | 選択されたJiraプロジェクトキー | - |
| INSERT | status | 'scheduled' | インポート状態 |
| INSERT | created_at | 現在時刻 | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 情報 | Jira integration is not configured. | Jira未設定時 |
| MSG002 | 成功 | Import started successfully. | インポート開始成功時 |
| MSG003 | エラー | Failed to start import. | インポート開始失敗時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|---------|---------|--------|
| プロジェクト未検出 | 404 Not Found | Not Found画面 |
| 権限不足 | 404 Not Found（render_404） | Not Found画面 |
| Jiraインポート設定無効 | フラッシュメッセージ + リダイレクト | 課題一覧画面 |

## 備考

- この画面はVue.jsコンポーネント（`.js-jira-import-root`）によりレンダリングされる
- Jira連携が設定されていない場合、設定画面へのリンクとセットアップイラストが表示される
- Jiraプロジェクトの認証・接続はJira IntegrationのAPI設定に依存する
- インポートはバックグラウンドジョブとして実行され、大量の課題がある場合は時間がかかる
- validate_jira_import_settings! メソッドでJiraインポートの前提条件をチェック

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Jiraインポート関連のモデルと連携設定を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | jira_import.rb | `app/models/jira_import.rb` | JiraImportモデルの定義 |
| 1-2 | jira_integration.rb | `app/models/integrations/jira.rb` | Jira連携設定 |

**読解のコツ**: `JiraImport` モデルはインポートジョブの状態管理を行う。`Integrations::Jira` でJira APIへの接続設定を確認。

#### Step 2: エントリーポイントを理解する

ビューテンプレートとコントローラの処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/projects/import/jira/show.html.haml` | Vueコンポーネントのマウントポイント |
| 2-2 | jira_controller.rb | `app/controllers/projects/import/jira_controller.rb` | showアクション、バリデーション |

**主要処理フロー**:
1. **行6**: `authenticate_user!` でログインチェック
2. **行7**: `authorize_read_project!` で権限チェック
3. **行8**: `validate_jira_import_settings!` でJira設定バリデーション
4. **行12**: `show` アクションは空（ビューレンダリングのみ）

#### Step 3: Vueコンポーネントを理解する

フロントエンドの実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | jira_import | `app/assets/javascripts/jira_import/` | Vueコンポーネント群 |

#### Step 4: バリデーションを理解する

Jiraインポートの前提条件チェックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | jira_import.rb | `lib/gitlab/jira_import.rb` | validate_project_settings!メソッド |

### プログラム呼び出し階層図

```
projects/import/jira/show.html.haml
    │
    └─ .js-jira-import-root (Vue Component)
           │
           ├─ data: project_path
           ├─ data: issues_path
           ├─ data: jira_integration_path
           ├─ data: is_jira_configured
           ├─ data: project_id
           └─ data: setup_illustration
                  │
                  └─ Vue Component Tree
                         │
                         ├─ Jira連携未設定時
                         │      └─ SetupView（設定リンク表示）
                         │
                         └─ Jira連携設定済み時
                                ├─ JiraProjectSelector
                                │      └─ Jira API -> プロジェクト一覧取得
                                │
                                └─ ImportButton
                                       └─ GraphQL Mutation -> インポート開始
```

### データフロー図

```
[入力]                    [処理]                         [出力]

project_id ──────▶ JiraController#show ──────▶ validate_jira_import_settings!
                           │                              │
                           ├─ 失敗 ──────────────────────▶ 課題一覧へリダイレクト
                           │                              （フラッシュメッセージ）
                           │
                           └─ 成功 ──────────────────────▶ Vue Component mount
                                                                │
                                                                ▼
                           is_jira_configured? ──────────▶ 表示分岐
                                    │
                                    ├─ false ──────────▶ SetupView（設定リンク）
                                    │
                                    └─ true ──────────▶ ImportView
                                                              │
                                                              ▼
                           jira_project_key ──────▶ GraphQL Mutation
                                                              │
                                                              ▼
                                                   jira_imports (INSERT)
                                                              │
                                                              ▼
                                                   バックグラウンドジョブ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/projects/import/jira/show.html.haml` | テンプレート | Jiraインポート画面 |
| jira_controller.rb | `app/controllers/projects/import/jira_controller.rb` | コントローラ | HTTPリクエスト処理 |
| jira_import.rb | `app/models/jira_import.rb` | モデル | インポートジョブ管理 |
| jira.rb | `app/models/integrations/jira.rb` | モデル | Jira連携設定 |
| jira_import.rb | `lib/gitlab/jira_import.rb` | ライブラリ | バリデーション・ユーティリティ |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（行429-430） |
