# 画面設計書 14-マージリクエスト一覧

## 概要

本ドキュメントは、GitLabダッシュボードのマージリクエスト一覧画面（Dashboard Merge Requests）の画面設計を定義したものである。

### 本画面の処理概要

ログインユーザーに関連するマージリクエスト（MR）の一覧を横断的に表示し、コードレビューとマージ作業を支援するダッシュボード画面である。

**業務上の目的・背景**：開発チームにおいて、コードレビューとマージ作業は重要なワークフローである。本画面は、ユーザーが担当するレビュー、作成したMR、フォロー中のMRなどを一元的に確認できる。「Needs Attention」機能により、アクションが必要なMRを効率的に把握できる。

**画面へのアクセス方法**：ログイン後、サイドバーまたはトップナビゲーションから「Merge requests」メニューを選択。直接URLアクセスの場合は `/dashboard/merge_requests` へアクセスする。

**主要な操作・処理内容**：
1. マージリクエスト一覧の表示（Active、Merged、Search タブ）
2. MRのフィルタリング（Assigned、Review requested、Following等）
3. ラベル・ブランチ・状態による絞り込み
4. ソート順の変更
5. 各MRの詳細画面への遷移
6. 新規MR作成画面への遷移
7. MRダッシュボード設定のカスタマイズ

**画面遷移**：
- 遷移元：ログイン画面、サイドバー、トップナビゲーション
- 遷移先：MR詳細画面、MR新規作成画面

**権限による表示制御**：ログインユーザーのみアクセス可能。表示されるMRはユーザーがアクセス権限を持つプロジェクトのMRに限定される。ユーザーのmerge_request_dashboard_list_type設定によりデフォルト表示が変わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 124 | Todoリスト | 主機能 | 関連マージリクエストの一覧表示 |
| 28 | マージリクエスト作成 | 遷移先機能 | MR詳細画面への遷移 |

## 画面種別

一覧

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/dashboard/merge_requests` | GET | MR一覧（Activeタブ） |
| `/dashboard/merge_requests/merged` | GET | MR一覧（Mergedタブ） |
| `/dashboard/merge_requests/search` | GET | MR検索画面 |
| `/dashboard/merge_requests/following` | GET | フォロー中のMR一覧 |

## 入出力項目

### 入力項目（検索・フィルタ）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| assignee_username | string | No | 担当者でフィルタ |
| author_username | string | No | 作成者でフィルタ |
| reviewer_username | string | No | レビュアーでフィルタ |
| state | string | No | 状態（opened, merged, closed, all） |
| label_name | string[] | No | ラベルでフィルタ |
| sort | string | No | ソート順 |
| search | string | No | 検索キーワード |
| page | integer | No | ページ番号 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| merge_requests | Array | MR一覧 |
| @state | string | 現在の状態フィルタ |
| @sort | string | 現在のソート順 |

## 表示項目

### マージリクエスト一覧

| 項目名 | 説明 | 備考 |
|--------|------|------|
| MRタイトル | マージリクエストのタイトル | リンク |
| プロジェクト名 | 所属プロジェクトのフルパス | リンク |
| ソースブランチ | マージ元ブランチ | |
| ターゲットブランチ | マージ先ブランチ | |
| ラベル | MRに設定されたラベル | バッジ表示 |
| 担当者 | MRの担当者 | アバター表示 |
| レビュアー | レビュー担当者 | アバター表示 |
| 作成日時 | MR作成日時 | 相対時間表示 |
| 更新日時 | 最終更新日時 | 相対時間表示 |
| パイプライン状態 | CI/CDパイプラインの状態 | アイコン表示 |
| コメント数 | コメント数 | アイコン付き |
| 承認状態 | 承認の状態 | |
| ドラフト | ドラフトMRかどうか | バッジ表示 |

## イベント仕様

### 1-MRリストの読み込み

Vue.jsアプリケーション（`#js-merge-request-dashboard`）がマウントされ、APIを通じてMR一覧を取得する。

**処理フロー**：
1. ページ読み込み時にVueアプリケーションが初期化
2. `merge_request_dashboard_data`からアプリケーション設定を取得
3. GraphQL APIを通じてMR一覧を非同期取得
4. フィルタ・ソート条件に基づいてリストを表示

### 2-タブ切り替え

Active/Merged/Searchタブを切り替えると、該当する状態のMRが表示される。

### 3-フィルタ変更

フィルタ条件を変更すると、URLパラメータが更新され、MR一覧が再取得される。

### 4-新規MR作成

「New merge request」ボタンをクリックすると、プロジェクト選択ドロップダウンが表示され、選択後にMR作成画面へ遷移する。

### 5-ダッシュボード設定

設定アイコンをクリックすると、ダッシュボードの表示設定を変更できる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | merge_requests | SELECT | フィルタ条件に合致するMRを取得 |
| ページ表示 | merge_request_reviewers | SELECT | レビュアー情報を取得 |
| ページ表示 | ci_pipelines | SELECT | パイプライン状態を取得 |

### テーブル別更新項目詳細

#### merge_requests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, state, source_branch, target_branch, author_id, assignee_id, created_at, updated_at | MergeRequestsFinder経由 | フィルタ条件による絞り込み |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | "No merge requests found" | 検索結果が0件の場合 |
| MSG-002 | 情報 | "Your merge requests have a new homepage!" | 新MRダッシュボードバナー表示時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 未ログイン | ログイン画面へリダイレクト | - |
| 検索タイムアウト | タイムアウトメッセージ表示 | 検索タイムアウトのメッセージ |
| API通信エラー | エラーメッセージ表示 | "Something went wrong. Please try again." |

## 備考

- Vue.jsベースのSPA実装（`#js-merge-request-dashboard`）
- GraphQL APIを使用したデータ取得
- 新MRダッシュボードへの移行バナー表示機能
- ユーザー設定によるリストタイプ（list_type）のカスタマイズ
- Drafts表示/非表示の設定（show_drafts）
- SAML再認証が必要なグループの通知表示機能あり（EE機能）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マージリクエストのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | MRモデルの定義、アソシエーション |
| 1-2 | merge_requests_finder.rb | `app/finders/merge_requests_finder.rb` | MR検索ロジック |

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dashboard_controller.rb | `app/controllers/dashboard_controller.rb` | merge_requests/search_merge_requestsアクション |

**主要処理フロー**:
1. **Line 17-21**: クエリストリングがある場合はsearchページへリダイレクト
2. **Line 32**: feature_categoryはcode_review_workflow
3. **Line 58-60**: search_merge_requestsアクション

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | merge_requests.html.haml | `app/views/dashboard/merge_requests.html.haml` | HAMLテンプレート、Vue.jsアプリのマウント |

**主要処理フロー**:
- **Line 13-24**: 新MRダッシュボードバナーの表示条件
- **Line 31-38**: Vue.jsアプリのマウント、初期データ設定
- **Line 40-62**: Searchタブ時の従来表示

### プログラム呼び出し階層図

```
DashboardController#merge_requests
    |
    +-- redirect_to merge_requests_search_dashboard_path [クエリストリング有り時]
    |
    +-- render 'dashboard/merge_requests'
           |
           +-- show_mr_dashboard_banner? (条件分岐)
           |      |
           |      +-- Pajamas::AlertComponent (バナー)
           |
           +-- ::Layouts::PageHeadingComponent
           |
           +-- #js-merge-request-dashboard (Vue.js)
                  |
                  +-- merge_request_dashboard_data (ヘルパー)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ DashboardController ───▶ HTMLレスポンス
(assignee,               |                    (Vue.jsアプリ)
 state, sort等)          |
                         v
                  MergeRequestsFinder
                         |
                         v
                  MergeRequest (Model)
                         |
                         v
                  PostgreSQL / GraphQL API
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dashboard_controller.rb | `app/controllers/dashboard_controller.rb` | コントローラ | リクエスト処理 |
| merge_requests.html.haml | `app/views/dashboard/merge_requests.html.haml` | ビュー | 画面テンプレート |
| merge_requests_finder.rb | `app/finders/merge_requests_finder.rb` | ファインダー | MR検索ロジック |
| merge_request.rb | `app/models/merge_request.rb` | モデル | MRデータ定義 |
| dashboard.rb | `config/routes/dashboard.rb` | ルート | URL定義 |
| issuable_collections_action.rb | `app/controllers/concerns/issuable_collections_action.rb` | Concern | Issuable共通処理 |
