# 画面設計書 141-グループ詳細

## 概要

本ドキュメントは、GitLabにおけるグループ詳細画面の設計仕様を定義するものである。グループのトップページとして、グループの基本情報、アクティビティ、関連リソースへのアクセスポイントを提供する。

### 本画面の処理概要

グループ詳細画面は、GitLabにおけるグループの情報を一元的に表示するトップページとして機能する。ユーザーはこの画面を通じて、グループの概要把握、配下のプロジェクトやサブグループの確認、アクティビティの閲覧が可能となる。

**業務上の目的・背景**：企業やチームにおいて、関連するプロジェクトやメンバーを論理的にグルーピングして管理する必要がある。グループ詳細画面は、そのグループの全体像を把握し、関連リソースへの効率的なナビゲーションを提供するためのハブとして機能する。複数プロジェクトを横断した課題管理やCI/CD設定の統一など、グループレベルでの運用管理を支援する。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能である。
- ダッシュボードのグループ一覧から対象グループをクリック
- URL直接アクセス: `/groups/{group_path}`
- グローバル検索でグループを検索し選択
- プロジェクト詳細画面からパンくずリストのグループ名をクリック

**主要な操作・処理内容**：
1. グループの基本情報（名前、説明、アバター、可視性レベル）の表示
2. グループのREADMEコンテンツの表示（gitlab-profileプロジェクトが存在する場合）
3. 配下プロジェクト・サブグループの一覧表示
4. グループアクティビティフィードの表示
5. スター追加/削除、フォーク、共有などのアクション
6. 関連機能（Issues、Merge Requests、CI/CD等）への遷移

**画面遷移**：
- 遷移元：ダッシュボード、探索画面、プロジェクト詳細、検索結果
- 遷移先：グループ編集、メンバー一覧、ラベル一覧、マイルストーン一覧、課題ボード、パッケージ一覧、Runner一覧、各種設定画面、配下のプロジェクト・サブグループ詳細

**権限による表示制御**：
- Guest：基本情報の閲覧、公開プロジェクトの参照
- Reporter以上：内部プロジェクトの参照、アクティビティの閲覧
- Maintainer以上：設定へのアクセス
- Owner：グループ設定の完全な管理、メンバー招待、削除

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | グループ作成 | 主機能 | グループのトップページ表示処理 |
| 136 | アクティビティフィード | 補助機能 | グループアクティビティの表示 |
| 122 | グループダッシュボード | 遷移先機能 | 配下プロジェクト・サブグループ一覧 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/groups/{group_path}`
- ルーティング: `groups#show`
- HTTPメソッド: GET
- 対応フォーマット: HTML, Atom（RSSフィード）

## 入出力項目

| 項目名 | 種別 | 必須 | データ型 | 説明 |
|--------|------|------|----------|------|
| group_path | URL パラメータ | 必須 | String | グループのフルパス |
| trial | クエリパラメータ | 任意 | Boolean | トライアル表示フラグ |

## 表示項目

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|----------|
| グループ名 | String | グループの表示名 | 常時 |
| グループパス | String | グループのURLパス | 常時 |
| アバター | Image | グループのアバター画像 | 設定されている場合 |
| 説明 | Text | グループの説明文 | 設定されている場合 |
| 可視性アイコン | Icon | Public/Internal/Private | 常時 |
| メンバー数 | Integer | グループのメンバー数 | 常時 |
| プロジェクト数 | Integer | 配下プロジェクト数 | 常時 |
| サブグループ数 | Integer | 配下サブグループ数 | 常時 |
| README | Markdown | グループREADME | gitlab-profileプロジェクト存在時 |
| アクティビティ | List | 最新アクティビティ一覧 | イベントが存在する場合 |
| 招待バナー | Component | メンバー招待促進バナー | 招待権限がある場合 |

## イベント仕様

### 1-グループ詳細表示

1. URLパラメータからgroup_pathを取得
2. Groupモデルからグループ情報を取得
3. インポート中の場合はインポート画面へリダイレクト
4. `groups_show_app_data`でVueアプリケーション用データを生成
5. グループREADMEの取得（gitlab-profileプロジェクト内のREADME）
6. 招待バナー表示判定（`show_invite_banner?`）
7. Atom形式の場合はイベント一覧を取得してXML生成

### 2-RSSフィード取得

1. Atomフォーマットでリクエストを受信
2. `load_events`メソッドでグループ関連イベントを取得
3. XML形式でアクティビティフィードを生成

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | namespaces | SELECT | グループ情報の取得 |
| 画面表示 | projects | SELECT | 配下プロジェクト一覧取得 |
| 画面表示 | events | SELECT | アクティビティイベント取得 |
| 画面表示 | notification_settings | SELECT | 通知設定の取得 |
| トラッキング | - | - | Snowplowイベント送信（group_overview/render） |

### テーブル別更新項目詳細

#### namespaces（読み取り専用）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, path, description, visibility_level | パスに一致するグループ | STI type = 'Group' |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | グループのREADMEが表示されます | READMEコンテンツ存在時 |
| MSG-002 | 警告 | インポート処理中です | import_state.in_progress?が真 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|----------|----------|--------|
| グループが存在しない | 404エラー表示 | エラーページ |
| アクセス権限不足 | 403エラー表示 | アクセス拒否画面 |
| インポート中 | インポート画面へリダイレクト | group_import_path |

## 備考

- グループREADMEは`gitlab-profile`という特別なプロジェクト名のリポジトリ内のREADMEファイルが表示される
- Snowplowトラッキングで`group_overview`イベントが送信される
- Atomフィードはセッションレス認証に対応（RSSリーダー向け）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グループの基本データ構造とグループ間の階層関係を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | グループモデルの定義、has_many関連、スコープ定義 |
| 1-2 | namespace.rb | `app/models/namespace.rb` | 親クラスNamespaceの構造、traversal_ids |

**読解のコツ**: GroupはNamespaceを継承したSTIモデル。`has_many :milestones`, `has_many :labels`などの関連を確認。

#### Step 2: エントリーポイントを理解する

コントローラーの`show`アクションがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/groups_controller.rb` | showアクション、before_action、レイアウト決定 |

**主要処理フロー**:
1. **111-125行目**: showアクションの定義、HTML/Atom両フォーマット対応
2. **305-308行目**: render_show_htmlメソッドでのトラッキングとビュー呼び出し
3. **359-361行目**: user_actionsで通知設定取得

#### Step 3: ビューレイヤーを理解する

HAMLテンプレートとVueコンポーネントの連携を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/groups/show.html.haml` | メインテンプレート、パーシャル呼び出し |
| 3-2 | _home_panel.html.haml | `app/views/groups/_home_panel.html.haml` | グループヘッダー部分 |
| 3-3 | _group_readme.html.haml | `app/views/groups/_group_readme.html.haml` | README表示部分 |

**主要処理フロー**:
- **1行目**: Schema.org Organizationマークアップ設定
- **5行目**: 四半期調整アラート（EE機能）
- **22行目**: ホームパネル（グループ情報ヘッダー）
- **26行目**: Vueアプリケーションマウントポイント
- **28行目**: グループREADME表示

#### Step 4: ヘルパーとデータ生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | groups_helper.rb | `app/helpers/groups_helper.rb` | groups_show_app_data、show_invite_banner? |

### プログラム呼び出し階層図

```
GroupsController#show
    │
    ├─ authorize_read_group! (before_action)
    │      └─ GroupPolicy#read_group?
    │
    ├─ group (before_action)
    │      └─ Group.find_by_full_path(params[:id])
    │
    ├─ render_show_html
    │      ├─ Gitlab::Tracking.event('group_overview', 'render')
    │      └─ render 'groups/show'
    │             ├─ render_if_exists 'shared/qrtly_reconciliation_alert'
    │             ├─ render 'groups/home_panel'
    │             ├─ #js-groups-show-app (Vue mount point)
    │             │      └─ groups_show_app_data(@group)
    │             └─ render 'groups/group_readme'
    │                    └─ @group.group_readme (gitlab-profile/README)
    │
    └─ [Atom format]
           └─ render_details_view_atom
                  └─ load_events
                         ├─ GroupProjectsFinder
                         └─ EventCollection
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URL params ─────────────▶ GroupsController ─────────────▶ HTML Response
(group_path)                    │
                                ├── Group.find_by_full_path
                                │        │
                                │        ▼
                                │   namespaces table
                                │        │
                                ├── notification_settings
                                │        │
                                ├── group_readme
                                │        │
                                │        └── gitlab-profile/README
                                │
                                └── groups_show_app_data
                                         │
                                         ▼
                                    Vue Application
                                    (プロジェクト/サブグループ一覧)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/groups_controller.rb` | コントローラー | リクエスト処理、アクション定義 |
| group.rb | `app/models/group.rb` | モデル | グループデータ構造、ビジネスロジック |
| show.html.haml | `app/views/groups/show.html.haml` | ビュー | メインテンプレート |
| _home_panel.html.haml | `app/views/groups/_home_panel.html.haml` | ビュー | グループヘッダーパーシャル |
| _group_readme.html.haml | `app/views/groups/_group_readme.html.haml` | ビュー | README表示パーシャル |
| groups_helper.rb | `app/helpers/groups_helper.rb` | ヘルパー | ビューヘルパーメソッド |
| group_policy.rb | `app/policies/group_policy.rb` | ポリシー | 権限制御 |
| group.rb | `config/routes/group.rb` | 設定 | ルーティング定義 |
