# 画面設計書 142-グループ新規作成

## 概要

本ドキュメントは、GitLabにおけるグループ新規作成画面の設計仕様を定義するものである。ユーザーが新しいグループを作成するためのフォームを提供し、グループ名、パス、可視性レベルなどの基本設定を入力できる。

### 本画面の処理概要

グループ新規作成画面は、新しいグループを作成するためのフォームを提供する。ユーザーはグループ名、URLパス、説明、可視性レベルなどの基本情報を入力し、新規グループを作成できる。また、他のGitLabインスタンスやファイルからグループをインポートするオプションも提供される。

**業務上の目的・背景**：組織やチームが新しいプロジェクト群を管理するための論理的なコンテナとしてグループが必要となる。グループを作成することで、複数プロジェクトに共通するメンバー管理、ラベル、マイルストーン、CI/CD設定などを一元的に管理できるようになる。サブグループの作成により、階層的な組織構造を反映したプロジェクト管理が可能となる。

**画面へのアクセス方法**：以下のいずれかの方法でアクセス可能である。
- ダッシュボードのグループ一覧画面から「New group」ボタンをクリック
- URL直接アクセス: `/groups/new`
- 親グループの詳細画面からサブグループ作成を選択: `/groups/new?parent_id={parent_group_id}`
- グローバル「+」メニューから「New group」を選択

**主要な操作・処理内容**：
1. グループ名の入力（必須）
2. グループURLパスの入力/自動生成（グループ名から自動生成される）
3. 説明の入力（任意）
4. 可視性レベルの選択（Public/Internal/Private）
5. 「Create group」ボタンによるグループ作成
6. 別インスタンスからのグループインポート
7. ファイルからのグループインポート

**画面遷移**：
- 遷移元：ダッシュボード、グループ一覧、親グループ詳細画面、グローバルナビゲーション
- 遷移先：作成成功時は新規グループ詳細画面、エラー時は同画面でエラー表示

**権限による表示制御**：
- グループ作成権限がないユーザーは404エラー
- サブグループ作成時は親グループへのcreate_subgroup権限が必要
- 管理者設定で新規グループ作成を制限している場合は作成不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | グループ作成 | 主機能 | 新規グループの作成処理 |
| 110 | バルクインポート | 補助機能 | 別インスタンスからのグループインポート |

## 画面種別

登録

## URL/ルーティング

- パス: `/groups/new`
- ルーティング: `groups#new`, `groups#create`
- HTTPメソッド: GET（フォーム表示）, POST（グループ作成）

## 入出力項目

| 項目名 | 種別 | 必須 | データ型 | 説明 | バリデーション |
|--------|------|------|----------|------|---------------|
| parent_id | クエリパラメータ | 任意 | Integer | 親グループID（サブグループ作成時） | 存在チェック |
| name | フォーム入力 | 必須 | String | グループ名 | 255文字以内、空白不可 |
| path | フォーム入力 | 必須 | String | URLパス | 英数字・ハイフン・アンダースコアのみ |
| description | フォーム入力 | 任意 | Text | グループの説明 | - |
| visibility_level | フォーム選択 | 必須 | Integer | 可視性レベル | 0:Private, 10:Internal, 20:Public |
| avatar | フォーム入力 | 任意 | File | グループアバター画像 | 画像形式制限あり |

## 表示項目

| 項目名 | データ型 | 説明 | 表示条件 |
|--------|----------|------|----------|
| グループ名入力フィールド | Input | グループ名の入力欄 | 常時 |
| URLパス入力フィールド | Input | グループパスの入力欄 | 常時 |
| URLプレビュー | Text | 生成されるグループURLのプレビュー | 常時 |
| 説明入力フィールド | Textarea | グループ説明の入力欄 | 常時 |
| 可視性レベル選択 | Radio | Public/Internal/Private選択 | 常時 |
| 親グループ情報 | Text | 親グループのパス表示 | parent_id指定時 |
| インポートタブ | Tab | インポートオプション表示 | 常時 |
| エラーメッセージ | Alert | バリデーションエラー | エラー発生時 |

## イベント仕様

### 1-フォーム表示（GET /groups/new）

1. ユーザーの認証確認（`authenticate_user!`）
2. グループ作成権限の確認（`authorize_create_group!`）
3. parent_idが指定されている場合、親グループの存在確認と権限チェック
4. 新規Groupオブジェクトの初期化
5. namespace_settingsの初期化
6. フォーム表示

### 2-グループ作成（POST /groups）

1. ユーザー認証確認
2. フォームパラメータの取得とサニタイズ
3. `Groups::CreateService`の実行
4. 成功時：新規グループ詳細画面へリダイレクト、成功メッセージ表示
5. 失敗時：フォーム再表示、エラーメッセージ表示

### 3-グループ名入力時のパス自動生成

1. グループ名入力フィールドの変更を検知（JavaScript）
2. グループ名をスラッグ形式に変換
3. パス入力フィールドに自動入力
4. URLプレビューを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| グループ作成 | namespaces | INSERT | グループレコード作成 |
| グループ作成 | routes | INSERT | ルート情報作成 |
| グループ作成 | namespace_settings | INSERT | 名前空間設定作成 |
| グループ作成 | groups_feature_settings | INSERT | グループ機能設定作成 |
| サブグループ作成 | namespaces | UPDATE | traversal_ids更新 |

### テーブル別更新項目詳細

#### namespaces

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | グループ表示名 |
| INSERT | path | フォーム入力値 | URLパス |
| INSERT | description | フォーム入力値 | グループ説明 |
| INSERT | visibility_level | フォーム選択値 | 0/10/20 |
| INSERT | type | 'Group' | STI識別子 |
| INSERT | parent_id | parent_idパラメータ | サブグループ時のみ |
| INSERT | organization_id | Current.organization.id | 組織ID |
| INSERT | owner_id | current_user.id | 作成者ID |

#### routes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | path | 生成されたフルパス | URLルート |
| INSERT | source_type | 'Namespace' | ルート対象 |
| INSERT | source_id | namespaces.id | グループID |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | Group {group_name} was successfully created. | グループ作成成功時 |
| MSG-002 | 成功 | Group {group_name} and its Mattermost team were successfully created. | Mattermost連携有効時 |
| MSG-003 | エラー | Name has already been taken | 同名グループ存在時 |
| MSG-004 | エラー | Path has already been taken | 同パス存在時 |
| MSG-005 | エラー | Visibility level {level} is not allowed | 可視性レベル制限時 |

## 例外処理

| 例外条件 | 処理内容 | 遷移先 |
|----------|----------|--------|
| 認証なし | ログイン画面へリダイレクト | ログイン画面 |
| 作成権限なし | 404エラー表示 | エラーページ |
| 親グループ不存在 | 404エラー表示 | エラーページ |
| サブグループ作成権限なし | 404エラー表示 | エラーページ |
| バリデーションエラー | フォーム再表示 | 同画面 |

## 備考

- グループ名は特殊文字を含むことができるが、パスは英数字・ハイフン・アンダースコアに制限される
- 親グループの可視性レベルより高い可視性をサブグループに設定することはできない
- インスタンス設定でグループ作成が制限されている場合がある
- Mattermost連携が有効な場合、Mattermostチームが自動作成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グループ作成に必要なパラメータと関連するモデルを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | バリデーション、コールバック定義 |
| 1-2 | namespace.rb | `app/models/namespace.rb` | 親クラスのバリデーション |
| 1-3 | namespace_setting.rb | `app/models/namespace_setting.rb` | グループ設定の構造 |

**読解のコツ**: `validates :name`, `validates :path`などのバリデーション定義を確認。`before_validation`コールバックも重要。

#### Step 2: エントリーポイントを理解する

コントローラーの`new`/`create`アクションがエントリーポイント。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | groups_controller.rb | `app/controllers/groups_controller.rb` | new/createアクション、権限チェック |

**主要処理フロー**:
1. **77-81行目**: newアクションの定義、親グループ取得、Groupオブジェクト初期化
2. **83-109行目**: createアクションの定義、Groups::CreateService呼び出し
3. **317-326行目**: authorize_create_group!メソッドでの権限チェック

#### Step 3: サービスレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/groups/create_service.rb` | グループ作成のビジネスロジック |

#### Step 4: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new.html.haml | `app/views/groups/new.html.haml` | メインテンプレート、タブ構成 |
| 4-2 | _new_group_fields.html.haml | `app/views/groups/_new_group_fields.html.haml` | フォームフィールド定義 |

**主要処理フロー**:
- **9-11行目**: js-new-group-creation要素でVueコンポーネント初期化
- **15-16行目**: gitlab_ui_form_forでフォーム生成
- **18-20行目**: インポートタブのパネル定義

### プログラム呼び出し階層図

```
GroupsController#new
    │
    ├─ authenticate_user! (before_action)
    │
    ├─ authorize_create_group!
    │      └─ parent_id指定時: can?(:create_subgroup, parent)
    │      └─ 未指定時: can?(:create_group)
    │
    └─ Group.new(params.permit(:parent_id))
           └─ build_namespace_settings

GroupsController#create
    │
    ├─ authenticate_user! (before_action)
    │
    └─ Groups::CreateService.new(current_user, group_params).execute
           │
           ├─ Group.new(params)
           │
           ├─ group.save
           │      ├─ before_validation callbacks
           │      ├─ validations
           │      └─ after_create callbacks
           │              ├─ post_create_hook (SystemHook)
           │              └─ create_or_load_association(:group_feature)
           │
           └─ Response(success/error)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Form params ─────────────▶ GroupsController#create ─────▶ Redirect
(name, path,                      │                      (成功: group_path)
 visibility_level)                │                      (失敗: render :new)
                                  ▼
                          Groups::CreateService
                                  │
                                  ├── params validation
                                  │
                                  ├── Group.new
                                  │
                                  └── group.save
                                         │
                                         ▼
                                    namespaces table (INSERT)
                                    routes table (INSERT)
                                    namespace_settings table (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| groups_controller.rb | `app/controllers/groups_controller.rb` | コントローラー | new/createアクション定義 |
| create_service.rb | `app/services/groups/create_service.rb` | サービス | グループ作成ロジック |
| group.rb | `app/models/group.rb` | モデル | グループデータ構造 |
| new.html.haml | `app/views/groups/new.html.haml` | ビュー | メインテンプレート |
| _new_group_fields.html.haml | `app/views/groups/_new_group_fields.html.haml` | ビュー | フォームフィールド |
| group_policy.rb | `app/policies/group_policy.rb` | ポリシー | 権限制御 |
| params.rb | `app/controllers/concerns/groups/params.rb` | Concern | パラメータ定義 |
