# 画面設計書 15-To-Do一覧

## 概要

本ドキュメントは、GitLabダッシュボードのTo-Do一覧画面（Dashboard Todos Index）の画面設計を定義したものである。

### 本画面の処理概要

ログインユーザーに対するアクション要求（To-Do）の一覧を表示し、タスク管理を支援するダッシュボード画面である。

**業務上の目的・背景**：GitLabでは、課題へのアサイン、マージリクエストのレビュー依頼、メンションなど、様々なイベントによってユーザーにアクション要求が発生する。本画面は、これらのTo-Doを一元管理し、優先順位付けと効率的な対応を支援する。To-Doはユーザーが明示的に「Done」にしない限り残り続け、対応漏れを防止する。

**画面へのアクセス方法**：ログイン後、サイドバーまたはトップナビゲーションから「To-Do List」メニューを選択。ヘッダーのベルアイコンからもアクセス可能。直接URLアクセスの場合は `/dashboard/todos` へアクセスする。

**主要な操作・処理内容**：
1. To-Do一覧の表示
2. To-Doの「Done」マーク（個別/一括）
3. To-Doのフィルタリング（タイプ、プロジェクト、グループ、作成者など）
4. To-Doの対象（Issue、MR等）への遷移
5. スヌーズ機能によるTo-Doの一時非表示

**画面遷移**：
- 遷移元：ログイン画面、サイドバー、トップナビゲーション、ヘッダーベルアイコン
- 遷移先：課題詳細画面、MR詳細画面、対象リソースの画面

**権限による表示制御**：ログインユーザーのみアクセス可能。表示されるTo-Doはログインユーザー自身に対するもののみ。To-Doが存在しない場合は空状態のUIが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 124 | Todoリスト | 主機能 | ユーザーのTo-Doリスト表示・管理 |

## 画面種別

一覧

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/dashboard/todos` | GET | To-Do一覧 |
| `/dashboard/todos/:id` | DELETE | To-Doを完了にする |

## 入出力項目

### 入力項目（フィルタ）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| action_id | integer | No | アクションタイプでフィルタ |
| author_id | integer | No | 作成者でフィルタ |
| project_id | integer | No | プロジェクトでフィルタ |
| group_id | integer | No | グループでフィルタ |
| type | string | No | 対象タイプでフィルタ |
| state | string | No | 状態（pending, done） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| todos | Array | To-Do一覧 |

## 表示項目

### To-Do一覧

| 項目名 | 説明 | 備考 |
|--------|------|------|
| アクションタイプ | assigned, mentioned, review_requested等 | アイコン表示 |
| 対象 | Issue、MR、コミット等の対象リソース | リンク |
| プロジェクト/グループ | 対象が属するプロジェクトまたはグループ | リンク |
| 作成者 | To-Doを発生させた人 | アバター表示 |
| 作成日時 | To-Do作成日時 | 相対時間表示 |
| スヌーズ状態 | スヌーズ中かどうか | |
| Doneボタン | To-Doを完了にするボタン | |

## イベント仕様

### 1-To-Doリストの読み込み

Vue.jsアプリケーション（`#js-todos-app-root`）がマウントされ、APIを通じてTo-Do一覧を取得する。

**処理フロー**：
1. ページ読み込み時にVueアプリケーションが初期化
2. To-Do APIを通じてTo-Do一覧を非同期取得
3. フィルタ条件に基づいてリストを表示

### 2-個別To-DoをDoneにする

各To-Doの「Done」ボタンをクリックすると、該当To-Doが完了状態になる。

**処理フロー**：
1. Doneボタンクリック
2. DELETE `/dashboard/todos/:id` APIへリクエスト
3. 成功時、リストから該当To-Doを除去

### 3-全To-DoをDoneにする

「Mark all as done」ボタンをクリックすると、表示中の全To-Doが完了状態になる。

### 4-To-Doのスヌーズ

To-Doをスヌーズすると、指定期間リストに表示されなくなる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | todos | SELECT | ユーザーのTo-Do一覧を取得 |
| Done操作 | todos | UPDATE | stateをdoneに更新 |
| スヌーズ | todos | UPDATE | snoozed_untilを設定 |

### テーブル別更新項目詳細

#### todos

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, user_id, author_id, target_id, target_type, action, state, project_id, group_id, created_at | user_id = current_user.id | |
| UPDATE | state | 'done' | Done操作時 |
| UPDATE | snoozed_until | 指定日時 | スヌーズ時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | "All done! You have no pending todos." | To-Doが存在しない場合 |
| MSG-002 | 成功 | "Todo was successfully marked as done." | Done操作成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 未ログイン | ログイン画面へリダイレクト | - |
| To-Do不存在 | 404エラー | Not Found |
| API通信エラー | エラーメッセージ表示 | "Something went wrong. Please try again." |

## 備考

- Vue.jsベースのSPA実装（`#js-todos-app-root`）
- To-Doが存在しない場合は専用の空状態UI（`_user_has_no_todos`パーシャル）を表示
- 2要素認証リカバリー設定チェック機能あり
- Internal Event Tracking（view_todo_list）でアクセス追跡
- issues_dashboard_pathとmerge_requests_dashboard_pathがアプリに渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、To-Doのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | todo.rb | `app/models/todo.rb` | Todoモデルの定義、アクションタイプ定数 |

**読解のコツ**: ACTION_NAMESハッシュでアクションタイプの定義を確認。state_machineによる状態遷移に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | todos_controller.rb | `app/controllers/dashboard/todos_controller.rb` | indexアクション、Internal Event Tracking |

**主要処理フロー**:
1. **Line 4**: `include Gitlab::InternalEventsTracking`でイベント追跡を有効化
2. **Line 9-13**: indexアクションで`view_todo_list`イベントを追跡

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/dashboard/todos/index.html.haml` | HAMLテンプレート、Vue.jsアプリのマウント |

**主要処理フロー**:
- **Line 4-6**: 2FA リカバリー設定チェック、Ultimate Trial表示
- **Line 8-11**: To-Doの有無による条件分岐
- **Line 10-11**: Vue.jsアプリのマウントとパス情報の受け渡し

#### Step 4: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dashboard.rb | `config/routes/dashboard.rb` | todosリソースの定義 |

**主要処理フロー**:
- **Line 25**: `resources :todos, only: [:index, :destroy]`

### プログラム呼び出し階層図

```
Dashboard::TodosController#index
    |
    +-- track_internal_event('view_todo_list')
    |
    +-- render 'dashboard/todos/index'
           |
           +-- render_two_factor_auth_recovery_settings_check
           |
           +-- render_dashboard_ultimate_trial
           |
           +-- current_user.todos.any? (条件分岐)
                  |
                  +-- PageHeadingComponent ('To-Do List')
                  |
                  +-- #js-todos-app-root (Vue.js)
                  |       |
                  |       +-- issues_dashboard_path
                  |       +-- merge_requests_dashboard_path
                  |
                  +-- render 'dashboard/todos/user_has_no_todos' (To-Do無し時)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ Dashboard::TodosController ───▶ HTMLレスポンス
(filter等)              |                           (Vue.jsアプリ)
                        |
                        v
                   Todo (Model)
                        |
                        v
                   PostgreSQL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| todos_controller.rb | `app/controllers/dashboard/todos_controller.rb` | コントローラ | リクエスト処理 |
| index.html.haml | `app/views/dashboard/todos/index.html.haml` | ビュー | 画面テンプレート |
| _user_has_no_todos.html.haml | `app/views/dashboard/todos/_user_has_no_todos.html.haml` | パーシャル | 空状態UI |
| todo.rb | `app/models/todo.rb` | モデル | To-Doデータ定義 |
| dashboard.rb | `config/routes/dashboard.rb` | ルート | URL定義 |
