# 画面設計書 152-ボード一覧

## 概要

本ドキュメントは、GitLabのグループ課題ボード一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで作成された課題ボード（Issue Board）の一覧を表示し、ボードの選択・作成・管理を行います。課題ボードはカンバン方式で課題を管理するための機能で、グループ配下の複数プロジェクトの課題を横断的に管理できます。

**業務上の目的・背景**：アジャイル開発やスクラムにおいて、課題の進捗状況を視覚的に把握することは重要です。グループボードを使用することで、複数プロジェクトにまたがる課題を一元的にカンバン管理でき、チーム全体の作業状況を効率的に追跡できます。

**画面へのアクセス方法**：グループのサイドバーから「課題」>「ボード」を選択することでアクセスできます。直接URLからもアクセス可能です。

**主要な操作・処理内容**：
1. 既存のボード一覧を表示する
2. ボードを選択して詳細表示に遷移する
3. 新規ボードを作成する（権限がある場合）
4. ボードの設定を変更する（権限がある場合）
5. ボードを削除する（権限がある場合）

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。ボードを選択するとボード表示画面（153-ボード表示）に遷移します。

**権限による表示制御**：グループの「read_issue_board」権限を持つユーザーがこの画面にアクセスできます。ボードの作成・編集・削除には「admin_issue_board」権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 39 | イシューボード | 主機能 | グループ課題ボードの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/boards`
- HTTPメソッド: GET
- コントローラー: `Groups::BoardsController#index`

## 入出力項目

この画面は主に表示画面のため、入力項目は限定的です。

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ボード選択 | board_id | 選択 | - | 表示するボードの選択 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Issue Boards」と表示 |
| ボードセレクター | 利用可能なボードのドロップダウン |
| ボード名 | 現在選択中のボード名 |
| ボード操作メニュー | 編集・削除などのアクション（権限がある場合） |
| Vueアプリケーション | `#js-issuable-board-app`にマウントされるSPA |

## イベント仕様

### 1-ボード選択

ボードセレクターからボードを選択すると、選択したボードの表示画面に遷移します。

### 2-新規ボード作成

「New board」ボタン押下時、新規ボード作成モーダルが表示されます。`admin_issue_board`権限が必要です。

### 3-ボード編集

ボード設定メニューから「Edit board」を選択すると、ボード編集モーダルが表示されます。

### 4-ボード削除

ボード設定メニューから「Delete board」を選択すると、確認ダイアログ後にボードが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | boards | SELECT | ボード一覧の取得 |
| 新規作成 | boards | INSERT | 新規ボードの作成 |
| ボード削除 | boards | DELETE | ボードの削除 |

### テーブル別更新項目詳細

#### boards

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, group_id | WHERE group_id = :group_id | ボード一覧取得 |
| INSERT | name, group_id | フォーム入力値 | 新規作成時 |
| DELETE | - | WHERE id = :board_id | 削除時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 確認 | "Are you sure you want to delete this board?" | ボード削除時 |
| M002 | エラー | "Board could not be created" | ボード作成失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| read_issue_board権限なし | アクセス拒否ページを表示 |
| ボードが存在しない | 自動的にデフォルトボードを作成 |

## 備考

- グループボードでは、グループ配下のすべてのプロジェクトの課題を管理可能
- 複数ボードの利用可否はライセンスによる制限がある（`multiple_issue_boards_available?`）
- ボードはVue.jsによるSPAとして実装されている
- 共有テンプレート（`shared/boards/_show.html.haml`）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ボードのデータモデルと関連エンティティを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | board.rb | `app/models/board.rb` | ボードモデルの定義を理解する |

**読解のコツ**: Boardモデルはグループまたはプロジェクトに属し、`group_board?`メソッドで判別可能。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | boards_controller.rb | `app/controllers/groups/boards_controller.rb` | indexアクションの実装を理解する |
| 2-2 | boards_actions.rb | `app/controllers/concerns/boards_actions.rb` | 共通ロジックを理解する |

**主要処理フロー**:
1. **行8-13**: before_actionでフィーチャーフラグ設定
2. **行20-23**: `board_finder`でボードを検索
3. **行25-28**: `board_create_service`でボード作成
4. **行30-32**: `authorize_read_board!`で権限チェック

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/groups/boards/index.html.haml` | 一覧画面テンプレートを理解する |
| 3-2 | _show.html.haml | `app/views/shared/boards/_show.html.haml` | 共有ボードテンプレートを理解する |

**主要処理フロー**:
- **index行1**: 共有テンプレートをレンダリング
- **show行22**: Vue.jsアプリケーションのマウントポイント

#### Step 4: ヘルパーを理解する

ビューで使用されるヘルパーメソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | boards_helper.rb | `app/helpers/boards_helper.rb` | board_dataメソッドの実装を理解する |

**主要処理フロー**:
- **行8-30**: `board_data`メソッドでVueアプリに渡すデータを生成
- **行107-117**: 権限チェック用メソッド

### プログラム呼び出し階層図

```
Groups::BoardsController#index
    │
    ├─ include BoardsActions
    │      │
    │      ├─ before_action :authorize_read_board!
    │      │      └─ can?(current_user, :read_issue_board, group)
    │      │
    │      └─ index アクション（BoardsActions内）
    │             └─ board_finder.execute
    │
    ├─ board_finder (行20-23)
    │      └─ Boards::BoardsFinder.new
    │
    └─ render (index.html.haml)
           └─ shared/boards/_show
                  │
                  ├─ board_data ヘルパー呼び出し
                  │      └─ work_items_data
                  │
                  └─ #js-issuable-board-app
                         └─ Vue.jsアプリケーション
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::BoardsController
(group_id,                 │
 board_id)                 │
        ─────────▶   BoardsActions
                           │
                           ├──▶ Boards::BoardsFinder
                           │         │
                           │         ▼
                           │     boardsテーブル
                           │
                           ├──▶ BoardsHelper.board_data
                           │         │
                           │         ▼
                           │     JSON データ
                           │
                           └──▶ Vue.js SPA
                                     │
                                     ▼
                              ボード一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| boards_controller.rb | `app/controllers/groups/boards_controller.rb` | コントローラー | グループボード用コントローラー |
| boards_actions.rb | `app/controllers/concerns/boards_actions.rb` | Concern | ボードの共通ロジック |
| index.html.haml | `app/views/groups/boards/index.html.haml` | ビュー | 一覧画面テンプレート |
| _show.html.haml | `app/views/shared/boards/_show.html.haml` | 部分ビュー | 共有ボードテンプレート |
| boards_helper.rb | `app/helpers/boards_helper.rb` | ヘルパー | ボードデータ生成ヘルパー |
| boards_finder.rb | `app/finders/boards/boards_finder.rb` | Finder | ボード検索ロジック |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行154） |
