# 画面設計書 154-作業アイテム一覧

## 概要

本ドキュメントは、GitLabのグループ作業アイテム一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで管理される作業アイテム（Work Items）の一覧を表示します。作業アイテムはIssue、Epic、Task、Objectiveなど様々なタイプを包含する統一的なエンティティで、グループ配下の複数プロジェクトにまたがる作業を一元管理できます。

**業務上の目的・背景**：従来のIssueやEpicに代わる統一的な作業管理システムとして、Work Items機能が導入されました。階層構造を持つ作業アイテムにより、戦略的な目標（Objective）から具体的なタスクまで、組織全体の作業を体系的に管理できます。

**画面へのアクセス方法**：グループのサイドバーから「課題」>「作業アイテム」を選択することでアクセスできます。直接URLからもアクセス可能です。

**主要な操作・処理内容**：
1. 作業アイテムの一覧を表示する
2. 作業アイテムをフィルタリング・検索する
3. 作業アイテムをソートする
4. 新規作業アイテムを作成する
5. 作業アイテムの詳細画面に遷移する

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。作業アイテムをクリックすると詳細画面（155-作業アイテム詳細）に遷移します。

**権限による表示制御**：グループの閲覧権限を持つユーザーがこの画面にアクセスできます。作業アイテムの作成には「create_work_item」権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 46 | ワークアイテム管理 | 主機能 | グループ作業アイテムの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/work_items`
- HTTPメソッド: GET
- コントローラー: `Groups::WorkItemsController#index`
- RSS: `/groups/:group_id/-/work_items.atom`
- カレンダー: `/groups/:group_id/-/work_items.ics`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| フィルター | filter | クエリパラメータ | - | ラベル、担当者、マイルストーン等 |
| 検索 | search | クエリパラメータ | - | タイトル検索 |
| ソート | sort | クエリパラメータ | - | ソート順 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Work items」と表示 |
| 作業アイテム一覧 | 作業アイテムのリスト |
| フィルターバー | 絞り込み条件 |
| ソートセレクター | ソート順の選択 |
| ページネーション | ページ切り替え |
| 新規作成ボタン | 新規作業アイテム作成（権限がある場合） |
| Vueアプリケーション | `#js-work-items`にマウントされるSPA |

## イベント仕様

### 1-作業アイテムのクリック

作業アイテムをクリックすると、作業アイテム詳細画面に遷移します。

### 2-フィルターの適用

フィルターバーで条件を設定すると、表示される作業アイテムが絞り込まれます。

### 3-ソートの変更

ソートセレクターで順序を変更すると、作業アイテムの表示順が変更されます。

### 4-新規作成

「New work item」ボタンをクリックすると、作業アイテム作成画面に遷移します。

### 5-RSS/カレンダー購読

RSS/ICSフィードにアクセスすると、作業アイテムをフィード形式で取得できます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | issues (work_items) | SELECT | 作業アイテム一覧の取得 |

### テーブル別更新項目詳細

#### issues（work_items）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, state, work_item_type_id, etc. | グループ配下の作業アイテム | 一覧取得 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 情報 | "No work items to display" | 作業アイテムが存在しない場合 |
| M002 | 情報 | "Search is not available at this time" | 検索機能が利用できない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| グループが見つからない | 404エラーページを表示 |
| 権限不足 | アクセス拒否ページを表示 |
| 検索レート制限超過 | レート制限エラーを表示 |

## 備考

- 作業アイテムはVue.jsによるSPAとして実装されている
- GraphQL APIを通じてデータを取得
- 作業アイテム計画ビュー（work_item_planning_view）のフィーチャーフラグがある
- 保存済みビュー（work_items_saved_views）のフィーチャーフラグがある
- デザイン管理用のスタイルシートも適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、作業アイテムのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | work_item.rb | `app/models/work_item.rb` | 作業アイテムモデルを理解する |
| 1-2 | work_item_type.rb | `app/models/work_items/type.rb` | 作業アイテムタイプを理解する |

**読解のコツ**: WorkItemはIssueを継承（STI）しており、work_item_type_idで種別を区別する。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | work_items_controller.rb | `app/controllers/groups/work_items_controller.rb` | indexアクションの実装を理解する |

**主要処理フロー**:
1. **行10-17**: before_actionでフィーチャーフラグ設定
2. **行20-22**: 検索レート制限チェック
3. **行29**: indexアクションはビューをレンダリングするだけ

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/groups/work_items/index.html.haml` | 一覧画面テンプレートを理解する |

**主要処理フロー**:
- **行1**: ページタイトル「Work items」を設定
- **行2-4**: スタイルシートの追加
- **行6**: Vue.jsアプリケーションのマウントポイント

#### Step 4: ヘルパーを理解する

ビューで使用されるヘルパーメソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | work_items_helper.rb | `app/helpers/work_items_helper.rb` | work_item_views_only_dataメソッドを理解する |

**主要処理フロー**:
- **行18-20**: `work_item_views_only_data`でVueアプリに渡すデータを生成
- **行89-97**: `base_data_legacy_only`で最小限のデータを返す

### プログラム呼び出し階層図

```
Groups::WorkItemsController#index
    │
    ├─ include SearchRateLimitable
    │      └─ check_search_rate_limit! (行20-22)
    │
    ├─ include WorkItemsCollections
    │      └─ 共通のコレクション処理
    │
    ├─ before_action (行10-17)
    │      ├─ push_frontend_feature_flag(:notifications_todos_buttons)
    │      ├─ push_force_frontend_feature_flag(:work_item_planning_view)
    │      ├─ push_force_frontend_feature_flag(:work_items_saved_views)
    │      └─ push_force_frontend_feature_flag(:use_work_item_url)
    │
    └─ render (index.html.haml)
           │
           ├─ work_item_views_only_data ヘルパー
           │      └─ base_data_legacy_only
           │
           └─ #js-work-items
                  └─ Vue.jsアプリケーション
                         └─ GraphQL API呼び出し
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::WorkItemsController
(group_id,                 │
 filter,                   │
 sort)                     │
        ─────────▶   index アクション
                           │
                           ├──▶ work_item_views_only_data
                           │         │
                           │         ▼
                           │     JSON データ
                           │
                           └──▶ Vue.js SPA
                                     │
                                     ├──▶ GraphQL API
                                     │         │
                                     │         ▼
                                     │     issues (work_items) テーブル
                                     │
                                     └──▶ 作業アイテム一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| work_items_controller.rb | `app/controllers/groups/work_items_controller.rb` | コントローラー | グループ作業アイテム用コントローラー |
| index.html.haml | `app/views/groups/work_items/index.html.haml` | ビュー | 一覧画面テンプレート |
| work_items_helper.rb | `app/helpers/work_items_helper.rb` | ヘルパー | 作業アイテムデータ生成ヘルパー |
| work_item.rb | `app/models/work_item.rb` | モデル | 作業アイテムモデル |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行193） |
