# 画面設計書 155-作業アイテム詳細

## 概要

本ドキュメントは、GitLabのグループ作業アイテム詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで管理される作業アイテム（Work Item）の詳細情報を表示・編集します。作業アイテムのタイトル、説明、ステータス、担当者、ラベル、マイルストーン、親子関係などの情報を確認・更新できます。

**業務上の目的・背景**：作業アイテム詳細画面は、個々の作業項目の完全な情報を把握し、適切な管理・更新を行うための中心的な画面です。従来のIssue詳細画面に相当する機能を提供しつつ、階層構造やタイプ別のウィジェットなど、より柔軟な作業管理を可能にします。

**画面へのアクセス方法**：作業アイテム一覧画面から作業アイテムをクリックするか、直接URLにアクセスすることで表示されます。

**主要な操作・処理内容**：
1. 作業アイテムの詳細情報を表示する
2. タイトル・説明を編集する
3. ステータス（オープン/クローズ）を変更する
4. 担当者・ラベル・マイルストーンを設定する
5. コメントを追加する
6. 子アイテムを追加・管理する
7. 親アイテムとの関連を設定する

**画面遷移**：作業アイテム一覧画面から遷移してきます。新規作成の場合は`/new`パスでアクセスします。関連する他の作業アイテムへのリンクから遷移も可能です。

**権限による表示制御**：作業アイテムの閲覧には対応するグループ/プロジェクトの閲覧権限が必要です。編集には`admin_issue`相当の権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 46 | ワークアイテム管理 | 主機能 | グループ作業アイテムの詳細表示・編集 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/groups/:group_id/-/work_items/:iid`
- 新規作成: `/groups/:group_id/-/work_items/new`
- HTTPメソッド: GET
- コントローラー: `Groups::WorkItemsController#show`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| IID | iid | 数値/文字列 | ○ | 作業アイテムの内部ID（または'new'） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| タイトル | 作業アイテムのタイトル |
| 説明 | Markdown形式の説明 |
| ステータス | オープン/クローズ |
| タイプ | Issue, Epic, Task, Objectiveなど |
| 担当者 | 担当ユーザー |
| ラベル | 付与されたラベル |
| マイルストーン | 関連するマイルストーン |
| 期限 | 期限日 |
| 親アイテム | 親作業アイテムへのリンク |
| 子アイテム | 子作業アイテムのリスト |
| コメント | ディスカッションスレッド |
| アクティビティ | 変更履歴 |
| Vueアプリケーション | `#js-work-items`にマウントされるSPA |

## イベント仕様

### 1-タイトル編集

タイトルをクリックして編集モードに入り、変更内容を保存できます。

### 2-説明編集

説明エリアをクリックしてMarkdownエディタで編集できます。

### 3-ステータス変更

「Close」/「Reopen」ボタンでステータスを切り替えます。

### 4-担当者設定

サイドバーから担当者を選択・設定します。

### 5-ラベル設定

サイドバーからラベルを追加・削除します。

### 6-コメント追加

コメントフォームからコメントを投稿します。

### 7-子アイテム追加

「Add child」ボタンから子アイテムを追加します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | issues (work_items) | SELECT | 作業アイテムの取得 |
| タイトル編集 | issues | UPDATE | タイトルの更新 |
| 説明編集 | issues | UPDATE | 説明の更新 |
| ステータス変更 | issues | UPDATE | stateの更新 |
| コメント追加 | notes | INSERT | コメントの追加 |
| ラベル設定 | label_links | INSERT/DELETE | ラベル関連の更新 |
| 子アイテム追加 | work_item_parent_links | INSERT | 親子関係の追加 |

### テーブル別更新項目詳細

#### issues（work_items）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE iid = :iid AND namespace_id = :group_id | 詳細取得 |
| UPDATE | title | 編集値 | タイトル更新 |
| UPDATE | description | 編集値 | 説明更新 |
| UPDATE | state | open/closed | ステータス更新 |

#### notes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | noteable_id, noteable_type, note | 入力値 | コメント追加 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 成功 | "Work item updated" | 更新成功時 |
| M002 | エラー | "Failed to update work item" | 更新失敗時 |
| M003 | エラー | "Work item not found" | 作業アイテムが見つからない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 作業アイテムが見つからない | 404エラーまたはnot_foundヘルパー呼び出し |
| グループが作業アイテムをサポートしていない | not_foundヘルパー呼び出し |
| 権限不足 | アクセス拒否ページを表示 |
| 新規作成時に未認証 | ログイン画面にリダイレクト |

## 備考

- 作業アイテムはVue.jsによるSPAとして実装されている
- GraphQL APIを通じてデータの取得・更新を行う
- `/new`パスでアクセスした場合は新規作成モードとなる
- 右サイドバーは無効化される（`@right_sidebar = false`）
- GFMフォームが有効化される（`@gfm_form = true`）
- noteable_typeは'WorkItem'に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、作業アイテムのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | work_item.rb | `app/models/work_item.rb` | 作業アイテムモデルを理解する |
| 1-2 | work_item_parent_link.rb | `app/models/work_items/parent_link.rb` | 親子関係を理解する |

**読解のコツ**: WorkItemはIssueを継承（STI）しており、多くの機能がIssueから継承される。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | work_items_controller.rb | `app/controllers/groups/work_items_controller.rb` | showアクションの実装を理解する |

**主要処理フロー**:
1. **行19**: `handle_new_work_item_path`で新規作成パスを処理
2. **行31-35**: showアクションで作業アイテムを取得
3. **行32**: グループが作業アイテムをサポートしているかチェック
4. **行34-35**: WorkItemsFinderで作業アイテムを検索

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/groups/work_items/show.html.haml` | 詳細画面テンプレートを理解する |

**主要処理フロー**:
- **行2**: 右サイドバーを無効化
- **行3-4**: 作業アイテムが存在する場合、メタデータをレンダリング
- **行5-10**: スタイルシートとフォーム設定
- **行12**: Vue.jsアプリケーションのマウントポイント

#### Step 4: ヘルパーを理解する

ビューで使用されるヘルパーメソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | work_items_helper.rb | `app/helpers/work_items_helper.rb` | work_item_views_only_dataメソッドを理解する |

### プログラム呼び出し階層図

```
Groups::WorkItemsController#show
    │
    ├─ before_action :handle_new_work_item_path (行19)
    │      │
    │      └─ show_params[:iid] == 'new' の場合
    │             ├─ authenticate_user!
    │             └─ render :show
    │
    ├─ フィーチャーフラグ設定 (行10-17)
    │      ├─ notifications_todos_buttons
    │      ├─ glql_load_on_click
    │      ├─ work_item_planning_view
    │      ├─ work_items_saved_views
    │      └─ use_work_item_url
    │
    ├─ show アクション (行31-36)
    │      │
    │      ├─ group.supports_work_items? チェック (行32)
    │      │
    │      └─ WorkItems::WorkItemsFinder.new (行34-35)
    │             └─ .execute.with_work_item_type.find_by_iid
    │
    └─ render (show.html.haml)
           │
           ├─ shared/work_item_metadata (行4)
           │
           ├─ work_item_views_only_data ヘルパー
           │
           └─ #js-work-items
                  └─ Vue.jsアプリケーション
                         └─ GraphQL API呼び出し
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::WorkItemsController
(group_id,                 │
 iid)                      │
        ─────────▶   show アクション
                           │
                           ├──▶ supports_work_items? チェック
                           │
                           ├──▶ WorkItems::WorkItemsFinder
                           │         │
                           │         ▼
                           │     issues (work_items) テーブル
                           │
                           ├──▶ work_item_views_only_data
                           │         │
                           │         ▼
                           │     JSON データ
                           │
                           └──▶ Vue.js SPA
                                     │
                                     ├──▶ GraphQL API
                                     │         │
                                     │         ▼
                                     │     作業アイテム詳細取得
                                     │     コメント取得
                                     │     子アイテム取得
                                     │
                                     └──▶ 作業アイテム詳細表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| work_items_controller.rb | `app/controllers/groups/work_items_controller.rb` | コントローラー | グループ作業アイテム用コントローラー |
| show.html.haml | `app/views/groups/work_items/show.html.haml` | ビュー | 詳細画面テンプレート |
| work_items_helper.rb | `app/helpers/work_items_helper.rb` | ヘルパー | 作業アイテムデータ生成ヘルパー |
| work_item.rb | `app/models/work_item.rb` | モデル | 作業アイテムモデル |
| work_items_finder.rb | `app/finders/work_items/work_items_finder.rb` | Finder | 作業アイテム検索ロジック |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行193） |
