# 画面設計書 156-パッケージ一覧

## 概要

本ドキュメントは、GitLabのグループパッケージ一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで管理されるパッケージレジストリの一覧を表示します。Maven、npm、NuGet、PyPI、Composerなど様々な形式のパッケージを一覧表示し、パッケージの検索・閲覧・削除が可能です。

**業務上の目的・背景**：パッケージレジストリは、ソフトウェア開発において依存ライブラリやモジュールを管理するための重要な機能です。グループレベルのパッケージ一覧により、組織全体で共有されるパッケージを一元管理でき、依存関係の把握やバージョン管理が容易になります。

**画面へのアクセス方法**：グループのサイドバーから「パッケージとレジストリ」>「パッケージレジストリ」を選択することでアクセスできます。直接URLからもアクセス可能です。

**主要な操作・処理内容**：
1. グループ配下のパッケージ一覧を表示する
2. パッケージ名やタイプでフィルタリングする
3. パッケージの詳細画面に遷移する
4. パッケージを削除する（権限がある場合）
5. パッケージレジストリの設定画面に遷移する

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。パッケージをクリックすると詳細画面に遷移します。

**権限による表示制御**：グループの閲覧権限を持つユーザーがこの画面にアクセスできます。パッケージの削除には`destroy_package`権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | グループパッケージの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/packages`
- HTTPメソッド: GET
- コントローラー: `Groups::PackagesController#index`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| パッケージタイプ | package_type | 選択 | - | Maven, npm, NuGetなどのフィルター |
| 検索 | search | テキスト | - | パッケージ名検索 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Package registry」と表示 |
| パッケージ一覧 | パッケージのリスト |
| パッケージ名 | パッケージの名前 |
| バージョン | パッケージのバージョン |
| タイプ | パッケージの種類（Maven, npm等） |
| 公開日時 | パッケージの公開日時 |
| 設定リンク | パッケージ設定画面へのリンク（権限がある場合） |
| Vueアプリケーション | `#js-vue-packages-list`にマウントされるSPA |

## イベント仕様

### 1-パッケージクリック

パッケージをクリックすると、パッケージの詳細画面に遷移します。

### 2-フィルター適用

パッケージタイプを選択すると、表示されるパッケージが絞り込まれます。

### 3-パッケージ削除

削除ボタンをクリックすると、確認後にパッケージが削除されます。`destroy_package`権限が必要です。

### 4-設定画面遷移

設定リンクをクリックすると、パッケージレジストリの設定画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | packages_packages | SELECT | パッケージ一覧の取得 |
| パッケージ削除 | packages_packages | DELETE | パッケージの削除 |

### テーブル別更新項目詳細

#### packages_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, version, package_type, created_at | グループ配下のプロジェクトのパッケージ | 一覧取得 |
| DELETE | - | WHERE id = :package_id | 削除時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 情報 | "No packages to display" | パッケージが存在しない場合 |
| M002 | 確認 | "Are you sure you want to delete this package?" | パッケージ削除時 |
| M003 | 成功 | "Package deleted successfully" | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| パッケージ機能が無効 | 404エラーページを表示 |
| グループが見つからない | 404エラーページを表示 |

## 備考

- パッケージ機能はグループの`packages_feature_enabled?`で有効/無効を判定
- パッケージ一覧はVue.jsによるSPAとして実装されている
- npmグループURLやインスタンスURLなどのレジストリ情報が提供される
- 設定画面リンクは`show_group_package_registry_settings`で表示判定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パッケージのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.rb | `app/models/packages/package.rb` | パッケージモデルを理解する |

**読解のコツ**: Packages::Packageモデルはプロジェクトに属し、package_typeで種別を判別する。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | packages_controller.rb | `app/controllers/groups/packages_controller.rb` | index/showアクションを理解する |

**主要処理フロー**:
1. **行5**: `verify_packages_enabled!`でパッケージ機能の有効性チェック
2. **行10**: indexアクションはビューをレンダリング
3. **行13-15**: showアクションはindexをレンダリング（フロントエンドルーティング用）
4. **行19-21**: `verify_packages_enabled!`の実装

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/groups/packages/index.html.haml` | 一覧画面テンプレートを理解する |

**主要処理フロー**:
- **行1**: ページタイトル「Package registry」を設定
- **行4-5**: Vue.jsアプリケーションのマウントポイント

#### Step 4: ヘルパーを理解する

ビューで使用されるヘルパーメソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | packages_helper.rb | `app/helpers/packages_helper.rb` | group_packages_template_dataメソッドを理解する |

**主要処理フロー**:
- **行92-107**: `group_packages_template_data`でVueアプリに渡すデータを生成
- **行77-80**: `show_group_package_registry_settings`で設定リンク表示判定
- **行87-89**: `can_delete_group_packages?`で削除権限判定

### プログラム呼び出し階層図

```
Groups::PackagesController#index
    │
    ├─ before_action :verify_packages_enabled! (行5)
    │      └─ group.packages_feature_enabled? (行20)
    │
    └─ render (index.html.haml)
           │
           ├─ group_packages_template_data ヘルパー
           │      ├─ packages_template_data
           │      │      ├─ empty_list_illustration
           │      │      └─ npm_instance_url
           │      │
           │      ├─ can_delete_packages
           │      ├─ endpoint
           │      ├─ full_path
           │      ├─ npm_group_url
           │      └─ settings_path
           │
           └─ #js-vue-packages-list
                  └─ Vue.jsアプリケーション
                         └─ API呼び出し
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::PackagesController
(group_id)                 │
        ─────────▶   verify_packages_enabled!
                           │
                           ├──▶ packages_feature_enabled? チェック
                           │
                           └──▶ render index.html.haml
                                     │
                                     ├──▶ group_packages_template_data
                                     │         │
                                     │         ├─ can_delete_group_packages?
                                     │         ├─ show_group_package_registry_settings
                                     │         └─ package_registry_group_url
                                     │
                                     └──▶ Vue.js SPA
                                              │
                                              ├──▶ REST API (group_packages_path)
                                              │         │
                                              │         ▼
                                              │     packages_packages テーブル
                                              │
                                              └──▶ パッケージ一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| packages_controller.rb | `app/controllers/groups/packages_controller.rb` | コントローラー | グループパッケージ用コントローラー |
| index.html.haml | `app/views/groups/packages/index.html.haml` | ビュー | 一覧画面テンプレート |
| packages_helper.rb | `app/helpers/packages_helper.rb` | ヘルパー | パッケージデータ生成ヘルパー |
| package.rb | `app/models/packages/package.rb` | モデル | パッケージモデル |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行104） |
