# 画面設計書 157-インフラレジストリ

## 概要

本ドキュメントは、GitLabのグループインフラストラクチャレジストリ（Terraform Module Registry）画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで管理されるTerraformモジュールレジストリの一覧を表示します。Terraformモジュールはインフラストラクチャ・アズ・コード（IaC）で使用される再利用可能なインフラ構成コンポーネントであり、グループ内で共有・管理できます。

**業務上の目的・背景**：Terraformモジュールレジストリにより、組織全体で標準化されたインフラ構成を共有できます。これにより、インフラ構築の一貫性が保たれ、ベストプラクティスの展開が容易になります。

**画面へのアクセス方法**：グループのサイドバーから「パッケージとレジストリ」>「Terraform Module Registry」を選択することでアクセスできます。直接URLからもアクセス可能です。

**主要な操作・処理内容**：
1. Terraformモジュールの一覧を表示する
2. モジュールの詳細を確認する
3. モジュールをダウンロード・使用する

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。

**権限による表示制御**：グループの閲覧権限を持つユーザーがこの画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | グループインフラレジストリの表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/terraform_module_registry`
- 旧パス（リダイレクト）: `/groups/:group_id/-/infrastructure_registry`
- HTTPメソッド: GET
- コントローラー: `Groups::InfrastructureRegistryController#index`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 検索 | name | テキスト | - | モジュール名検索 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Terraform Module Registry」と表示 |
| モジュール一覧 | Terraformモジュールのリスト |
| モジュール名 | モジュールの名前 |
| バージョン | モジュールのバージョン |
| 公開日時 | モジュールの公開日時 |
| 空リストイラスト | モジュールがない場合の説明画像 |
| Vueアプリケーション | `#js-vue-packages-list`にマウントされるSPA |

## イベント仕様

### 1-モジュールクリック

モジュールをクリックすると、モジュールの詳細情報が表示されます。

### 2-検索

検索ボックスにモジュール名を入力すると、一覧がフィルタリングされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | packages_packages | SELECT | Terraformモジュール一覧の取得 |

### テーブル別更新項目詳細

#### packages_packages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, version, created_at | WHERE package_type = 'terraform_module' | モジュール一覧取得 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 情報 | "No Terraform modules to display" | モジュールが存在しない場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| パッケージ機能が無効 | 404エラーページを表示 |
| グループが見つからない | 404エラーページを表示 |

## 備考

- 旧URL（`/infrastructure_registry`）は新URL（`/terraform_module_registry`）にリダイレクトされる
- パッケージ機能はグループの`packages_feature_enabled?`で有効/無効を判定
- 画面はVue.jsによるSPAとして実装されている
- `page_type`は`'groups'`に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Terraformモジュールのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | package.rb | `app/models/packages/package.rb` | パッケージモデルを理解する（terraform_moduleタイプ） |

**読解のコツ**: Terraformモジュールは`package_type`が`terraform_module`のPackagesレコードとして保存される。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | infrastructure_registry_controller.rb | `app/controllers/groups/infrastructure_registry_controller.rb` | コントローラーの実装を理解する |

**主要処理フロー**:
1. **行5**: `verify_packages_enabled!`でパッケージ機能の有効性チェック
2. **行10-14**: `verify_packages_enabled!`の実装

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/groups/infrastructure_registry/index.html.haml` | 一覧画面テンプレートを理解する |

**主要処理フロー**:
- **行1**: ページタイトル「Terraform Module Registry」を設定
- **行3-5**: Vue.jsアプリケーションのマウントポイントとデータ設定

#### Step 4: ルーティングを理解する

URLパスとリダイレクトの設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | group.rb | `config/routes/group.rb` | ルーティング定義を理解する |

**主要処理フロー**:
- **行106**: `terraform_module_registry`リソースの定義
- **行107**: 旧パスから新パスへのリダイレクト

### プログラム呼び出し階層図

```
Groups::InfrastructureRegistryController#index
    │
    ├─ before_action :verify_packages_enabled! (行5)
    │      └─ group.packages_feature_enabled? (行13)
    │
    └─ render (index.html.haml)
           │
           └─ #js-vue-packages-list
                  │
                  ├─ resource_id: @group.id
                  ├─ page_type: 'groups'
                  └─ empty_list_illustration
                         │
                         └─ Vue.jsアプリケーション
                                └─ API呼び出し
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::InfrastructureRegistryController
(group_id)                 │
        ─────────▶   verify_packages_enabled!
                           │
                           ├──▶ packages_feature_enabled? チェック
                           │
                           └──▶ render index.html.haml
                                     │
                                     └──▶ Vue.js SPA
                                              │
                                              ├──▶ REST API
                                              │         │
                                              │         ▼
                                              │     packages_packages テーブル
                                              │     (WHERE package_type = 'terraform_module')
                                              │
                                              └──▶ モジュール一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| infrastructure_registry_controller.rb | `app/controllers/groups/infrastructure_registry_controller.rb` | コントローラー | グループインフラレジストリ用コントローラー |
| index.html.haml | `app/views/groups/infrastructure_registry/index.html.haml` | ビュー | 一覧画面テンプレート |
| package.rb | `app/models/packages/package.rb` | モデル | パッケージモデル |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行106-107） |
