# 画面設計書 158-コンテナレジストリ

## 概要

本ドキュメントは、GitLabのグループコンテナレジストリ画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで管理されるDockerコンテナイメージレジストリの一覧を表示します。グループ配下のプロジェクトで作成されたDockerイメージを一覧表示し、閲覧・管理できます。

**業務上の目的・背景**：コンテナレジストリは、Dockerイメージを保存・配布するための機能です。グループレベルのコンテナレジストリにより、組織内の複数プロジェクトで作成されたイメージを一元的に管理でき、デプロイパイプラインやマイクロサービスアーキテクチャにおけるイメージ管理が容易になります。

**画面へのアクセス方法**：グループのサイドバーから「パッケージとレジストリ」>「コンテナレジストリ」を選択することでアクセスできます。直接URLからもアクセス可能です。

**主要な操作・処理内容**：
1. コンテナリポジトリの一覧を表示する
2. リポジトリ内のタグを確認する
3. イメージを削除する（権限がある場合）
4. イメージの詳細情報を確認する

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。リポジトリをクリックするとタグ一覧が表示されます。

**権限による表示制御**：グループの「read_container_image」権限を持つユーザーがこの画面にアクセスできます。管理者にはより詳細な情報が表示される場合があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | コンテナレジストリ | 主機能 | グループコンテナレジストリの表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/container_registries`
- HTTPメソッド: GET (HTML/JSON)
- コントローラー: `Groups::Registry::RepositoriesController#index`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 検索 | name | テキスト | - | リポジトリ名検索 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Container registry」と表示 |
| リポジトリ一覧 | コンテナリポジトリのリスト |
| リポジトリ名 | リポジトリのパス |
| タグ数 | リポジトリ内のタグ数 |
| 最終更新日 | 最後にプッシュされた日時 |
| レジストリホストURL | Dockerレジストリのホスト名 |
| 管理者フラグ | 現在のユーザーが管理者かどうか |
| Vueアプリケーション | `#js-container-registry`にマウントされるSPA |

## イベント仕様

### 1-リポジトリクリック

リポジトリをクリックすると、リポジトリ内のタグ一覧が表示されます。

### 2-検索

検索ボックスにリポジトリ名を入力すると、一覧がフィルタリングされます。

### 3-イメージ削除

削除ボタンをクリックすると、確認後にイメージが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | container_repositories | SELECT | コンテナリポジトリ一覧の取得 |
| イメージ削除 | container_repositories, container_repository_tags | DELETE | イメージの削除 |

### テーブル別更新項目詳細

#### container_repositories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, project_id, created_at | グループ配下のリポジトリ | 一覧取得 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 情報 | "No container images to display" | リポジトリが存在しない場合 |
| M002 | エラー | "Unable to fetch container repositories" | 取得エラー時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| コンテナレジストリが無効 | 404エラーページを表示 |
| read_container_image権限なし | 404エラーページを表示 |
| 接続エラー | エラー状態をフラグで通知 |
| 無効なパスエラー | エラー状態をフラグで通知 |

## 備考

- コンテナレジストリ機能は`Gitlab.config.registry.enabled`で有効/無効を判定
- GraphQL APIを使用してデータを取得（`get_container_repositories`クエリ）
- メタデータデータベースの有効/無効状態が画面に影響する
- 未完了のタグクリーンアップのコールアウト表示がある
- JSON形式でのAPI応答もサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンテナリポジトリのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | container_repository.rb | `app/models/container_repository.rb` | コンテナリポジトリモデルを理解する |

**読解のコツ**: ContainerRepositoryはプロジェクトに属し、外部のレジストリサービスとの連携を行う。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repositories_controller.rb | `app/controllers/groups/registry/repositories_controller.rb` | indexアクションを理解する |

**主要処理フロー**:
1. **行9**: `verify_container_registry_enabled!`でレジストリ有効性チェック
2. **行10**: `authorize_read_container_image!`で権限チェック
3. **行15-31**: indexアクションでHTML/JSON形式のレスポンス
4. **行19-23**: ContainerRepositoriesFinderでリポジトリ検索

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/groups/registry/repositories/index.html.haml` | 一覧画面テンプレートを理解する |

**主要処理フロー**:
- **行1**: ページタイトル「Container registry」を設定
- **行2**: GraphQL起動クエリの設定
- **行5-18**: Vue.jsアプリケーションのマウントポイントとデータ設定

#### Step 4: ヘルパーを理解する

ビューで使用されるデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | packages_helper.rb | `app/helpers/packages_helper.rb` | track_package_eventを理解する |

### プログラム呼び出し階層図

```
Groups::Registry::RepositoriesController#index
    │
    ├─ include PackagesHelper
    │
    ├─ include ::Registry::ConnectionErrorsHandler
    │      └─ 接続エラーハンドリング
    │
    ├─ before_action :verify_container_registry_enabled! (行9)
    │      └─ Gitlab.config.registry.enabled (行41)
    │
    ├─ before_action :authorize_read_container_image! (行10)
    │      └─ can?(current_user, :read_container_image, group) (行45-46)
    │
    └─ index アクション (行15-31)
           │
           ├─ format.html → render
           │
           └─ format.json
                  │
                  ├─ ContainerRepositoriesFinder.new (行19-20)
                  │      └─ .execute.with_api_entity_associations
                  │
                  ├─ track_package_event (行23)
                  │
                  └─ ContainerRepositoriesSerializer (行25-28)
                         └─ .represent_read_only
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::Registry::RepositoriesController
(group_id,                 │
 name)                     │
        ─────────▶   before_action チェック
                           │
                           ├──▶ verify_container_registry_enabled!
                           │
                           ├──▶ authorize_read_container_image!
                           │
                           └──▶ index アクション
                                     │
                                     ├── format.html
                                     │      │
                                     │      └──▶ render index.html.haml
                                     │                 │
                                     │                 └──▶ Vue.js SPA
                                     │                          │
                                     │                          └──▶ GraphQL API
                                     │
                                     └── format.json
                                            │
                                            ├──▶ ContainerRepositoriesFinder
                                            │         │
                                            │         ▼
                                            │     container_repositories テーブル
                                            │
                                            └──▶ ContainerRepositoriesSerializer
                                                      │
                                                      ▼
                                                 JSON レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repositories_controller.rb | `app/controllers/groups/registry/repositories_controller.rb` | コントローラー | グループコンテナレジストリ用コントローラー |
| index.html.haml | `app/views/groups/registry/repositories/index.html.haml` | ビュー | 一覧画面テンプレート |
| container_repository.rb | `app/models/container_repository.rb` | モデル | コンテナリポジトリモデル |
| container_repositories_finder.rb | `app/finders/container_repositories_finder.rb` | Finder | リポジトリ検索ロジック |
| container_repositories_serializer.rb | `app/serializers/container_repositories_serializer.rb` | シリアライザー | JSON変換ロジック |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行164） |
