# 画面設計書 159-Harbor連携

## 概要

本ドキュメントは、GitLabのグループHarbor連携画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループに連携されたHarborレジストリのリポジトリ一覧を表示します。Harborは企業向けのオープンソースコンテナレジストリで、GitLabと連携することで外部のHarborレジストリにあるコンテナイメージをGitLab上で管理・閲覧できます。

**業務上の目的・背景**：多くの組織では、既存のHarborレジストリを使用してコンテナイメージを管理しています。GitLabとHarborの連携により、GitLabのインターフェースから直接Harborのイメージを参照でき、CI/CDパイプラインとの統合が容易になります。

**画面へのアクセス方法**：グループのサイドバーから「パッケージとレジストリ」>「Harbor Registry」を選択することでアクセスできます。Harborインテグレーションが有効なグループでのみ表示されます。

**主要な操作・処理内容**：
1. Harborリポジトリの一覧を表示する
2. リポジトリ内のアーティファクト・タグを確認する
3. イメージの詳細情報を確認する

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。リポジトリをクリックするとアーティファクト一覧、さらにタグ一覧へと遷移できます。

**権限による表示制御**：グループの閲覧権限とHarborインテグレーションの有効化が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | コンテナレジストリ | 主機能 | グループHarbor連携の表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/harbor/repositories`
- HTTPメソッド: GET
- コントローラー: `Groups::Harbor::RepositoriesController#index`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| なし | - | - | - | 一覧表示のみ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Harbor Registry」と表示 |
| リポジトリ一覧 | Harborリポジトリのリスト |
| リポジトリ名 | リポジトリのパス |
| HarborプロジェクトURL | 連携先のHarborプロジェクト名 |
| 接続状態 | Harborへの接続状態 |
| Vueアプリケーション | `#js-harbor-registry-list-group`にマウントされるSPA |

## イベント仕様

### 1-リポジトリクリック

リポジトリをクリックすると、リポジトリ内のアーティファクト一覧画面に遷移します。

### 2-アーティファクトクリック

アーティファクトをクリックすると、タグ一覧画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | integrations | SELECT | Harbor連携設定の取得 |

### テーブル別更新項目詳細

この画面はHarbor APIからデータを取得するため、データベースの直接更新はありません。

#### integrations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, properties | WHERE type = 'Integrations::Harbor' | 連携設定取得 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 情報 | "No Harbor repositories to display" | リポジトリが存在しない場合 |
| M002 | エラー | "Unable to connect to Harbor" | 接続エラー時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Harborインテグレーションが未設定 | 404エラーまたは機能無効表示 |
| Harbor接続エラー | エラー状態をフラグで通知 |
| 無効なパスエラー | エラー状態をフラグで通知 |

## 備考

- Harborインテグレーションが有効なグループでのみ表示される
- HarborのAPIを通じてリポジトリ情報を取得
- `::Harbor::Repository`モジュールをinclude
- グループレベルとプロジェクトレベルで同様の機能を提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Harborインテグレーションの設定を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | harbor.rb | `app/models/integrations/harbor.rb` | Harborインテグレーションモデルを理解する |

**読解のコツ**: Harborインテグレーションは`hostname`と`project_name`を持ち、外部のHarborサービスとの接続情報を保持する。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repositories_controller.rb | `app/controllers/groups/harbor/repositories_controller.rb` | コントローラーの実装を理解する |
| 2-2 | application_controller.rb | `app/controllers/groups/harbor/application_controller.rb` | 共通の親コントローラーを理解する |

**主要処理フロー**:
1. **行6**: `::Harbor::Repository`モジュールをinclude
2. **行10-12**: `container`メソッドでグループを返す

#### Step 3: 共通モジュールを理解する

Harbor関連の共通ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | repository.rb | `app/controllers/concerns/harbor/repository.rb` | 共通のリポジトリ処理を理解する |

#### Step 4: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.html.haml | `app/views/groups/harbor/repositories/index.html.haml` | 一覧画面テンプレートを理解する |

**主要処理フロー**:
- **行1**: ページタイトル「Harbor Registry」を設定
- **行3-11**: Vue.jsアプリケーションのマウントポイントとデータ設定

### プログラム呼び出し階層図

```
Groups::Harbor::RepositoriesController#index
    │
    ├─ inherit Groups::Harbor::ApplicationController
    │      └─ Harborインテグレーション関連の共通処理
    │
    ├─ include ::Harbor::Repository (行6)
    │      └─ 共通のリポジトリ処理
    │
    ├─ container メソッド (行10-12)
    │      └─ @group を返す
    │
    └─ render (index.html.haml)
           │
           ├─ endpoint: group_harbor_repositories_path
           │
           ├─ repository_url: harbor_integration.hostname
           │
           ├─ harbor_integration_project_name
           │
           ├─ full_path: @group.full_path
           │
           ├─ connection_error フラグ
           │
           ├─ invalid_path_error フラグ
           │
           └─ #js-harbor-registry-list-group
                  └─ Vue.jsアプリケーション
                         └─ Harbor API呼び出し
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::Harbor::RepositoriesController
(group_id)                 │
        ─────────▶   インテグレーションチェック
                           │
                           ├──▶ harbor_integration 取得
                           │         │
                           │         ▼
                           │     integrations テーブル
                           │
                           └──▶ render index.html.haml
                                     │
                                     ├──▶ harbor_integration.hostname
                                     ├──▶ harbor_integration.project_name
                                     │
                                     └──▶ Vue.js SPA
                                              │
                                              └──▶ Harbor API
                                                      │
                                                      ▼
                                               リポジトリ一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repositories_controller.rb | `app/controllers/groups/harbor/repositories_controller.rb` | コントローラー | グループHarborリポジトリ用コントローラー |
| application_controller.rb | `app/controllers/groups/harbor/application_controller.rb` | コントローラー | Harbor共通コントローラー |
| repository.rb | `app/controllers/concerns/harbor/repository.rb` | Concern | Harbor共通ロジック |
| index.html.haml | `app/views/groups/harbor/repositories/index.html.haml` | ビュー | 一覧画面テンプレート |
| harbor.rb | `app/models/integrations/harbor.rb` | モデル | Harborインテグレーションモデル |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行167-173） |
