# 画面設計書 16-マイルストーン一覧

## 概要

本ドキュメントは、GitLabダッシュボードのマイルストーン一覧画面（Dashboard Milestones Index）の画面設計を定義したものである。

### 本画面の処理概要

ログインユーザーが関連するマイルストーンの一覧を横断的に表示し、プロジェクト管理を支援するダッシュボード画面である。

**業務上の目的・背景**：マイルストーンは、プロジェクトやグループの進捗管理において重要な機能である。本画面は、ユーザーが参加する複数のプロジェクト・グループにまたがるマイルストーンを一元的に確認できる。リリース計画やスプリント管理において、期限と進捗状況を把握するために利用される。

**画面へのアクセス方法**：ログイン後、サイドバーまたはナビゲーションから「Milestones」メニューを選択。直接URLアクセスの場合は `/dashboard/milestones` へアクセスする。

**主要な操作・処理内容**：
1. マイルストーン一覧の表示（ページネーション対応）
2. 状態によるフィルタリング（Active、Closed）
3. タイトル検索
4. 各マイルストーンの詳細画面への遷移
5. 新規マイルストーン作成画面への遷移

**画面遷移**：
- 遷移元：ログイン画面、サイドバー、ナビゲーション
- 遷移先：マイルストーン詳細画面、マイルストーン新規作成画面

**権限による表示制御**：ログインユーザーのみアクセス可能。表示されるマイルストーンはユーザーがアクセス権限を持つプロジェクト・グループのマイルストーンに限定される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | マイルストーン管理 | 主機能 | 関連マイルストーンの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

| URL | HTTPメソッド | 説明 |
|-----|-------------|------|
| `/dashboard/milestones` | GET | マイルストーン一覧（HTML） |
| `/dashboard/milestones.json` | GET | マイルストーン一覧（JSON API） |

## 入出力項目

### 入力項目（検索・フィルタ）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| state | string | No | 状態（active, closed） |
| search_title | string | No | タイトル検索 |
| page | integer | No | ページ番号 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| @milestones | Array | マイルストーン一覧 |
| @milestone_states | Hash | 状態別カウント |

## 表示項目

### マイルストーン一覧

| 項目名 | 説明 | 備考 |
|--------|------|------|
| マイルストーン名 | マイルストーンのタイトル | リンク |
| 所属 | プロジェクトまたはグループ名 | リンク |
| 期間 | 開始日〜終了日 | |
| 進捗 | 完了Issue数/総Issue数 | プログレスバー |
| 状態 | Active/Closed | バッジ表示 |
| Due date | 期限日 | 期限切れの場合は強調 |

## イベント仕様

### 1-マイルストーンリストの読み込み

ページ読み込み時にMilestonesFinderを使用してマイルストーン一覧を取得する。

**処理フロー**：
1. projectsとgroupsの取得（before_action）
2. MilestonesFinderによるマイルストーン検索
3. ページネーション処理
4. テンプレートレンダリング

### 2-状態フィルタの変更

状態タブ（All、Active、Closed）をクリックすると、該当状態のマイルストーンが表示される。

### 3-タイトル検索

検索フォームにタイトルを入力して検索すると、マッチするマイルストーンが表示される。

### 4-新規マイルストーン作成

「New milestone」ボタンをクリックすると、プロジェクト選択ドロップダウンが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | milestones | SELECT | フィルタ条件に合致するマイルストーンを取得 |
| ページ表示 | projects | SELECT | ユーザーのプロジェクト取得 |
| ページ表示 | namespaces | SELECT | ユーザーのグループ取得 |

### テーブル別更新項目詳細

#### milestones

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, state, start_date, due_date, project_id, group_id | MilestonesFinder経由 | for_projects_and_groups |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 情報 | "No milestones to show" | マイルストーンが存在しない場合 |
| MSG-002 | 情報 | "No matching milestones" | 検索結果が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|----------|----------|---------------|
| 未ログイン | ログイン画面へリダイレクト | - |

## 備考

- サーバーサイドレンダリングによる従来型のRails実装
- HTML/JSON両形式のレスポンスをサポート
- PageHeadingComponentによる統一されたページヘッダー
- Milestone.states_countで状態別カウントを取得
- 空状態の場合は専用のempty_statesパーシャルを表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、マイルストーンのデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | milestone.rb | `app/models/milestone.rb` | Milestoneモデルの定義、state_machine |
| 1-2 | milestones_finder.rb | `app/finders/milestones_finder.rb` | マイルストーン検索ロジック |

**読解のコツ**: MilestoneはTimebox、Milestoneishモジュールを含む。state_machineによる状態遷移（active/closed）に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | milestones_controller.rb | `app/controllers/dashboard/milestones_controller.rb` | indexアクション、before_action |

**主要処理フロー**:
1. **Line 4**: `before_action :projects`でプロジェクト取得
2. **Line 5**: `before_action :groups`でグループ取得
3. **Line 10-19**: indexアクションでHTML/JSON形式を分岐
4. **Line 13**: `@milestone_states`で状態別カウントを取得
5. **Line 14**: `milestones`メソッドでMilestonesFinder実行

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/dashboard/milestones/index.html.haml` | HAMLテンプレート |

**主要処理フロー**:
- **Line 6-9**: PageHeadingComponentとアクションボタン
- **Line 11-14**: 状態カウントがある場合のフィルタ・検索UI
- **Line 16-26**: マイルストーン一覧またはempty_states表示

#### Step 4: Finderを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | milestones_finder.rb | `app/finders/milestones_finder.rb` | for_projects_and_groups、状態フィルタ |

### プログラム呼び出し階層図

```
Dashboard::MilestonesController#index
    |
    +-- projects (before_action)
    |
    +-- groups (before_action)
    |
    +-- Milestone.states_count(@projects, groups)
    |
    +-- milestones (private method)
    |       |
    |       +-- MilestonesFinder.new(search_params).execute
    |
    +-- render 'dashboard/milestones/index' (HTML)
    |       |
    |       +-- PageHeadingComponent
    |       |
    |       +-- 'shared/milestones_filter'
    |       |
    |       +-- 'shared/milestones/search_form'
    |       |
    |       +-- '_milestone' partial (each)
    |
    +-- render json (JSON)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ Dashboard::MilestonesController ───▶ HTML/JSONレスポンス
(state,                  |
 search_title)           |
                         v
                  MilestonesFinder
                         |
                         v
                  Milestone (Model)
                         |
                         v
                  PostgreSQL
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| milestones_controller.rb | `app/controllers/dashboard/milestones_controller.rb` | コントローラ | リクエスト処理 |
| index.html.haml | `app/views/dashboard/milestones/index.html.haml` | ビュー | 画面テンプレート |
| _milestone.html.haml | `app/views/dashboard/milestones/_milestone.html.haml` | パーシャル | マイルストーン行 |
| milestones_finder.rb | `app/finders/milestones_finder.rb` | ファインダー | マイルストーン検索 |
| milestone.rb | `app/models/milestone.rb` | モデル | マイルストーンデータ定義 |
| dashboard.rb | `config/routes/dashboard.rb` | ルート | URL定義 |
