# 画面設計書 160-Dependency Proxy

## 概要

本ドキュメントは、GitLabのグループDependency Proxy画面の設計仕様を定義するものです。

### 本画面の処理概要

この画面では、グループレベルで管理されるDependency Proxyの設定と状態を表示します。Dependency Proxyは、外部のDockerイメージレジストリ（主にDocker Hub）からのイメージプルをキャッシュ・プロキシする機能で、ビルド時間の短縮やレート制限の回避に役立ちます。

**業務上の目的・背景**：Docker Hubなどの外部レジストリにはプル回数のレート制限があります。Dependency Proxyを使用することで、頻繁に使用するイメージをグループレベルでキャッシュし、CI/CDパイプラインの安定性を向上させることができます。また、ネットワーク帯域の削減にも寄与します。

**画面へのアクセス方法**：グループのサイドバーから「パッケージとレジストリ」>「Dependency Proxy」を選択することでアクセスできます。Dependency Proxyが有効なグループでのみ表示されます。

**主要な操作・処理内容**：
1. キャッシュされたマニフェスト一覧を表示する
2. キャッシュをクリアする（権限がある場合）
3. 設定画面に遷移する

**画面遷移**：グループ詳細画面やサイドバーから遷移してきます。設定リンクからパッケージ設定画面に遷移できます。

**権限による表示制御**：グループの閲覧権限を持つユーザーがこの画面にアクセスできます。キャッシュのクリアには`admin_group`権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | Dependency Proxy設定の表示 |

## 画面種別

設定・一覧

## URL/ルーティング

- パス: `/groups/:group_id/-/dependency_proxy`
- HTTPメソッド: GET
- コントローラー: `Groups::DependencyProxiesController#show`

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| なし | - | - | - | 表示のみ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ページタイトル | 「Dependency Proxy」と表示 |
| マニフェスト一覧 | キャッシュされたイメージマニフェストのリスト |
| グループパス | Dependency Proxyで使用するグループパス |
| 設定リンク | パッケージ設定画面へのリンク |
| キャッシュクリアボタン | キャッシュをクリアするボタン（権限がある場合） |
| Vueアプリケーション | `#js-dependency-proxy`にマウントされるSPA |

## イベント仕様

### 1-キャッシュクリア

「Clear cache」ボタンをクリックすると、Dependency Proxyのキャッシュがクリアされます。`admin_group`権限が必要です。

### 2-設定画面遷移

設定リンクをクリックすると、グループのパッケージ設定画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | dependency_proxy_manifests | SELECT | キャッシュマニフェスト一覧の取得 |
| キャッシュクリア | dependency_proxy_manifests, dependency_proxy_blobs | DELETE | キャッシュの削除 |

### テーブル別更新項目詳細

#### dependency_proxy_manifests

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, file_name, digest, created_at | WHERE group_id = :group_id | マニフェスト一覧取得 |
| DELETE | - | WHERE group_id = :group_id | キャッシュクリア時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|---------------|---------|
| M001 | 情報 | "No cached images to display" | キャッシュが存在しない場合 |
| M002 | 成功 | "Cache cleared successfully" | キャッシュクリア成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| Dependency Proxyが無効 | 404エラーページを表示 |
| グループが見つからない | 404エラーページを表示 |
| キャッシュクリア権限なし | 403エラー |

## 備考

- Dependency Proxy機能は`dependency_proxy_setting.enabled?`で有効/無効を判定
- 設定が存在しない場合は自動作成される
- `DependencyProxy::GroupAccess`モジュールをinclude
- グループID、設定パス、キャッシュクリア権限がVueアプリに渡される
- 画面はVue.jsによるSPAとして実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Dependency Proxyの設定とマニフェストのデータモデルを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | setting.rb | `app/models/dependency_proxy/group_setting.rb` | Dependency Proxy設定モデルを理解する |
| 1-2 | manifest.rb | `app/models/dependency_proxy/manifest.rb` | マニフェストモデルを理解する |

**読解のコツ**: Dependency Proxyはグループレベルの設定であり、`enabled`フラグで有効/無効を制御する。

#### Step 2: エントリーポイントを理解する

コントローラーでのリクエスト処理フローを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dependency_proxies_controller.rb | `app/controllers/groups/dependency_proxies_controller.rb` | showアクションを理解する |

**主要処理フロー**:
1. **行5**: `::DependencyProxy::GroupAccess`モジュールをinclude
2. **行7**: `verify_dependency_proxy_enabled!`でチェック
3. **行14-16**: `dependency_proxy`メソッドで設定を取得（なければ作成）
4. **行18-20**: `verify_dependency_proxy_enabled!`の実装

#### Step 3: ビューテンプレートを理解する

画面のレンダリング構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/groups/dependency_proxies/show.html.haml` | 表示画面テンプレートを理解する |

**主要処理フロー**:
- **行1**: ページタイトル「Dependency Proxy」を設定
- **行3-8**: Vue.jsアプリケーションのマウントポイントとデータ設定

#### Step 4: ルーティングを理解する

URLパスの設定を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | group.rb | `config/routes/group.rb` | ルーティング定義を理解する |

### プログラム呼び出し階層図

```
Groups::DependencyProxiesController#show
    │
    ├─ include ::DependencyProxy::GroupAccess (行5)
    │      └─ グループアクセス関連の共通処理
    │
    ├─ before_action :verify_dependency_proxy_enabled! (行7)
    │      │
    │      ├─ dependency_proxy メソッド (行14-16)
    │      │      ├─ group.dependency_proxy_setting
    │      │      └─ group.create_dependency_proxy_setting! (存在しない場合)
    │      │
    │      └─ dependency_proxy.enabled? (行19)
    │
    └─ render (show.html.haml)
           │
           ├─ group_path: @group.full_path
           │
           ├─ endpoint: group_dependency_proxy_path
           │
           ├─ no_manifests_illustration
           │
           ├─ group_id: @group.id
           │
           ├─ settings_path: group_settings_packages_and_registries_path
           │
           ├─ can_clear_cache: can?(current_user, :admin_group, @group)
           │
           └─ #js-dependency-proxy
                  └─ Vue.jsアプリケーション
```

### データフロー図

```
[入力]                    [処理]                              [出力]

URLパラメータ        Groups::DependencyProxiesController
(group_id)                 │
        ─────────▶   verify_dependency_proxy_enabled!
                           │
                           ├──▶ dependency_proxy 取得/作成
                           │         │
                           │         ▼
                           │     dependency_proxy_group_settings テーブル
                           │
                           └──▶ render show.html.haml
                                     │
                                     ├──▶ group_path
                                     ├──▶ settings_path
                                     ├──▶ can_clear_cache
                                     │
                                     └──▶ Vue.js SPA
                                              │
                                              ├──▶ REST API
                                              │         │
                                              │         ▼
                                              │     dependency_proxy_manifests テーブル
                                              │
                                              └──▶ マニフェスト一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dependency_proxies_controller.rb | `app/controllers/groups/dependency_proxies_controller.rb` | コントローラー | グループDependency Proxy用コントローラー |
| show.html.haml | `app/views/groups/dependency_proxies/show.html.haml` | ビュー | 表示画面テンプレート |
| group_setting.rb | `app/models/dependency_proxy/group_setting.rb` | モデル | Dependency Proxy設定モデル |
| manifest.rb | `app/models/dependency_proxy/manifest.rb` | モデル | マニフェストモデル |
| group_access.rb | `app/controllers/concerns/dependency_proxy/group_access.rb` | Concern | グループアクセス共通ロジック |
| group.rb | `config/routes/group.rb` | ルーティング | URLルーティング定義（行165） |
