# 画面設計書 162-Runner詳細

## 概要

本ドキュメントはGitLabのグループRunner詳細画面の設計仕様を記載したものである。

### 本画面の処理概要

グループに関連付けられた特定のCI/CD Runnerの詳細情報を表示する画面である。Runnerのステータス、設定、関連プロジェクト、実行履歴などの詳細情報を確認でき、編集画面への遷移も可能。

**業務上の目的・背景**：CI/CDパイプラインの実行状況を把握し、Runnerのトラブルシューティングや設定確認を行うために、個別Runnerの詳細情報を一元的に確認できる画面が必要である。本画面により、Runnerの健全性監視、設定確認、関連リソースの把握が可能となる。

**画面へのアクセス方法**：グループRunner一覧画面から特定Runnerをクリック、または直接URL `/{group_path}/-/runners/{runner_id}` にアクセスする。

**主要な操作・処理内容**：
1. Runnerの基本情報表示（ID、説明、ステータス、タグ等）
2. Runner設定情報の表示（ロック状態、保護モード、タイムアウト等）
3. 関連プロジェクト一覧の表示
4. Runner Managerの情報表示（バージョン、プラットフォーム等）
5. 最近実行したジョブ一覧の表示
6. 編集画面への遷移

**画面遷移**：
- 遷移元：Runner一覧画面
- 遷移先：Runner編集画面、Runner一覧画面

**権限による表示制御**：
- `read_runners`権限：詳細閲覧が可能
- `update_runner`権限：編集ボタンが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | Runnerレジストレーション | 主機能 | グループRunnerの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/{group_path}/-/runners/{runner_id}`
- コントローラー: `Groups::RunnersController#show`
- HTTPメソッド: GET

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|--------|----------|------|------|
| グループID | group_id | 入力 | Integer | 必須 | 対象グループのID |
| Runner ID | runner_id | 入力 | Integer | 必須 | 対象RunnerのID |

## 表示項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| ステータス | ci_runners.contacted_at | オンライン/オフライン等の状態 |
| Runner ID | ci_runners.id | Runner識別子 |
| 短縮SHA | ci_runners.token | トークンから生成される短縮識別子 |
| 説明 | ci_runners.description | Runnerの説明文 |
| タグ | ci_tags | 関連付けられたタグ一覧 |
| アクティブ状態 | ci_runners.active | 一時停止/実行可能状態 |
| 保護モード | ci_runners.access_level | 保護ブランチのみ実行可能か |
| ロック状態 | ci_runners.locked | 現在のプロジェクトにロックされているか |
| 最大タイムアウト | ci_runners.maximum_timeout | ジョブの最大実行時間 |
| 未タグジョブ実行 | ci_runners.run_untagged | タグなしジョブを実行するか |
| 最終接続 | ci_runners.contacted_at | 最後にRunnerが接続した時刻 |
| トークン有効期限 | ci_runners.token_expires_at | 認証トークンの有効期限 |
| 作成日時 | ci_runners.created_at | Runner作成日時 |
| IPアドレス | ci_runner_managers.ip_address | Runner ManagerのIPアドレス |
| バージョン | ci_runner_managers.version | GitLab Runnerバージョン |
| プラットフォーム | ci_runner_managers.platform | 実行プラットフォーム |
| アーキテクチャ | ci_runner_managers.architecture | CPUアーキテクチャ |

## イベント仕様

### 1-編集ボタン押下

Runner編集画面へ遷移する。

- トリガー: 「Edit」ボタンクリック
- 遷移先: `/{group_path}/-/runners/{runner_id}/edit`
- 条件: `update_runner`権限を持つ場合のみ表示

### 2-一覧へ戻るボタン押下

Runner一覧画面へ遷移する。

- トリガー: 「Back to runners」リンククリック
- 遷移先: `/{group_path}/-/runners`

### 3-関連プロジェクトリンククリック

関連プロジェクトの詳細画面へ遷移する。

- トリガー: プロジェクト名クリック
- 遷移先: `/{project_path}`

### 4-ジョブリンククリック

ジョブ詳細画面へ遷移する。

- トリガー: ジョブID/名前クリック
- 遷移先: `/{project_path}/-/jobs/{job_id}`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | ci_runners | SELECT | Runner基本情報の取得 |
| 詳細表示 | ci_runner_managers | SELECT | Runner Manager情報の取得 |
| 詳細表示 | ci_runner_namespaces | SELECT | グループ関連の確認 |
| 詳細表示 | ci_runner_projects | SELECT | 関連プロジェクトの取得 |
| 詳細表示 | ci_tags | SELECT | タグ情報の取得 |
| 詳細表示 | ci_builds | SELECT | 最近のジョブ履歴取得 |

### テーブル別更新項目詳細

#### ci_runners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全項目 | id = パラメータrunner_id | Runner基本情報 |

#### ci_runner_managers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ip_address, version, platform, architecture | runner_id = 対象Runner | Runner Manager情報 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 情報 | Runner is online | Runnerがオンライン状態 |
| MSG002 | 警告 | Runner is offline | Runnerがオフライン状態 |
| MSG003 | 警告 | Runner is stale | Runnerが7日以上未接続 |
| MSG004 | 情報 | Runner has never contacted this instance | Runnerが一度も接続していない |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 404ページを表示 |
| Runner未存在 | 404ページを表示 |
| グループ未存在 | 404ページを表示 |

## 備考

- 本画面はVue.jsコンポーネントによるSPA構成
- データ取得はGraphQL APIを使用
- Runner Managerは複数存在する場合がある（分散Runner構成）
- ステータス計算は`contacted_at`と`ONLINE_CONTACT_TIMEOUT`(2時間)に基づく

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RunnerとRunner Managerのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runner.rb | `app/models/ci/runner.rb` | Runnerモデル、ステータス計算、リレーション定義 |
| 1-2 | runner_manager.rb | `app/models/ci/runner_manager.rb` | Runner Managerモデル定義 |

**読解のコツ**: `has_many :runner_managers`（行96）でManagerとの関連、`short_sha`メソッド（行452-475）で短縮識別子生成ロジックを確認。

#### Step 2: エントリーポイントを理解する

HAMLテンプレートとコントローラーの処理起点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/groups/runners/show.html.haml` | Vueアプリケーションのマウントポイント定義 |
| 2-2 | runners_controller.rb | `app/controllers/groups/runners_controller.rb` | showアクション、runnerメソッド |

**主要処理フロー**:
1. **行26**: `show`アクションは空（Vueで表示処理）
2. **行46-54**: `runner`メソッドでCi::RunnersFinderを使用してRunner取得
3. **行8**: `#js-group-runner-show`要素にdata属性設定

#### Step 3: フロントエンド初期化を理解する

Vue.jsアプリケーションの初期化処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.js | `app/assets/javascripts/pages/groups/runners/show/index.js` | エントリーポイント |
| 3-2 | group_runner_show/index.js | `app/assets/javascripts/ci/runner/group_runner_show/index.js` | Vueアプリ初期化 |

**主要処理フロー**:
- `initGroupRunnerShow`関数でrunner_id、runners_path、edit_pathをdata属性から取得

#### Step 4: Runner検索ロジックを理解する

Runnerの検索・取得ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | runners_finder.rb | `app/finders/ci/runners_finder.rb` | Runner検索ロジック |

### プログラム呼び出し階層図

```
Groups::RunnersController#show
    │
    ├─ authorize_read_runners! (認可チェック)
    │
    ├─ runner (プライベートメソッド)
    │      └─ Ci::RunnersFinder.new
    │             └─ execute.find(params[:id])
    │
    └─ View: show.html.haml
           └─ JavaScript: initGroupRunnerShow()
                  └─ Vue: GroupRunnerShowApp
                         └─ GraphQL: getRunnerQuery
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ RunnersController#show ───▶ HAMLテンプレート
(runner_id)              │
                         ▼
                  認可チェック
                         │
                         ▼
                  RunnersFinder ───▶ Runner取得
                         │
                         ▼
                  Vue初期化 ───▶ GraphQL API ───▶ Runner詳細表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/groups/runners/show.html.haml` | テンプレート | Vueマウントポイント定義 |
| runners_controller.rb | `app/controllers/groups/runners_controller.rb` | コントローラー | リクエスト処理・認可 |
| runner.rb | `app/models/ci/runner.rb` | モデル | Runnerデータ定義 |
| runner_manager.rb | `app/models/ci/runner_manager.rb` | モデル | Runner Manager定義 |
| runners_finder.rb | `app/finders/ci/runners_finder.rb` | Finder | Runner検索ロジック |
| index.js | `app/assets/javascripts/ci/runner/group_runner_show/index.js` | JavaScript | Vue初期化 |
| runners_helper.rb | `app/helpers/ci/runners_helper.rb` | ヘルパー | 表示ヘルパー関数 |
