# 画面設計書 170-インポート履歴

## 概要

本ドキュメントはGitLabのグループインポート履歴画面の設計仕様を記載したものである。

### 本画面の処理概要

グループに対して実行されたインポート操作の履歴を表示する画面である。各インポートのソース、宛先、開始日時、ステータス、統計情報を確認できる。

**業務上の目的・背景**：グループのバルクインポート操作を追跡し、過去のインポート結果を確認する必要がある。本画面により、インポートの成功・失敗状況、インポートされたアイテム数、エラー詳細などを確認でき、インポート操作の履歴管理と問題解決を支援する。

**画面へのアクセス方法**：グループ設定画面からアクセス可能。または直接URL `/{group_path}/-/import_history` にアクセスする。

**主要な操作・処理内容**：
1. インポート履歴一覧の表示
2. 各インポートの詳細情報展開
3. インポート統計情報の確認
4. エラー詳細の確認

**画面遷移**：
- 遷移元：グループ設定画面
- 遷移先：特になし（情報表示画面）

**権限による表示制御**：
- `admin_group`権限が必要（グループ管理者のみアクセス可能）
- Feature Flag `group_import_history_visibility` が有効である必要がある

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 110 | バルクインポート | 主機能 | グループインポート履歴の表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/{group_path}/-/import_history`
- コントローラー: `Groups::ImportHistoriesController#show`
- HTTPメソッド: GET

## 入出力項目

| 項目名 | 項目ID | 入出力 | データ型 | 必須 | 説明 |
|--------|--------|--------|----------|------|------|
| グループパス | group_path | 入力 | String | 必須 | 対象グループのパス |

## 表示項目

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| ページタイトル | 固定値 | "Import history" |
| グループ名 | groups.name | 対象グループ名 |
| ソース名 | bulk_imports（API経由） | インポート元情報 |
| 宛先 | bulk_imports（API経由） | インポート先情報 |
| 開始日時 | bulk_imports.created_at（API経由） | インポート開始日時 |
| ステータス | bulk_imports.status（API経由） | created/started/finished/timeout/failed/canceled |
| 統計情報 | bulk_imports.stats（API経由） | インポート済み/取得済み件数 |
| エラー情報 | bulk_imports.failures（API経由） | エラー詳細 |

## イベント仕様

### 1-ページ読み込み時

インポート履歴一覧を表示する。

- トリガー: ページアクセス
- 処理: APIからインポート履歴データを取得して表示
- 条件:
  - `admin_group`権限を持つ場合のみアクセス可能
  - Feature Flag `group_import_history_visibility` が有効

### 2-行展開ボタンクリック

インポートの詳細情報（統計・エラー）を展開表示する。

- トリガー: テーブル行の展開ボタンクリック
- 処理: 統計情報またはエラー詳細を表示
- 表示内容: stats（統計情報）またはfailures（エラー情報）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 履歴表示 | bulk_imports | SELECT | インポート履歴の取得 |
| 履歴表示 | bulk_import_entities | SELECT | インポートエンティティ情報の取得 |

### テーブル別更新項目詳細

#### bulk_imports

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | グループ関連 | インポートID |
| SELECT | status | グループ関連 | 0:created, 1:started, 2:finished, 3:timeout, -1:failed, -2:canceled |
| SELECT | source_type | グループ関連 | 0:gitlab |
| SELECT | created_at | グループ関連 | インポート開始日時 |
| SELECT | updated_at | グループ関連 | 最終更新日時 |
| SELECT | has_failures | グループ関連 | エラー有無フラグ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 情報 | Import history | ページタイトル |
| MSG002 | 情報 | %{groupName} import history | ページヘッダー |
| MSG003 | ヘッダー | Source name | テーブルヘッダー |
| MSG004 | ヘッダー | Destination | テーブルヘッダー |
| MSG005 | ヘッダー | Start date | テーブルヘッダー |
| MSG006 | ヘッダー | Status | テーブルヘッダー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| グループ未存在 | 404ページを表示 |
| 権限不足（admin_group） | 404ページを表示 |
| Feature Flag無効 | 404ページを表示 |

## 備考

- 本画面はVue.jsコンポーネントによるspa構成
- Feature Flag `group_import_history_visibility` が有効な場合のみ表示可能
- インポート状態はstate_machineで管理（created → started → finished/timeout/failed/canceled）
- BulkImport APIからデータを取得して表示
- 統計情報（stats）とエラー情報（failures）は行展開で詳細表示
- ネストされた行表示にも対応（親子インポート）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バルクインポートのデータモデルとステートマシンを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bulk_import.rb | `app/models/bulk_import.rb` | ステートマシン定義、状態遷移 |

**読解のコツ**:
- `state_machine :status, initial: :created`（行28）でステートマシン開始
- `state`定義（行29-34）で状態値を確認: created(0), started(1), finished(2), timeout(3), failed(-1), canceled(-2)
- `has_failures`フラグ（行57-58）でエラー有無を追跡

#### Step 2: エントリーポイントを理解する

コントローラーの権限チェックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | import_histories_controller.rb | `app/controllers/groups/import_histories_controller.rb` | 権限チェック、Feature Flag |

**主要処理フロー**:
1. **行8**: `authorize_admin_group!`でグループ管理者権限チェック
2. **行10-12**: `Feature.enabled?(:group_import_history_visibility, @group)`でFeature Flag確認

#### Step 3: フロントエンド実装を理解する

Vueコンポーネントの構成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.js | `app/assets/javascripts/groups/import_history/index.js` | Vue初期化 |
| 3-2 | import_history.vue | `app/assets/javascripts/groups/import_history/import_history.vue` | メインコンポーネント |
| 3-3 | import_history_table.vue | `app/assets/javascripts/vue_shared/components/import/import_history_table.vue` | テーブルコンポーネント |

**主要処理フロー**:
- `#js-group-import-history`（行5）でVueマウント
- `groupName`をpropsで受け取り（行9）
- `ImportHistoryTable`コンポーネントで一覧表示
- 行展開で統計・エラー詳細表示

### プログラム呼び出し階層図

```
Groups::ImportHistoriesController#show
    │
    ├─ authorize_admin_group! (管理者権限チェック)
    │
    ├─ Feature.enabled?(:group_import_history_visibility) (Feature Flag)
    │
    └─ View: show.html.haml
           │
           └─ Vue: GroupImportHistory
                  │
                  └─ Component: PageHeading
                         │
                         └─ Component: ImportHistoryTable
                                │
                                ├─ ImportHistoryTableHeader
                                ├─ ImportHistoryTableRow
                                ├─ ImportHistoryTableSource
                                ├─ ImportHistoryTableRowDestination
                                ├─ ImportHistoryTableRowStats
                                ├─ ImportHistoryTableRowErrors
                                └─ ImportHistoryStatusBadge
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLリクエスト ───▶ ImportHistoriesController ───▶ 権限チェック
                         │
                         ▼
               Feature Flag確認
                         │
                         ▼
               HAMLテンプレート
                         │
                         ▼
               Vue初期化 ───▶ BulkImport API ───▶ 履歴一覧表示
                                                       │
                                                       ▼
行展開クリック ───────────────────────────────▶ 詳細表示
                                                (統計/エラー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/groups/import_histories/show.html.haml` | テンプレート | Vueマウントポイント |
| import_histories_controller.rb | `app/controllers/groups/import_histories_controller.rb` | コントローラー | 権限・Feature Flag |
| index.js | `app/assets/javascripts/groups/import_history/index.js` | JS | Vue初期化 |
| import_history.vue | `app/assets/javascripts/groups/import_history/import_history.vue` | Vue | メインコンポーネント |
| import_history_table.vue | `app/assets/javascripts/vue_shared/components/import/import_history_table.vue` | Vue | テーブルコンポーネント |
| bulk_import.rb | `app/models/bulk_import.rb` | モデル | バルクインポートデータ |
