# 画面設計書 171-Observability

## 概要

本ドキュメントは、GitLabグループレベルのObservability（オブザーバビリティ）画面の設計書です。グループ配下のアプリケーションやサービスの監視・可観測性機能を統合的に提供する画面を定義します。

### 本画面の処理概要

本画面では、GitLab Observabilityプラットフォームの概要表示、機能有効化、および監視データの可視化を行います。

**業務上の目的・背景**：GitLab Observabilityは、OpenTelemetryネイティブな可観測性プラットフォームとして、ログ、メトリクス、トレースを統合管理することを目的としています。マイクロサービスアーキテクチャでの分散トレーシング、APMダッシュボード、集中ログ管理、インテリジェントアラートなど、エンタープライズグレードの監視機能をGitLab内で提供し、DevOpsワークフローとの統合を実現します。

**画面へのアクセス方法**：グループのサイドメニューから「運用」→「Observability」を選択してアクセスします。アクセスには`read_observability_portal`権限が必要です。

**主要な操作・処理内容**：
1. Observabilityサービスの有効化リクエスト
2. Observability設定状態の確認
3. ダッシュボード（トレース、メトリクス、ログ）の表示
4. サービス初期化状態のモニタリング

**画面遷移**：
- 遷移元：グループメニュー、グループ詳細画面
- 遷移先：Observabilityセットアップ画面、各種Observabilityダッシュボード

**権限による表示制御**：`read_observability_portal`権限を持つユーザーのみアクセス可能。また、`observability_sass_features`フィーチャーフラグが有効である必要があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 132 | エラートラッキング | 主機能 | Observability画面の表示 |

## 画面種別

詳細 / ダッシュボード

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/observability/:id` | GET | show |

## 入出力項目

本画面は主に表示専用画面ですが、以下の入力操作があります。

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| Observability有効化ボタン | ボタン | - | Observabilityサービスを有効化するためのボタン |

## 表示項目

### 未設定状態の表示

| 項目名 | 説明 |
|--------|------|
| タイトル | "Enterprise-grade observability for GitLab" |
| 説明文 | GitLab Observabilityの概要説明 |
| 機能カード（APM & performance） | アプリケーションパフォーマンス監視機能の説明 |
| 機能カード（Distributed tracing） | 分散トレーシング機能の説明 |
| 機能カード（Centralized logs） | 集中ログ管理機能の説明 |
| 機能カード（Smart alerts） | スマートアラート機能の説明 |
| 機能カード（Exception tracking） | 例外トラッキング機能の説明 |
| 機能カード（Kubernetes monitoring） | Kubernetes監視機能の説明 |
| 特徴一覧 | OpenTelemetry native, ClickHouse performance, Unified platform, Enterprise ready |
| スクリーンショット | Observabilityダッシュボードのプレビュー画像 |
| 重要情報 | ベータリリース、無料、プロビジョニング時間の情報 |
| ドキュメントリンク | ヘルプページへのリンク |

### プロビジョニング中の表示

| 項目名 | 説明 |
|--------|------|
| 初期化中アラート | サービス初期化中であることを通知 |
| エンドポイント設定 | Observabilityサービスのエンドポイント設定情報 |

### 認証エラー時の表示

| 項目名 | 説明 |
|--------|------|
| エラーアラート | 認証失敗の旨を表示 |

### 有効化後の表示

| 項目名 | 説明 |
|--------|------|
| Observabilityダッシュボード | JavaScriptで描画されるObservabilityUI |

## イベント仕様

### 1-Observability有効化ボタン押下

**トリガー**：「Enable Observability」ボタンクリック

**処理フロー**：
1. `group_observability_access_requests_path`へPOSTリクエストを送信
2. Observabilityサービスのプロビジョニングを開始
3. プロビジョニング状態に遷移し、初期化中メッセージを表示

**遷移先**：同画面（プロビジョニング状態）

### 2-ダッシュボード表示

**トリガー**：Observabilityサービス有効化完了後のページ読み込み

**処理フロー**：
1. `@data`からObservability設定を取得
2. JavaScriptアプリケーション（`#js-observability`）にデータを渡して描画

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Observability有効化 | observability_group_o11y_settings | INSERT | グループのObservability設定を作成 |

### テーブル別更新項目詳細

#### observability_group_o11y_settings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | group_id | 対象グループID | グループとの関連付け |
| INSERT | provisioning | true | プロビジョニング状態フラグ |
| INSERT | o11y_service_url | サービスURL | Observabilityサービスのエンドポイント |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| エラー | "Unable to authenticate with the observability service. Please check your configuration and try again." | 認証トークンがない場合 |
| 情報 | "The observability service is initializing. Please try again in a few minutes." | プロビジョニング中 |

## 例外処理

| 例外 | 処理 |
|------|------|
| フィーチャーフラグ無効 | 404エラーページを表示 |
| 権限不足 | 404エラーページを表示 |
| 無効なパス | 404エラーページを表示 |
| 認証トークン取得失敗 | エラーアラートを画面内に表示 |

## 備考

- Observability機能はベータ版として提供されており、ベータ期間中は無料で利用可能
- バックエンドにClickHouseを使用し、高性能なクエリとデータ圧縮を実現
- OpenTelemetryネイティブで、業界標準との統合が容易
- Content Security Policyで、ObservabilityサービスURLをframe-srcに追加

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Observability機能で扱うデータ構造を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | observability_presenter.rb | `app/presenters/observability/observability_presenter.rb` | Observabilityデータの構造とPATHSの定義 |
| 1-2 | observability_group_o11y_setting.rb | `app/models/observability/group_o11y_setting.rb` | 設定モデルの構造 |

**読解のコツ**: `ObservabilityPresenter`クラスでは、VALID_PATHSとして許可されるパス一覧が定義されており、これが画面表示の切り替えに使用されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | observability_controller.rb | `app/controllers/groups/observability_controller.rb` | showアクションの処理フロー |

**主要処理フロー**:
1. **行5-6**: before_actionで認証とObservability権限チェック
2. **行22-31**: showアクションでパス検証とプレゼンター生成
3. **行40-43**: authorize_read_observability!でフィーチャーフラグと権限確認

#### Step 3: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/groups/observability/show.html.haml` | 条件分岐による表示切り替え |

**主要処理フロー**:
- **行6-7**: 認証トークン未取得時のエラー表示
- **行8-10**: プロビジョニング中の表示
- **行12**: 有効化後のJSアプリケーション描画

### プログラム呼び出し階層図

```
groups/observability_controller.rb#show
    │
    ├─ authorize_read_observability!
    │      ├─ Feature.enabled?(:observability_sass_features, group)
    │      └─ Ability.allowed?(current_user, :read_observability_portal, group)
    │
    └─ Observability::ObservabilityPresenter.new(group, path)
           └─ to_h (データをハッシュ化してビューに渡す)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ ObservabilityController ───────▶ show.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               ObservabilityPresenter           条件に応じた表示
    │                        │                        ├─ エラーアラート
    │                        ▼                        ├─ プロビジョニング中
    └─────────────▶ Group.observability_setting       └─ JSダッシュボード
                                                           (#js-observability)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| observability_controller.rb | `app/controllers/groups/observability_controller.rb` | コントローラー | リクエスト処理・認可制御 |
| show.html.haml | `app/views/groups/observability/show.html.haml` | ビュー | 画面描画 |
| observability_presenter.rb | `app/presenters/observability/observability_presenter.rb` | プレゼンター | データ整形 |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行197-202） |
| observability.scss | `app/assets/stylesheets/page_bundles/observability.scss` | スタイル | 画面固有スタイル |
