# 画面設計書 172-Observabilityセットアップ

## 概要

本ドキュメントは、GitLabグループレベルのObservability（オブザーバビリティ）セットアップ画面の設計書です。Observabilityサービスの初期設定と有効化を行うための画面を定義します。

### 本画面の処理概要

本画面では、GitLab Observabilityプラットフォームの有効化手順の案内、サービスの初期設定、およびプロビジョニング状態の確認を行います。

**業務上の目的・背景**：GitLab Observabilityは、OpenTelemetryネイティブな可観測性プラットフォームとして、ログ、メトリクス、トレースを統合管理します。本セットアップ画面は、組織がこの機能を初めて利用する際のオンボーディング体験を提供し、必要な設定を簡単に行えるようにすることを目的としています。

**画面へのアクセス方法**：グループのObservability画面から「Enable Observability」ボタンをクリック後、または直接URLでアクセスします。アクセスには適切な権限が必要です。

**主要な操作・処理内容**：
1. Observability機能の概要確認
2. 機能の特徴（APM、分散トレーシング、ログ管理など）の確認
3. Observabilityサービスの有効化リクエスト
4. エンドポイント設定の確認（プロビジョニング完了後）

**画面遷移**：
- 遷移元：Observability画面、グループメニュー
- 遷移先：Observabilityダッシュボード

**権限による表示制御**：Observability機能へのアクセス権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 132 | エラートラッキング | 主機能 | Observabilityセットアップ |

## 画面種別

設定 / セットアップウィザード

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/observability/setup` | GET | show |

## 入出力項目

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| Enable Observabilityボタン | ボタン | - | Observabilityサービスを有効化するためのボタン |

## 表示項目

### メインコンテンツ（未設定時）

| 項目名 | 説明 |
|--------|------|
| タイトル | "Enterprise-grade observability for GitLab" |
| サービス説明 | OpenTelemetryベースの統合監視プラットフォームの概要 |
| 機能紹介カード群 | 6つの主要機能を紹介するカードコンポーネント |

### 機能紹介カード

| カード名 | アイコン | 説明 |
|---------|--------|------|
| APM & performance | tachometer | アプリケーションパフォーマンス監視、p99レイテンシ追跡 |
| Distributed tracing | status-health | マイクロサービス間の分散トレーシング、フレームグラフ |
| Centralized logs | log | 集中ログ管理、高度なクエリ機能 |
| Smart alerts | status-alert | カスタムダッシュボード、異常検知アラート |
| Exception tracking | bug | 例外追跡、詳細なスタックトレース |
| Kubernetes monitoring | kubernetes | Pod レベルメトリクス、クラスタヘルス |

### 機能特徴一覧（What you get）

| 特徴 | 説明 |
|------|------|
| OpenTelemetry native | 業界標準のOpenTelemetryとのシームレスな統合 |
| ClickHouse performance | ClickHouseバックエンドによる高速クエリとデータ圧縮 |
| Unified platform | GitLab内でログ、メトリクス、トレースを一元管理 |
| Enterprise ready | エンタープライズ規模のスケーラブルなアーキテクチャ |

### デモセクション（See it in action）

| 項目 | 説明 |
|------|------|
| Performance overview画像 | パフォーマンスダッシュボードのスクリーンショット |
| Advanced analytics画像 | 高度な分析ダッシュボードのスクリーンショット |

### 重要情報（Important information）

| 項目 | 値 |
|------|-----|
| Provisioning time | Up to 5 minutes（プロビジョニング中のみ表示） |
| Beta release | Experimental functionality |
| No cost | Free during beta period |
| ドキュメントリンク | ヘルプページへのリンク |

### 設定済み状態

| 項目名 | 説明 |
|--------|------|
| エンドポイント設定 | Observabilityサービスのエンドポイント情報 |

## イベント仕様

### 1-Enable Observabilityボタン押下

**トリガー**：「Enable Observability」ボタンクリック

**処理フロー**：
1. `group_observability_access_requests_path(@group)`へPOSTリクエスト
2. Observabilityサービスのプロビジョニングを開始
3. プロビジョニング状態に遷移

**遷移先**：Observability画面（プロビジョニング状態）

### 2-ドキュメントリンククリック

**トリガー**：ヘルプページリンクをクリック

**処理フロー**：
1. 新しいタブで`help_page_path('operations/observability.md')`を開く

**遷移先**：Observabilityドキュメントページ（新規タブ）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示時 | - | SELECT | 設定状態の読み取りのみ |

### テーブル別更新項目詳細

本画面は読み取り専用のため、直接的なデータベース更新は行いません。有効化処理は`access_requests`コントローラーで実行されます。

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 説明 | "GitLab Observability is an open source, OpenTelemetry-native observability platform..." | 未設定時 |
| 情報 | "Free during beta period" | 常時 |
| 情報 | "Up to 5 minutes" | プロビジョニング中 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足 | アクセス拒否ページへリダイレクト |
| フィーチャーフラグ無効 | 404エラーページを表示 |

## 備考

- 画面はレスポンシブデザインに対応し、グリッドレイアウトがデバイスサイズに応じて変化
- 画像は遅延読み込み（lazy loading）を使用してパフォーマンスを最適化
- ベータ版機能として提供されており、機能変更の可能性あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビュー構造を理解する

まず、画面のHTML構造と表示ロジックを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | show.html.haml | `app/views/groups/observability/setup/show.html.haml` | 画面全体の構造と条件分岐 |
| 1-2 | _endpoint_configuration.html.haml | `app/views/groups/observability/setup/_endpoint_configuration.html.haml` | 設定表示パーシャル |

**読解のコツ**: HAMLテンプレートでは、インデントがHTMLのネスト構造を表します。`- if`や`- else`で条件分岐を確認してください。

#### Step 2: ルーティングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | group.rb | `config/routes/group.rb` | observability名前空間内のsetupリソース定義（行197-201） |

**主要処理フロー**:
1. **行197**: `namespace :observability do`でObservability関連ルートをグループ化
2. **行199**: `resource :setup, only: [:show]`でsetupのshowアクションを定義

#### Step 3: コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Pajamas::CardComponent | Pajamasライブラリ | カード表示コンポーネント |
| 3-2 | Pajamas::AlertComponent | Pajamasライブラリ | アラート表示コンポーネント |
| 3-3 | Pajamas::ButtonComponent | Pajamasライブラリ | ボタンコンポーネント |

**主要処理フロー**:
- **行18-30**: CardComponentで機能概要を表示
- **行33-35**: ButtonComponentで有効化ボタンを表示
- **行86-119**: AlertComponentで機能特徴一覧を表示

### プログラム呼び出し階層図

```
groups/observability/setup/show.html.haml
    │
    ├─ @group.observability_group_o11y_setting.present? (条件分岐)
    │      │
    │      ├─ [設定あり] _endpoint_configuration パーシャル
    │      │
    │      └─ [設定なし] セットアップUI
    │             │
    │             ├─ CardComponent (機能概要)
    │             ├─ ButtonComponent (有効化ボタン)
    │             │      └─ POST group_observability_access_requests_path
    │             ├─ 機能カード群 (6つ)
    │             ├─ AlertComponent (特徴一覧)
    │             ├─ CardComponent (デモセクション)
    │             └─ AlertComponent (重要情報)
    │
    └─ sprite_icon() (各種アイコン表示)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ページリクエスト ─────────▶ SetupController#show ─────────▶ show.html.haml
                               │                                │
                               ▼                                ▼
                    @group.observability_setting          条件に応じた表示
                               │                          ├─ セットアップUI
                               │                          └─ エンドポイント設定
                               │
                               ▼
                    [有効化ボタン押下時]
                               │
                               ▼
                    POST access_requests ──────────────▶ プロビジョニング開始
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| show.html.haml | `app/views/groups/observability/setup/show.html.haml` | ビュー | メイン画面描画 |
| _endpoint_configuration.html.haml | `app/views/groups/observability/setup/_endpoint_configuration.html.haml` | パーシャル | 設定表示 |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行197-201） |
| observability.scss | `app/assets/stylesheets/page_bundles/observability.scss` | スタイル | 画面固有スタイル |
| observability-dashboard-1.png | `app/assets/images/observability/` | 画像 | デモ画像1 |
| observability-dashboard-2.png | `app/assets/images/observability/` | 画像 | デモ画像2 |
