# 画面設計書 173-リポジトリ設定

## 概要

本ドキュメントは、GitLabグループレベルのリポジトリ設定画面の設計書です。グループ内のリポジトリに関する共通設定（デプロイトークン、デフォルトブランチ、保護ブランチ、プッシュルールなど）を管理する画面を定義します。

### 本画面の処理概要

本画面では、グループ配下の全プロジェクトに適用されるリポジトリ関連の設定を一元管理します。

**業務上の目的・背景**：大規模な組織では、複数のプロジェクトに対して一貫したリポジトリポリシーを適用する必要があります。本画面はグループレベルでリポジトリ設定を統一管理することで、セキュリティポリシーの一貫性確保と運用効率の向上を実現します。

**画面へのアクセス方法**：グループの設定メニューから「リポジトリ」を選択してアクセスします。アクセスには`admin_group`権限または`create_deploy_token`権限が必要です。

**主要な操作・処理内容**：
1. グループデプロイトークンの作成・管理
2. デフォルトブランチの設定（管理者権限時）
3. 保護ブランチの設定（EE機能、管理者権限時）
4. プッシュルールの設定（権限がある場合）

**画面遷移**：
- 遷移元：グループ設定メニュー、グループ詳細画面
- 遷移先：デプロイトークン詳細、グループ設定の各画面

**権限による表示制御**：
- `create_deploy_token`権限：デプロイトークンセクションを表示
- `admin_group`権限：デフォルトブランチ・保護ブランチセクションを表示
- `change_push_rules`権限：プッシュルールセクションを表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | 保護ブランチ | 主機能 | グループリポジトリ設定 |

## 画面種別

設定

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/repository` | GET | show |
| `/groups/:group_id/-/settings/repository/deploy_token/create` | POST | create_deploy_token |

## 入出力項目

### デプロイトークン作成フォーム

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| name | テキスト | 必須 | デプロイトークン名 |
| expires_at | 日付 | 任意 | 有効期限 |
| username | テキスト | 任意 | カスタムユーザー名 |
| read_repository | チェックボックス | 任意 | リポジトリ読み取り権限 |
| read_registry | チェックボックス | 任意 | レジストリ読み取り権限 |
| write_registry | チェックボックス | 任意 | レジストリ書き込み権限 |
| read_virtual_registry | チェックボックス | 任意 | 仮想レジストリ読み取り権限 |
| write_virtual_registry | チェックボックス | 任意 | 仮想レジストリ書き込み権限 |
| read_package_registry | チェックボックス | 任意 | パッケージレジストリ読み取り権限 |
| write_package_registry | チェックボックス | 任意 | パッケージレジストリ書き込み権限 |

## 表示項目

### デプロイトークンセクション（create_deploy_token権限時）

| 項目名 | 説明 |
|--------|------|
| セクション説明 | "Group deploy tokens allow access to the packages, repositories, and registry images within the group." |
| デプロイトークン一覧 | 有効なデプロイトークンのリスト |
| デプロイトークン作成フォーム | 新規トークン作成用フォーム |

### デフォルトブランチセクション（admin_group権限時）

| 項目名 | 説明 |
|--------|------|
| デフォルトブランチ設定 | グループのデフォルトブランチ名設定 |

### 保護ブランチセクション（admin_group権限時、EE）

| 項目名 | 説明 |
|--------|------|
| 保護ブランチ一覧 | グループレベルの保護ブランチ設定 |

### プッシュルールセクション（change_push_rules権限時）

| 項目名 | 説明 |
|--------|------|
| プッシュルール設定 | コミット・プッシュに関するルール設定 |

## イベント仕様

### 1-デプロイトークン作成ボタン押下

**トリガー**：デプロイトークン作成フォームの送信

**処理フロー**：
1. `create_deploy_token`アクションにPOSTリクエスト
2. `Groups::DeployTokens::CreateService`でトークン作成
3. 成功時：作成されたトークンを表示、フラッシュメッセージ表示
4. 失敗時：エラーメッセージ表示

**レスポンス形式**：
- HTML形式：画面を再描画しフラッシュメッセージを表示
- JSON形式：`API::Entities::DeployTokenWithToken`でトークン情報を返却

### 2-デプロイトークン削除

**トリガー**：デプロイトークンの削除操作

**処理フロー**：
1. 削除対象トークンを無効化
2. トークン一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| デプロイトークン作成 | deploy_tokens | INSERT | 新規デプロイトークン作成 |
| デプロイトークン作成 | deploy_tokens_groups | INSERT | グループとトークンの関連付け |
| デプロイトークン削除 | deploy_tokens | UPDATE | revoked_at を設定 |

### テーブル別更新項目詳細

#### deploy_tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | トークン名 |
| INSERT | expires_at | フォーム入力値 | 有効期限（任意） |
| INSERT | username | フォーム入力値またはデフォルト | ユーザー名 |
| INSERT | read_repository | フォーム入力値 | リポジトリ読み取り権限 |
| INSERT | read_registry | フォーム入力値 | レジストリ読み取り権限 |
| INSERT | write_registry | フォーム入力値 | レジストリ書き込み権限 |
| INSERT | read_package_registry | フォーム入力値 | パッケージ読み取り権限 |
| INSERT | write_package_registry | フォーム入力値 | パッケージ書き込み権限 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 成功 | "Your new group deploy token has been created." | デプロイトークン作成成功時 |
| エラー | エラーメッセージ（動的） | デプロイトークン作成失敗時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足（全セクション非表示） | アクセス拒否ページへリダイレクト |
| デプロイトークン作成失敗 | エラーメッセージを表示し、フォームを再表示 |

## 備考

- レイアウトは `group_settings` を使用
- `skip_cross_project_access_check` でクロスプロジェクトアクセスチェックをスキップ
- デプロイトークン作成時、トークン値は一度だけ表示される（セキュリティ上の理由）
- EE版では保護ブランチセクションが追加される（`render_if_exists`）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

まず、リクエスト処理の流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | repository_controller.rb | `app/controllers/groups/settings/repository_controller.rb` | アクション定義と権限チェック |

**読解のコツ**: `before_action`でどのような権限チェックが行われているかを確認してください。

**主要処理フロー**:
1. **行7-9**: before_actionでアクセス権限を確認
2. **行10**: デプロイトークン変数の定義
3. **行19-45**: create_deploy_tokenアクションでトークン作成処理

#### Step 2: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/groups/settings/repository/show.html.haml` | 条件分岐による表示切り替え |
| 2-2 | _index.html.haml | `app/views/shared/deploy_tokens/_index.html.haml` | デプロイトークン共通パーシャル |

**主要処理フロー**:
- **行5-7**: create_deploy_token権限時にデプロイトークンセクション表示
- **行9-10**: admin_group権限時にデフォルトブランチ・保護ブランチ表示
- **行13-14**: change_push_rules権限時にプッシュルール表示

#### Step 3: サービスレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create_service.rb | `app/services/groups/deploy_tokens/create_service.rb` | トークン作成ロジック |

### プログラム呼び出し階層図

```
groups/settings/repository_controller.rb#show
    │
    ├─ authorize_access! (before_action)
    │      └─ authorize_admin_group!
    │
    ├─ define_deploy_token_variables (before_action)
    │      ├─ @deploy_tokens = @group.deploy_tokens.active
    │      └─ @new_deploy_token = DeployToken.new
    │
    └─ show.html.haml
           ├─ [create_deploy_token権限] shared/deploy_tokens/_index
           ├─ [admin_group権限] _default_branch
           ├─ [admin_group権限] protected_branches/_protected_branches (EE)
           └─ [change_push_rules権限] _push_rules

groups/settings/repository_controller.rb#create_deploy_token
    │
    ├─ authorize_create_deploy_token! (before_action)
    │
    └─ Groups::DeployTokens::CreateService.new(@group, current_user, params).execute
           │
           ├─ [成功] @created_deploy_token を設定
           │         └─ HTML: flash[:notice] + render :show
           │         └─ JSON: API::Entities::DeployTokenWithToken
           │
           └─ [失敗] @new_deploy_token を設定
                     └─ HTML: flash[:alert] + render :show
                     └─ JSON: { message: error }
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ RepositoryController ───────────▶ show.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               権限チェック                        権限に応じたセクション表示
    │               ├─ create_deploy_token?             ├─ デプロイトークン
    │               ├─ admin_group?                     ├─ デフォルトブランチ
    │               └─ change_push_rules?               └─ プッシュルール
    │
    │
デプロイトークン ─────▶ CreateService.execute ──────────▶ トークン作成結果
フォームデータ                │                            ├─ 成功: トークン表示
                             ▼                            └─ 失敗: エラー表示
                     deploy_tokens INSERT
                     deploy_tokens_groups INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repository_controller.rb | `app/controllers/groups/settings/repository_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/groups/settings/repository/show.html.haml` | ビュー | メイン画面描画 |
| _index.html.haml | `app/views/shared/deploy_tokens/_index.html.haml` | パーシャル | デプロイトークン表示 |
| _default_branch.html.haml | `app/views/groups/settings/repository/_default_branch.html.haml` | パーシャル | デフォルトブランチ設定 |
| _push_rules.html.haml | `app/views/groups/settings/repository/_push_rules.html.haml` | パーシャル | プッシュルール設定 |
| create_service.rb | `app/services/groups/deploy_tokens/create_service.rb` | サービス | トークン作成 |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行56-58） |
| deploy_token.rb | `app/models/deploy_token.rb` | モデル | デプロイトークンモデル |
