# 画面設計書 174-CI/CD設定

## 概要

本ドキュメントは、GitLabグループレベルのCI/CD設定画面の設計書です。グループ内のすべてのプロジェクトに適用されるCI/CD関連の設定（変数、Runner、Auto DevOps、保護環境など）を管理する画面を定義します。

### 本画面の処理概要

本画面では、グループ配下の全プロジェクトに継承されるCI/CD設定を一元管理します。

**業務上の目的・背景**：企業のDevOps環境では、CI/CD設定の標準化と一貫性が重要です。本画面はグループレベルでCI/CD変数、Runnerの管理、Auto DevOpsポリシーを統一設定することで、配下のプロジェクト全体での開発効率とセキュリティの向上を実現します。

**画面へのアクセス方法**：グループの設定メニューから「CI/CD」を選択してアクセスします。`admin_cicd_variables`、`admin_protected_environments`、または`admin_runners`のいずれかの権限が必要です。

**主要な操作・処理内容**：
1. 一般パイプライン設定の更新（アーティファクトサイズ上限など）
2. グループCI/CD変数の追加・編集・削除
3. Runner設定の確認
4. Auto DevOpsの有効化・無効化
5. 保護環境の設定（EE機能）

**画面遷移**：
- 遷移元：グループ設定メニュー、グループ詳細画面
- 遷移先：Runner詳細画面、変数詳細

**権限による表示制御**：
- `update_max_artifacts_size`権限または`root_group`：一般パイプライン設定セクションを表示
- `admin_cicd_variables`権限：変数セクションを表示
- `admin_runners`権限：Runnerセクションを表示
- `admin_group`権限：Auto DevOpsセクションを表示
- `admin_protected_environments`権限：保護環境セクションを表示（EE）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | CI変数管理 | 主機能 | グループCI/CD設定 |

## 画面種別

設定

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/ci_cd` | GET | show |
| `/groups/:group_id/-/settings/ci_cd` | PUT/PATCH | update |
| `/groups/:group_id/-/settings/ci_cd/update_auto_devops` | PATCH | update_auto_devops |
| `/groups/:group_id/-/settings/ci_cd/reset_registration_token` | PUT | reset_registration_token |
| `/groups/:group_id/-/settings/ci_cd/runner_setup_scripts` | GET | runner_setup_scripts |

## 入出力項目

### 一般パイプライン設定フォーム

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| max_artifacts_size | 数値 | 任意 | ジョブアーティファクトの最大サイズ（MB） |
| allow_runner_registration_token | チェックボックス | 任意 | Runner登録トークンの許可 |
| jwt_ci_cd_job_token_enabled | チェックボックス | 任意 | JWTジョブトークンの有効化 |

### Auto DevOps設定フォーム

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| auto_devops_enabled | チェックボックス | 任意 | Auto DevOpsの有効/無効 |

## 表示項目

### 一般パイプラインセクション

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "General pipelines" |
| 説明文 | "Customize your pipeline configuration." |
| 設定フォーム | パイプライン関連設定 |

### 変数セクション（admin_cicd_variables権限時）

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "Variables" |
| 変数一覧 | 登録されたグループ変数のリスト |
| 変数追加フォーム | 新規変数追加用フォーム |
| 変数制限情報 | グループ変数の上限数表示 |

### Runnerセクション（admin_runners権限時）

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "Runners" |
| 説明文 | "Runners are processes that pick up and execute CI/CD jobs for GitLab." |
| ヘルプリンク | GitLab Runnerドキュメントへのリンク |
| Runner設定 | グループRunnerの設定 |

### Auto DevOpsセクション（admin_group権限時）

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "Auto DevOps" |
| 説明文 | Auto DevOpsの概要説明とドキュメントリンク |
| 設定フォーム | Auto DevOps有効化フォーム |

### 保護環境セクション（admin_protected_environments権限時、EE）

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "Protected environments" |
| 保護環境一覧 | グループレベルの保護環境設定 |

## イベント仕様

### 1-一般パイプライン設定更新

**トリガー**：設定フォームの保存

**処理フロー**：
1. updateアクションにPUT/PATCHリクエスト
2. `Groups::UpdateService`でグループ設定を更新
3. 成功時：成功メッセージ表示、リダイレクト
4. 失敗時：エラーメッセージ表示、リダイレクト

### 2-Auto DevOps設定更新

**トリガー**：Auto DevOpsフォームの保存

**処理フロー**：
1. update_auto_devopsアクションにPATCHリクエスト
2. `Groups::AutoDevopsService`で設定を更新
3. 成功時：成功メッセージ表示、リダイレクト
4. 失敗時：エラーメッセージ表示、リダイレクト

### 3-CI/CD変数の操作

**トリガー**：変数の追加・編集・削除

**処理フロー**：
1. JavaScriptアプリケーション経由でAPI呼び出し
2. `group_variables_path`エンドポイントで処理

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一般設定更新 | namespaces | UPDATE | グループ設定を更新 |
| 変数追加 | ci_group_variables | INSERT | グループ変数を作成 |
| 変数編集 | ci_group_variables | UPDATE | グループ変数を更新 |
| 変数削除 | ci_group_variables | DELETE | グループ変数を削除 |

### テーブル別更新項目詳細

#### namespaces

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | max_artifacts_size | フォーム入力値 | アーティファクト上限 |

#### ci_group_variables

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | key | 変数キー名 | 一意制約 |
| INSERT/UPDATE | value | 変数値（暗号化） | 機密情報 |
| INSERT/UPDATE | protected | 保護フラグ | 保護ブランチのみで使用 |
| INSERT/UPDATE | masked | マスクフラグ | ログでマスク表示 |
| INSERT/UPDATE | environment_scope | 環境スコープ | 適用環境 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 成功 | "Group CI/CD settings were successfully updated." | 設定更新成功時 |
| 成功 | "Auto DevOps pipeline was updated for the group" | Auto DevOps更新成功時 |
| エラー | "There was a problem updating the group CI/CD settings: {error_messages}." | 設定更新失敗時 |
| エラー | "There was a problem updating Auto DevOps pipeline: {error_messages}." | Auto DevOps更新失敗時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足（全セクション非表示） | アクセス拒否ページへリダイレクト |
| max_artifacts_size更新権限なし | 404エラーページを表示 |

## 備考

- 監査ログが記録される（`audit_group_cicd_settings_access`）
- フロントエンドフィーチャーフラグ`ci_variables_pages`がプッシュされる
- レイアウトは`group_settings`を使用
- EE版では保護環境セクションが追加される
- 変数は`current_user`を考慮したプレゼンターでラップされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ci_cd_controller.rb | `app/controllers/groups/settings/ci_cd_controller.rb` | アクション定義と権限チェック |

**主要処理フロー**:
1. **行8-9**: before_actionで権限チェック
2. **行23-28**: showアクションで変数と制限を設定
3. **行30-39**: updateアクションで設定更新
4. **行42-52**: update_auto_devopsアクションでAuto DevOps更新
5. **行56-72**: 監査ログ記録

#### Step 2: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/groups/settings/ci_cd/show.html.haml` | セクション構成と条件分岐 |
| 2-2 | _form.html.haml | `app/views/groups/settings/ci_cd/_form.html.haml` | 一般設定フォーム |
| 2-3 | _auto_devops_form.html.haml | `app/views/groups/settings/ci_cd/_auto_devops_form.html.haml` | Auto DevOps設定 |
| 2-4 | _index.html.haml | `app/views/ci/variables/_index.html.haml` | 変数一覧・追加UI |

#### Step 3: サービスレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update_service.rb | `app/services/groups/update_service.rb` | グループ更新ロジック |
| 3-2 | auto_devops_service.rb | `app/services/groups/auto_devops_service.rb` | Auto DevOps更新 |

### プログラム呼び出し階層図

```
groups/settings/ci_cd_controller.rb#show
    │
    ├─ authorize_show_cicd_settings! (before_action)
    │      └─ can_any? [:admin_cicd_variables, :admin_protected_environments, :admin_runners]
    │
    ├─ define_variables (before_action)
    │      └─ define_ci_variables
    │             ├─ Ci::GroupVariable.new(group: group).present
    │             └─ group.variables.order_key_asc.map { present }
    │
    ├─ audit_group_cicd_settings_access
    │      └─ Gitlab::Audit::Auditor.audit
    │
    └─ show.html.haml
           ├─ SettingsBlockComponent (General pipelines)
           │      └─ _form
           ├─ SettingsBlockComponent (Variables)
           │      └─ ci/variables/_index
           ├─ SettingsBlockComponent (Runners)
           │      └─ groups/runners/_settings
           ├─ SettingsBlockComponent (Auto DevOps)
           │      └─ _auto_devops_form
           └─ [EE] Protected environments
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ CiCdController#show ────────────▶ show.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               @entity = :group                   権限に応じたセクション表示
    │               @variable_limit                    ├─ 一般パイプライン
    │                                                  ├─ 変数
    │                                                  ├─ Runner
    │                                                  └─ Auto DevOps
    │
設定更新 ─────────────▶ CiCdController#update
フォームデータ                │
                             ▼
                    Groups::UpdateService.execute ─────▶ 更新結果
                             │                          ├─ 成功: リダイレクト+成功メッセージ
                             ▼                          └─ 失敗: リダイレクト+エラーメッセージ
                    namespaces UPDATE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ci_cd_controller.rb | `app/controllers/groups/settings/ci_cd_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/groups/settings/ci_cd/show.html.haml` | ビュー | メイン画面描画 |
| _form.html.haml | `app/views/groups/settings/ci_cd/_form.html.haml` | パーシャル | 一般設定フォーム |
| _auto_devops_form.html.haml | `app/views/groups/settings/ci_cd/_auto_devops_form.html.haml` | パーシャル | Auto DevOps設定 |
| _index.html.haml | `app/views/ci/variables/_index.html.haml` | パーシャル | 変数管理UI |
| _settings.html.haml | `app/views/groups/runners/_settings.html.haml` | パーシャル | Runner設定 |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行45-50） |
| update_service.rb | `app/services/groups/update_service.rb` | サービス | グループ更新 |
| auto_devops_service.rb | `app/services/groups/auto_devops_service.rb` | サービス | Auto DevOps更新 |
