# 画面設計書 175-パッケージ設定

## 概要

本ドキュメントは、GitLabグループレベルのパッケージ・レジストリ設定画面の設計書です。グループ内のパッケージレジストリ、Dependency Proxy等の設定を管理する画面を定義します。

### 本画面の処理概要

本画面では、グループ配下のパッケージレジストリおよびDependency Proxyに関する設定を一元管理します。

**業務上の目的・背景**：パッケージ管理はソフトウェア開発において重要な役割を担います。本画面はグループレベルでパッケージレジストリの設定を統一管理することで、依存関係管理の効率化とセキュリティポリシーの一貫性を実現します。

**画面へのアクセス方法**：グループの設定メニューから「パッケージとレジストリ」を選択してアクセスします。アクセスには`admin_group`権限が必要です。

**主要な操作・処理内容**：
1. パッケージレジストリの設定
2. Dependency Proxyの設定
3. Maven Central転送設定

**画面遷移**：
- 遷移元：グループ設定メニュー、グループ詳細画面
- 遷移先：パッケージ一覧、コンテナレジストリ

**権限による表示制御**：`admin_group`権限を持つユーザーのみアクセス可能。また、グループのパッケージ機能が有効である必要があります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | パッケージレジストリ | 主機能 | グループパッケージ設定 |

## 画面種別

設定

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/packages_and_registries` | GET | show |

## 入出力項目

本画面はJavaScriptアプリケーションで動作し、入出力はAPIを通じて行われます。

## 表示項目

本画面はVue.jsベースのSPAで描画されます。

| 項目名 | 説明 |
|--------|------|
| パッケージレジストリ設定 | パッケージ公開・取得に関する設定 |
| Dependency Proxy設定 | 外部レジストリのプロキシ設定 |
| Maven Central転送設定 | Maven Centralへのリクエスト転送設定 |

## イベント仕様

### 1-設定変更

**トリガー**：各種設定項目の変更

**処理フロー**：
1. Vue.jsアプリケーションがGraphQL APIを呼び出し
2. 設定を更新
3. 結果をUIに反映

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 設定更新 | namespace_package_settings | UPDATE | パッケージ設定を更新 |
| 設定更新 | dependency_proxy_group_settings | UPDATE | Dependency Proxy設定を更新 |

## メッセージ仕様

JavaScriptアプリケーション内でフィードバックが表示されます。

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足 | アクセス拒否ページへリダイレクト |
| パッケージ機能無効 | 404エラーページを表示 |

## 備考

- レイアウトは`group_settings`を使用
- `maven_central_request_forwarding`フィーチャーフラグがプッシュされる
- `admin_dependency_proxy`権限がフロントエンドにプッシュされる
- `packages_and_registries_group_settings_template_data`ヘルパーでデータを提供

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | packages_and_registries_controller.rb | `app/controllers/groups/settings/packages_and_registries_controller.rb` | 権限チェックとフィーチャーフラグ |

**主要処理フロー**:
1. **行7**: before_actionでadmin_group権限を確認
2. **行8**: パッケージ機能の有効性を確認
3. **行10-13**: フロントエンドへのフィーチャーフラグ・権限プッシュ

#### Step 2: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/groups/settings/packages_and_registries/show.html.haml` | Vue.jsマウントポイント |

**主要処理フロー**:
- **行5**: `#js-packages-and-registries-settings`にVue.jsアプリケーションをマウント
- データ属性として設定情報を渡す

### プログラム呼び出し階層図

```
groups/settings/packages_and_registries_controller.rb#show
    │
    ├─ authorize_admin_group! (before_action)
    │
    ├─ verify_packages_enabled! (before_action)
    │      └─ group.packages_feature_enabled?
    │
    ├─ push_frontend_feature_flag(:maven_central_request_forwarding, group)
    │
    ├─ push_frontend_ability(:admin_dependency_proxy, group, current_user)
    │
    └─ show.html.haml
           │
           └─ #js-packages-and-registries-settings
                  └─ data: packages_and_registries_group_settings_template_data(@group)
                         │
                         └─ Vue.js Application (フロントエンド)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ PackagesAndRegistriesController ─▶ show.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               権限チェック                        Vue.jsアプリ
    │               └─ admin_group?                    マウントポイント
    │                                                       │
    │                                                       ▼
    │                                                  GraphQL API
    │                                                  呼び出し
    │                                                       │
    │                                                       ▼
設定変更 ──────────────────────────────────────────▶ 設定更新
(Vue.js経由)                                              │
                                                          ▼
                                              namespace_package_settings
                                              dependency_proxy_group_settings
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| packages_and_registries_controller.rb | `app/controllers/groups/settings/packages_and_registries_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/groups/settings/packages_and_registries/show.html.haml` | ビュー | Vue.jsマウントポイント |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行86） |
| packages_and_registries_helper.rb | `app/helpers/groups/settings/packages_and_registries_helper.rb` | ヘルパー | テンプレートデータ生成 |
