# 画面設計書 176-インテグレーション一覧

## 概要

本ドキュメントは、GitLabグループレベルのインテグレーション一覧画面の設計書です。グループ内のすべてのプロジェクトに適用される外部サービス連携設定を管理する画面を定義します。

### 本画面の処理概要

本画面では、グループ配下の全プロジェクトに継承される外部サービス連携（Slack、Jira、Mattermost等）の設定を一覧表示し、管理します。

**業務上の目的・背景**：企業のDevOps環境では、複数の外部ツールとの連携が不可欠です。本画面はグループレベルでインテグレーションを設定することで、配下のすべてのプロジェクトに自動的に適用され、個別設定の手間を省きつつ、組織全体での連携ポリシーの一貫性を確保します。

**画面へのアクセス方法**：グループの設定メニューから「インテグレーション」を選択してアクセスします。アクセスには`admin_integrations`権限が必要です。

**主要な操作・処理内容**：
1. 利用可能なインテグレーション一覧の確認
2. インテグレーション設定画面への遷移
3. インテグレーションの有効化状態の確認

**画面遷移**：
- 遷移元：グループ設定メニュー、グループ詳細画面
- 遷移先：インテグレーション編集画面

**権限による表示制御**：`admin_integrations`権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | Slack連携 | 主機能 | グループ外部連携設定の一覧 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/integrations` | GET | index |
| `/groups/:group_id/-/settings/integrations/:id/edit` | GET | edit |
| `/groups/:group_id/-/settings/integrations/:id` | PUT/PATCH | update |
| `/groups/:group_id/-/settings/integrations/:id/test` | PUT | test |
| `/groups/:group_id/-/settings/integrations/:id/reset` | POST | reset |

## 入出力項目

本画面は一覧表示のため、入力項目はありません。

## 表示項目

### ページヘッダー

| 項目名 | 説明 |
|--------|------|
| タイトル | "Group-level integration management" |
| 説明文 | グループレベルインテグレーションの説明とヘルプリンク |

### インテグレーション一覧

| 項目名 | 説明 |
|--------|------|
| インテグレーション名 | 各インテグレーションの名称（タイトル順でソート） |
| 状態表示 | 有効/無効の状態 |
| 設定リンク | 編集画面へのリンク |

### 利用可能なインテグレーション例

- Slack通知
- Jira
- Mattermost
- Microsoft Teams
- Prometheus
- その他多数のサードパーティ連携

## イベント仕様

### 1-インテグレーション選択

**トリガー**：インテグレーション項目のクリック

**処理フロー**：
1. 選択されたインテグレーションのeditアクションへ遷移

**遷移先**：インテグレーション編集画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | integrations | SELECT | インテグレーション設定を取得 |

本画面は一覧表示のみのため、直接的なデータベース更新は行いません。

## メッセージ仕様

本画面では特定のメッセージは表示されません。

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足 | アクセス拒否ページへリダイレクト |

## 備考

- レイアウトは`group_settings`を使用
- インテグレーションはタイトルの降順でソートされる
- `find_or_initialize_all_non_project_specific`でプロジェクト固有でないインテグレーションを取得
- 共通パーシャル`shared/integrations/_index`を使用して一覧を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | integrations_controller.rb | `app/controllers/groups/settings/integrations_controller.rb` | indexアクションの実装 |

**主要処理フロー**:
1. **行8**: before_actionで`authorize_admin_integrations!`を呼び出し
2. **行14-17**: indexアクションでインテグレーション一覧を取得
3. **行15-16**: `find_or_initialize_all_non_project_specific`でインテグレーションを初期化
4. **行17**: タイトル降順でソート

#### Step 2: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/groups/settings/integrations/index.html.haml` | ページ構成 |
| 2-2 | _index.html.haml | `app/views/shared/integrations/_index.html.haml` | インテグレーション一覧パーシャル |

**主要処理フロー**:
- **行6-9**: PageHeadingComponentでヘッダーと説明を表示
- **行8-9**: ヘルプリンクを含む説明文
- **行12**: 共通パーシャルでインテグレーション一覧を表示

### プログラム呼び出し階層図

```
groups/settings/integrations_controller.rb#index
    │
    ├─ authorize_admin_integrations! (before_action)
    │
    └─ @integrations = Integration
           .find_or_initialize_all_non_project_specific(Integration.for_group(group))
           .sort_by { |int| int.title.downcase }
           │
           └─ index.html.haml
                  │
                  ├─ PageHeadingComponent
                  │      └─ タイトル + 説明文
                  │
                  └─ shared/integrations/_index
                         └─ インテグレーション一覧表示
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ IntegrationsController#index ──▶ index.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               @integrations =                    ページヘッダー
    │               Integration                        + インテグレーション一覧
    │               .find_or_initialize_all_non_project_specific
    │               .sort_by { title.downcase }
    │
    └─ Integration.for_group(group) ◀─────────────────── integrations テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| integrations_controller.rb | `app/controllers/groups/settings/integrations_controller.rb` | コントローラー | リクエスト処理 |
| index.html.haml | `app/views/groups/settings/integrations/index.html.haml` | ビュー | メイン画面描画 |
| _index.html.haml | `app/views/shared/integrations/_index.html.haml` | パーシャル | インテグレーション一覧 |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行71-76） |
| integration.rb | `app/models/integration.rb` | モデル | インテグレーションモデル |
| integrations/actions.rb | `app/controllers/concerns/integrations/actions.rb` | Concern | 共通アクション |
