# 画面設計書 177-アクセストークン一覧

## 概要

本ドキュメントは、GitLabグループレベルのアクセストークン一覧画面の設計書です。グループアクセストークンの作成、管理、失効を行う画面を定義します。

### 本画面の処理概要

本画面では、グループスコープのアクセストークンを作成・管理し、GitLab APIやGit操作の認証に使用できるトークンを提供します。

**業務上の目的・背景**：CI/CDパイプラインやスクリプトからGitLab APIにアクセスする際、個人アクセストークンではなくグループスコープのトークンを使用することで、特定ユーザーへの依存を排除し、チームでの運用を可能にします。また、トークンに適切なスコープと有効期限を設定することでセキュリティを担保します。

**画面へのアクセス方法**：グループの設定メニューから「アクセストークン」を選択してアクセスします。トークン作成には`create_resource_access_tokens`権限が必要です。

**主要な操作・処理内容**：
1. グループアクセストークンの新規作成
2. アクティブなトークン一覧の確認
3. 非アクティブなトークン一覧の確認
4. トークンの失効（revoke）
5. トークンのローテーション（rotate）

**画面遷移**：
- 遷移元：グループ設定メニュー、グループ詳細画面
- 遷移先：本画面内での操作が中心

**権限による表示制御**：
- トークン一覧は全ユーザーに表示
- トークン作成フォームは`create_resource_access_tokens`権限保持者のみ表示
- グループ設定でトークン作成が無効化されている場合は作成不可

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 81 | 個人アクセストークン | 主機能 | グループアクセストークンの管理 |

## 画面種別

一覧 / 登録

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/access_tokens` | GET | index |
| `/groups/:group_id/-/settings/access_tokens` | POST | create |
| `/groups/:group_id/-/settings/access_tokens/:id/revoke` | PUT | revoke |
| `/groups/:group_id/-/settings/access_tokens/:id/rotate` | PUT | rotate |
| `/groups/:group_id/-/settings/access_tokens/inactive` | GET | inactive |

## 入出力項目

### トークン作成フォーム

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| Token name | テキスト | 必須 | トークンの名前 |
| Expiration date | 日付 | 任意 | 有効期限 |
| Select a role | セレクト | 必須 | トークンのロール（Guest以上） |
| Select scopes | チェックボックス | 必須 | アクセススコープ |

### 選択可能なスコープ

- `api` - 完全なAPIアクセス
- `read_api` - 読み取り専用APIアクセス
- `read_registry` - コンテナレジストリ読み取り
- `write_registry` - コンテナレジストリ書き込み
- `read_repository` - リポジトリ読み取り
- `write_repository` - リポジトリ書き込み

## 表示項目

### ページヘッダー

| 項目名 | 説明 |
|--------|------|
| タイトル | "Group access tokens" |
| 説明文 | トークンの用途とヘルプリンク |

### アクティブトークン一覧

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "Active group access tokens" |
| トークンカウント | アクティブなトークン数 |
| トークン一覧 | トークン名、スコープ、有効期限、ロール等 |
| 追加ボタン | "Add new token" ボタン（権限がある場合） |

### 非アクティブトークン一覧

| 項目名 | 説明 |
|--------|------|
| セクションタイトル | "Inactive group access tokens" |
| トークンカウント | 非アクティブなトークン数 |
| トークン一覧 | 失効済み・期限切れトークン |

## イベント仕様

### 1-トークン作成

**トリガー**：トークン作成フォームの送信

**処理フロー**：
1. POSTリクエストをcreateアクションに送信
2. トークンを作成
3. 成功時：作成されたトークン値を表示（一度のみ）
4. 失敗時：エラーメッセージを表示

### 2-トークン失効

**トリガー**：トークン一覧からの失効操作

**処理フロー**：
1. PUTリクエストをrevokeアクションに送信
2. トークンを失効状態に更新
3. 一覧を更新

### 3-トークンローテーション

**トリガー**：トークン一覧からのローテーション操作

**処理フロー**：
1. PUTリクエストをrotateアクションに送信
2. `GroupAccessTokens::RotateService`で新しいトークンを生成
3. 新しいトークン値を返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| トークン作成 | personal_access_tokens | INSERT | グループアクセストークンを作成 |
| トークン作成 | users | INSERT | Bot ユーザーを作成 |
| トークン失効 | personal_access_tokens | UPDATE | revoked を true に |
| ローテーション | personal_access_tokens | INSERT/UPDATE | 新トークン作成、旧トークン失効 |

### テーブル別更新項目詳細

#### personal_access_tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | トークン名 |
| INSERT | expires_at | フォーム入力値 | 有効期限 |
| INSERT | scopes | 選択されたスコープ | 配列 |
| INSERT | user_id | Bot ユーザーID | グループ専用Bot |
| UPDATE | revoked | true | 失効時 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 情報 | "Generate group access tokens scoped to this group for your applications that need access to the GitLab API." | 作成権限がある場合 |
| 情報 | "Group access token creation is disabled in this group." | 作成権限がない場合 |
| 情報 | "You can enable group access token creation in group settings." | ルートグループの管理者の場合 |
| 情報 | "This group has no active access tokens." | アクティブトークンがない場合 |
| 情報 | "This group has no inactive access tokens." | 非アクティブトークンがない場合 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足 | 作成フォームを非表示（一覧は表示） |
| トークン作成失敗 | エラーメッセージを表示 |

## 備考

- レイアウトは`group_settings`を使用
- トークン値は作成時に一度だけ表示され、再表示不可（セキュリティ上の理由）
- `GroupAccessTokenSerializer`でトークン情報をシリアライズ
- 非アクティブトークンはJSON APIでページネーション取得
- デフォルトアクセスレベルはGuest

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | access_tokens_controller.rb | `app/controllers/groups/settings/access_tokens_controller.rb` | 基本構造とエイリアス |
| 1-2 | access_tokens_actions.rb | `app/controllers/concerns/access_tokens_actions.rb` | 共通アクション実装 |
| 1-3 | render_access_tokens.rb | `app/controllers/concerns/render_access_tokens.rb` | レンダリングヘルパー |

**主要処理フロー**:
1. **行12**: `alias_method :resource, :group`でグループをリソースとして設定
2. **行14-16**: `resource_access_tokens_path`でパスを定義
3. **行20-22**: `represent`メソッドでシリアライズ
4. **行24-26**: `rotate_service`でローテーションサービスを指定

#### Step 2: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.html.haml | `app/views/groups/settings/access_tokens/index.html.haml` | ページ構成 |
| 2-2 | _form.html.haml | `app/views/shared/access_tokens/_form.html.haml` | トークン作成フォーム |

**主要処理フロー**:
- **行7-20**: SettingsSectionComponentで説明文を表示
- **行23**: Vue.jsアプリケーション（#js-new-access-token-app）
- **行25-52**: CrudComponentでアクティブトークン一覧
- **行54-59**: CrudComponentで非アクティブトークン一覧

### プログラム呼び出し階層図

```
groups/settings/access_tokens_controller.rb#index
    │
    ├─ AccessTokensActions#index (Concern)
    │      ├─ @resource_access_token = PersonalAccessToken.new
    │      ├─ @scopes = スコープ一覧
    │      └─ @active_access_tokens, @inactive_access_tokens
    │
    └─ index.html.haml
           │
           ├─ SettingsSectionComponent (説明)
           │
           ├─ #js-new-access-token-app (Vue.js)
           │
           ├─ CrudComponent (Active tokens)
           │      ├─ shared/access_tokens/_form
           │      └─ #js-access-token-table-app
           │
           └─ CrudComponent (Inactive tokens)
                  └─ #js-inactive-access-token-table-app
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ AccessTokensController#index ───▶ index.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               @active_access_tokens              アクティブトークン一覧
    │               @inactive_access_tokens            非アクティブトークン一覧
    │               @scopes                            トークン作成フォーム
    │
    │
トークン作成 ─────────▶ AccessTokensController#create
フォームデータ                │
                             ▼
                    ResourceAccessTokens::CreateService
                             │
                             ├─ users INSERT (Bot)
                             └─ personal_access_tokens INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| access_tokens_controller.rb | `app/controllers/groups/settings/access_tokens_controller.rb` | コントローラー | リクエスト処理 |
| access_tokens_actions.rb | `app/controllers/concerns/access_tokens_actions.rb` | Concern | 共通アクション |
| index.html.haml | `app/views/groups/settings/access_tokens/index.html.haml` | ビュー | メイン画面描画 |
| _form.html.haml | `app/views/shared/access_tokens/_form.html.haml` | パーシャル | トークン作成フォーム |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行60-68） |
| group_access_token_serializer.rb | `app/serializers/group_access_token_serializer.rb` | シリアライザー | トークン情報整形 |
| rotate_service.rb | `app/services/group_access_tokens/rotate_service.rb` | サービス | トークンローテーション |
