# 画面設計書 178-バッジ一覧

## 概要

本ドキュメントは、GitLabグループレベルのバッジ一覧画面の設計書です。グループ配下のすべてのプロジェクトに表示されるバッジの設定を管理する画面を定義します。

### 本画面の処理概要

本画面では、グループレベルで設定されるプロジェクトバッジを管理します。バッジはプロジェクトのREADMEや概要ページに表示され、ビルドステータスやテストカバレッジなどの情報を視覚的に示します。

**業務上の目的・背景**：バッジは、プロジェクトの品質やステータスを一目で把握するための重要な視覚的要素です。グループレベルでバッジを設定することで、配下のすべてのプロジェクトに一貫したバッジを自動適用し、組織全体での品質指標の可視化と標準化を実現します。

**画面へのアクセス方法**：グループの設定メニューから「バッジ」を選択してアクセスします。アクセスには適切な設定権限が必要です。

**主要な操作・処理内容**：
1. バッジの新規作成
2. バッジ一覧の確認
3. バッジの編集
4. バッジの削除
5. バッジのプレビュー

**画面遷移**：
- 遷移元：グループ設定メニュー、グループ詳細画面
- 遷移先：本画面内での操作が中心

**権限による表示制御**：グループの設定権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 148 | バッジ管理 | 主機能 | グループバッジの設定 |

## 画面種別

一覧 / 設定

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/badges` | GET | index |

## 入出力項目

本画面はVue.jsベースのSPAで動作し、APIを通じて操作が行われます。

### バッジ作成/編集フォーム

| 項目名 | 種別 | 必須 | 説明 |
|--------|------|------|------|
| Name | テキスト | 任意 | バッジの表示名 |
| Link | URL | 必須 | バッジクリック時のリンク先URL |
| Badge image URL | URL | 必須 | バッジ画像のURL |

### 使用可能なプレースホルダー

- `%{project_path}` - プロジェクトのパス
- `%{project_title}` - プロジェクトのタイトル
- `%{default_branch}` - デフォルトブランチ名
- `%{commit_sha}` - 最新コミットのSHA

## 表示項目

本画面はVue.jsベースのSPAで描画されます。

| 項目名 | 説明 |
|--------|------|
| バッジ一覧 | 設定されたバッジの一覧 |
| バッジプレビュー | 各バッジの視覚的プレビュー |
| 追加フォーム | 新規バッジ作成用フォーム |
| 編集フォーム | 既存バッジ編集用フォーム |

## イベント仕様

### 1-バッジ作成

**トリガー**：バッジ作成フォームの送信

**処理フロー**：
1. Badge API にPOSTリクエスト
2. バッジを作成
3. 一覧を更新

### 2-バッジ編集

**トリガー**：バッジ編集フォームの送信

**処理フロー**：
1. Badge API にPUTリクエスト
2. バッジを更新
3. 一覧を更新

### 3-バッジ削除

**トリガー**：削除ボタンのクリック

**処理フロー**：
1. Badge API にDELETEリクエスト
2. バッジを削除
3. 一覧を更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| バッジ作成 | badges | INSERT | グループバッジを作成 |
| バッジ編集 | badges | UPDATE | グループバッジを更新 |
| バッジ削除 | badges | DELETE | グループバッジを削除 |

### テーブル別更新項目詳細

#### badges

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | バッジ名（任意） |
| INSERT/UPDATE | link_url | フォーム入力値 | リンクURL |
| INSERT/UPDATE | image_url | フォーム入力値 | 画像URL |
| INSERT | group_id | 対象グループID | グループ関連付け |
| INSERT | type | 'GroupBadge' | バッジ種別 |

## メッセージ仕様

JavaScriptアプリケーション内でフィードバックが表示されます。

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足 | アクセス拒否ページへリダイレクト |
| バッジ作成失敗 | エラーメッセージを表示 |
| 無効なURL形式 | バリデーションエラーを表示 |

## 備考

- 共有パーシャル`shared/badges/_badge_settings`を使用
- バッジ管理はVue.jsアプリケーションで実装
- API経由で操作を実行（`@badge_api_endpoint`）
- グループバッジは配下の全プロジェクトに自動適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.html.haml | `app/views/groups/settings/badges/index.html.haml` | ページ構成 |
| 1-2 | _badge_settings.html.haml | `app/views/shared/badges/_badge_settings.html.haml` | Vue.jsマウントポイント |

**主要処理フロー**:
- **行4**: 共有パーシャルを呼び出し
- パーシャル: `#badge-settings`にVue.jsアプリケーションをマウント
- データ属性として`@badge_api_endpoint`を渡す

#### Step 2: API構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | badges.rb | `lib/api/badges.rb` | バッジAPIの実装 |

### プログラム呼び出し階層図

```
groups/settings/badges/index.html.haml
    │
    └─ shared/badges/_badge_settings
           │
           └─ #badge-settings
                  │
                  └─ data: { api_endpoint_url: @badge_api_endpoint }
                         │
                         └─ Vue.js Application (フロントエンド)
                                │
                                ├─ GET /api/v4/groups/:id/badges
                                ├─ POST /api/v4/groups/:id/badges
                                ├─ PUT /api/v4/groups/:id/badges/:badge_id
                                └─ DELETE /api/v4/groups/:id/badges/:badge_id
```

### データフロー図

```
[入力]                      [処理]                           [出力]

グループID ───────────▶ badges/index.html.haml ─────────▶ Vue.jsアプリ
    │                                                       │
    │                                                       ▼
    │                                                  Badge API
    │                                                  呼び出し
    │                                                       │
    │                                                       ▼
バッジ操作 ──────────────────────────────────────────▶ バッジCRUD
(Vue.js経由)                                              │
                                                          ▼
                                                    badges テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/groups/settings/badges/index.html.haml` | ビュー | メイン画面描画 |
| _badge_settings.html.haml | `app/views/shared/badges/_badge_settings.html.haml` | パーシャル | Vue.jsマウントポイント |
| badges.rb | `lib/api/badges.rb` | API | バッジCRUD API |
| badge.rb | `app/models/badge.rb` | モデル | バッジモデル |
| group_badge.rb | `app/models/badges/group_badge.rb` | モデル | グループバッジモデル |
