# 画面設計書 180-アプリケーション詳細

## 概要

本ドキュメントは、GitLabグループレベルのOAuthアプリケーション詳細画面の設計書です。個別のOAuthアプリケーションの情報を表示し、クライアントIDやシークレットの確認、シークレットの更新などを行う画面を定義します。

### 本画面の処理概要

本画面では、グループに関連付けられた特定のOAuthアプリケーションの詳細情報を表示し、認証に必要な情報の確認とシークレットの管理を行います。

**業務上の目的・背景**：OAuthアプリケーションを実装する際、クライアントIDとクライアントシークレットが必要です。本画面は、これらの認証情報を安全に確認・管理するためのインターフェースを提供し、必要に応じてシークレットの再生成やアプリケーションの編集・削除を行えるようにします。

**画面へのアクセス方法**：グループ設定のアプリケーション一覧から特定のアプリケーションを選択、またはアプリケーション作成完了時に自動遷移します。アクセスには`admin_group`権限が必要です。

**主要な操作・処理内容**：
1. アプリケーション詳細情報の確認
2. クライアントID・シークレットのコピー
3. シークレットの再生成（renew）
4. アプリケーション編集画面への遷移
5. アプリケーションの削除

**画面遷移**：
- 遷移元：アプリケーション一覧画面、アプリケーション作成完了
- 遷移先：アプリケーション編集画面、アプリケーション一覧画面

**権限による表示制御**：`admin_group`権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | グループOAuthアプリの詳細 |

## 画面種別

詳細

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|-------------|----------|
| `/groups/:group_id/-/settings/applications/:id` | GET | show |
| `/groups/:group_id/-/settings/applications/:id` | DELETE | destroy |
| `/groups/:group_id/-/settings/applications/:id/renew` | PUT | renew |

## 入出力項目

本画面は詳細表示が主目的のため、直接的な入力項目はありません。

## 表示項目

### ページヘッダー

| 項目名 | 説明 |
|--------|------|
| パンくずリスト | "Group applications" へのリンク |
| タイトル | "Group application: {アプリケーション名}" |

### アプリケーション情報

| 項目名 | 説明 |
|--------|------|
| Application ID | OAuthクライアントID（コピー可能） |
| Secret | クライアントシークレット（新規作成時またはrenew後のみ表示） |
| Callback URL | 設定されたリダイレクトURI |
| Confidential | コンフィデンシャルフラグ |
| Scopes | 許可されたスコープ一覧 |

### アクションボタン

| 項目名 | 説明 |
|--------|------|
| Edit | 編集画面への遷移ボタン |
| Renew secret | シークレット再生成ボタン |
| Delete | アプリケーション削除ボタン |
| Back to applications | 一覧画面への戻りリンク |

## イベント仕様

### 1-シークレット再生成

**トリガー**：「Renew secret」ボタンのクリック

**処理フロー**：
1. PUTリクエストを`renew_group_settings_application_path`に送信
2. `@application.renew_secret`でシークレットを再生成
3. 保存成功時：JSON形式で新しいシークレットを返却
4. 保存失敗時：エラーを返却

### 2-アプリケーション削除

**トリガー**：「Delete」ボタンのクリック

**処理フロー**：
1. 確認ダイアログを表示
2. DELETEリクエストを`group_settings_application_path`に送信
3. アプリケーションを削除
4. 一覧画面にリダイレクト

### 3-編集画面遷移

**トリガー**：「Edit」ボタンのクリック

**処理フロー**：
1. `edit_group_settings_application_path`にGETリクエスト
2. 編集画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| シークレット再生成 | oauth_applications | UPDATE | シークレットを再生成して保存 |
| アプリケーション削除 | oauth_applications | DELETE | アプリケーションを削除 |

### テーブル別更新項目詳細

#### oauth_applications

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | secret | 新しいシークレット | renew時に更新 |
| DELETE | - | id による削除 | destroy時 |

## メッセージ仕様

| 種別 | メッセージ | 表示条件 |
|------|----------|----------|
| 成功 | "Application was successfully destroyed." | アプリケーション削除成功時 |
| 警告 | シークレットは一度だけ表示される旨の注意 | 新規作成時またはrenew後 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 権限不足 | アクセス拒否ページへリダイレクト |
| アプリケーションが見つからない | 404エラー |
| シークレット更新失敗 | JSON形式でエラーを返却 |

## 備考

- 共有パーシャル`shared/doorkeeper/applications/_show`を使用
- シークレットは新規作成時とrenew後にのみ表示され、再表示不可
- PageHeadingComponentでタイトルを表示
- セキュリティ上、シークレットはプレーンテキストで一度だけ表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コントローラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | applications_controller.rb | `app/controllers/groups/settings/applications_controller.rb` | showアクションの実装 |

**主要処理フロー**:
1. **行9**: before_actionで`set_application`を呼び出し
2. **行18**: showアクションは空（テンプレートのみ）
3. **行71-72**: `set_application`で`@group.oauth_applications.find(params[:id])`
4. **行55-59**: destroyアクションでアプリケーション削除

#### Step 2: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | show.html.haml | `app/views/groups/settings/applications/show.html.haml` | ページ構成 |
| 2-2 | _show.html.haml | `app/views/shared/doorkeeper/applications/_show.html.haml` | アプリケーション詳細パーシャル |

**主要処理フロー**:
- **行1**: パンくずリストにアプリケーション一覧へのリンクを追加
- **行2-3**: アプリケーション名をパンくずとページタイトルに設定
- **行5**: PageHeadingComponentでタイトル表示
- **行6-10**: 共有パーシャルに各種パスを渡して詳細を表示

### プログラム呼び出し階層図

```
groups/settings/applications_controller.rb#show
    │
    ├─ authorize_admin_group! (before_action)
    │
    └─ set_application (before_action)
           │
           └─ @application = @group.oauth_applications.find(params[:id])
           │
           └─ show.html.haml
                  │
                  ├─ add_to_breadcrumbs (アプリケーション一覧へ)
                  │
                  ├─ PageHeadingComponent
                  │      └─ "Group application: {name}"
                  │
                  └─ shared/doorkeeper/applications/_show
                         │
                         ├─ edit_path: edit_group_settings_application_path
                         ├─ delete_path: group_settings_application_path
                         ├─ index_path: group_settings_applications_path
                         └─ renew_path: renew_group_settings_application_path
```

### データフロー図

```
[入力]                      [処理]                           [出力]

アプリケーションID ──────▶ ApplicationsController#show ───▶ show.html.haml
    │                        │                                │
    │                        ▼                                ▼
    │               @application =                     アプリケーション詳細
    │               @group.oauth_applications.find     + クライアントID
    │                                                  + スコープ
    │                                                  + 操作ボタン
    │
Renew操作 ─────────────▶ ApplicationsController#renew
                             │
                             ▼
                    @application.renew_secret
                    @application.save
                             │
                             └─ JSON { secret: plaintext_secret }

Delete操作 ────────────▶ ApplicationsController#destroy
                             │
                             ▼
                    @application.destroy
                             │
                             └─ redirect_to index + flash[:notice]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| applications_controller.rb | `app/controllers/groups/settings/applications_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/groups/settings/applications/show.html.haml` | ビュー | メイン画面描画 |
| _show.html.haml | `app/views/shared/doorkeeper/applications/_show.html.haml` | パーシャル | アプリ詳細共通 |
| group.rb | `config/routes/group.rb` | ルーティング | URL定義（行82-84） |
| oauth_application.rb | `app/models/authn/oauth_application.rb` | モデル | OAuthアプリモデル |
