# 画面設計書 182-組織一覧

## 概要

本ドキュメントは、GitLabの組織（Organization）一覧画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：GitLabの組織（Organization）機能は、複数のグループやプロジェクトをより大きな単位でまとめて管理するための上位概念である。この一覧画面は、ユーザーが所属する組織を一覧表示し、組織間を切り替えたり、新しい組織を作成したりするための起点となる。企業や大規模チームにおいて、複数のグループやプロジェクトを組織的に管理する際に重要な役割を果たす。

**画面へのアクセス方法**：ヘッダーメニューの「Your work」から「Organizations」を選択するか、直接URL `/organizations` または `/o` にアクセスする。

**主要な操作・処理内容**：
1. ユーザーが所属する組織の一覧表示
2. 組織の検索（3文字以上で検索可能）
3. 新規組織の作成（権限がある場合）
4. 組織詳細画面への遷移
5. ページネーションによる一覧のナビゲーション

**画面遷移**：
- 遷移元：ヘッダーメニュー、ダッシュボード
- 遷移先：組織詳細画面（184-組織詳細）、組織新規作成画面（183-組織新規作成）

**権限による表示制御**：
- 「New organization」ボタンは `organization_switching` フィーチャーフラグが有効かつ `create_organization` 権限を持つユーザーのみに表示される
- 一覧には自分が所属する組織のみが表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 134 | 組織管理 | 主機能 | 組織の一覧表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/-/organizations` または `/o`
- HTTPメソッド: GET
- コントローラー: `Organizations::OrganizationsController#index`

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 説明 |
|--------|--------|----------|------|----------|------|
| ページネーションカーソル | after/before | String | No | クエリパラメータ | ページネーション用カーソル |
| 1ページあたり件数 | first/last | Integer | No | クエリパラメータ | デフォルト20件 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | 見出し | "Organizations" |
| 新規作成ボタン | ボタン | "New organization"（権限がある場合のみ表示） |
| 組織一覧 | リスト | 組織名、アバター、説明を含むカード形式 |
| 空状態メッセージ | メッセージ | 組織が存在しない場合に表示 |
| ページネーション | ナビゲーション | 前ページ/次ページボタン |

## イベント仕様

### 1-新規組織ボタン押下

1. 組織新規作成画面（183-組織新規作成）へ遷移

### 2-組織カード押下

1. 選択した組織の詳細画面（184-組織詳細）へ遷移

### 3-ページネーション操作

1. GraphQL APIを通じて次/前ページのデータを取得
2. 一覧を更新表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | organizations | SELECT | ユーザーが所属する組織の取得 |
| 画面表示 | organization_users | SELECT | ユーザーと組織の関連確認 |

### テーブル別更新項目詳細

この画面では参照のみを行い、データベースの更新は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | エラー | An error occurred loading user organizations. Please refresh the page to try again. | GraphQL取得エラー時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| GraphQL取得エラー | アラートを表示し、ページ再読み込みを促す |
| フィーチャーフラグ無効 | アクセス拒否（403） |
| 未ログイン | ログイン画面へリダイレクト |

## 備考

- この画面はVue.jsベースのSPA（Single Page Application）として実装されている
- データ取得はGraphQL API（`currentUserOrganizationsQuery`）を使用
- フィーチャーフラグ `ui_for_organizations` と `organization_switching` の両方が有効である必要がある

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

組織モデルとユーザーとの関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | organization.rb | `app/models/organizations/organization.rb` | 組織モデルの属性、関連、スコープ |
| 1-2 | organization_user.rb | `app/models/organizations/organization_user.rb` | ユーザーと組織の関連モデル |

**読解のコツ**: `has_many :organization_users` と `has_many :users, through: :organization_users` の関連を理解すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | indexアクションの処理 |
| 2-2 | application_controller.rb | `app/controllers/organizations/application_controller.rb` | 基底コントローラーの共通処理 |

**主要処理フロー**:
1. **行22-24**: フィーチャーフラグの確認
2. **行23**: `def index; end` - 空のアクション（ビューのみ）

#### Step 3: ビューとフロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/organizations/organizations/index.html.haml` | Vue.jsマウントポイント |
| 3-2 | app.vue | `app/assets/javascripts/organizations/index/components/app.vue` | メインVueコンポーネント |
| 3-3 | organizations_view.vue | `app/assets/javascripts/organizations/shared/components/organizations_view.vue` | 一覧表示コンポーネント |

**主要処理フロー**:
- **行34-46**: Apollo GraphQL による組織データ取得
- **行57-72**: ページネーション処理

#### Step 4: GraphQLクエリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | current_user_organizations.query.graphql | `app/assets/javascripts/organizations/shared/graphql/queries/current_user_organizations.query.graphql` | 組織一覧取得クエリ |

### プログラム呼び出し階層図

```
index.html.haml
    │
    └─ #js-organizations-index (Vue mount point)
           │
           └─ OrganizationsIndexApp (app.vue)
                  │
                  ├─ Apollo Query: currentUserOrganizationsQuery
                  │      └─ GraphQL API
                  │
                  └─ OrganizationsView
                         ├─ OrganizationsList
                         │      └─ OrganizationsListItem
                         │
                         └─ GlKeysetPagination
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザーアクセス ───▶ OrganizationsController#index
                            │
                            └─▶ HAMLテンプレート
                                    │
                                    └─▶ Vue.js App
                                            │
                                            ├─ GraphQL Query
                                            │
                                            └─▶ 組織一覧表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | コントローラー | リクエスト処理 |
| application_controller.rb | `app/controllers/organizations/application_controller.rb` | コントローラー | 基底クラス |
| index.html.haml | `app/views/organizations/organizations/index.html.haml` | ビュー | マウントポイント |
| app.vue | `app/assets/javascripts/organizations/index/components/app.vue` | Vue | メインコンポーネント |
| organizations_view.vue | `app/assets/javascripts/organizations/shared/components/organizations_view.vue` | Vue | 一覧表示 |
| organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | ヘルパー | ビューヘルパー |
| organizations.rb | `config/routes/organizations.rb` | ルーティング | URL定義 |
| organization.rb | `app/models/organizations/organization.rb` | モデル | データ構造 |
