# 画面設計書 183-組織新規作成

## 概要

本ドキュメントは、GitLabの組織（Organization）新規作成画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：GitLabの組織機能を活用するためには、まず組織を作成する必要がある。この画面は新しい組織を作成するためのフォームを提供し、組織名、URL、説明、アバター画像を設定できる。組織はグループやプロジェクトの最上位コンテナとして機能し、企業や大規模チームの管理構造を反映するために使用される。

**画面へのアクセス方法**：組織一覧画面（182-組織一覧）から「New organization」ボタンをクリックするか、直接URL `/-/organizations/new` にアクセスする。

**主要な操作・処理内容**：
1. 組織名の入力（必須）
2. 組織URLの入力（必須、ユニーク制約あり）
3. 説明の入力（任意、Markdown対応）
4. アバター画像のアップロード（任意）
5. フォーム送信による組織作成

**画面遷移**：
- 遷移元：組織一覧画面（182-組織一覧）
- 遷移先：作成成功時は組織詳細画面（184-組織詳細）へ、キャンセル時は組織一覧画面へ

**権限による表示制御**：
- `organization_switching` フィーチャーフラグが有効である必要がある
- `create_organization` 権限を持つユーザーのみがアクセス可能
- 権限がない場合はアクセス拒否（403）となる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 134 | 組織管理 | 主機能 | 新規組織の作成 |

## 画面種別

登録

## URL/ルーティング

- パス: `/-/organizations/new`
- HTTPメソッド: GET（画面表示）
- コントローラー: `Organizations::OrganizationsController#new`
- GraphQL Mutation: `organizationCreate`（作成処理）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 説明 |
|--------|--------|----------|------|----------|------|
| 組織名 | name | String | Yes | テキスト（最大255文字） | 組織の表示名 |
| 組織URL | path | String | Yes | テキスト（2-255文字） | URLパスに使用される識別子 |
| 説明 | description | Text | No | テキストエリア（Markdown対応） | 組織の説明文 |
| アバター | avatar | File | No | 画像ファイル | 組織のアバター画像 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | 見出し | "New organization" |
| 説明テキスト | 段落 | 組織機能の説明とヘルプリンク |
| 組織名入力 | テキスト入力 | 必須項目 |
| 組織URL入力 | テキスト入力 | パスプレビュー付き |
| 説明入力 | テキストエリア | Markdownエディタ |
| アバターアップロード | ドロップゾーン | 画像アップロード領域 |
| 作成ボタン | ボタン | "Create organization" |
| キャンセルリンク | リンク | 組織一覧へ戻る |

## イベント仕様

### 1-作成ボタン押下

1. クライアントサイドバリデーションを実行
2. バリデーション成功時、GraphQL Mutation `organizationCreate` を実行
3. 画像がある場合は `hasUpload: true` コンテキストでマルチパート送信
4. 作成成功時、成功アラート付きで組織詳細画面へリダイレクト
5. 作成失敗時（バリデーションエラー）、エラーメッセージを表示

### 2-キャンセルボタン押下

1. 組織一覧画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | organizations | INSERT | 組織レコードの作成 |
| 作成ボタン押下 | organization_details | INSERT | 組織詳細の作成 |
| 作成ボタン押下 | organization_users | INSERT | 作成者をオーナーとして追加 |

### テーブル別更新項目詳細

#### organizations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 組織名 |
| INSERT | path | フォーム入力値 | URLパス（ユニーク） |
| INSERT | visibility_level | デフォルト値 | 可視性レベル |
| INSERT | created_at | 現在時刻 | 作成日時 |
| INSERT | updated_at | 現在時刻 | 更新日時 |

#### organization_details

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | organization_id | 作成された組織のID | 外部キー |
| INSERT | description | フォーム入力値 | 説明文 |
| INSERT | avatar | アップロードファイル | アバター画像 |

#### organization_users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | organization_id | 作成された組織のID | 外部キー |
| INSERT | user_id | current_user.id | 作成者 |
| INSERT | access_level | owner | オーナー権限 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | Organization successfully created. | 作成成功時 |
| MSG-002 | 成功 | You can now start using your new organization. | 作成成功時（詳細） |
| MSG-003 | エラー | An error occurred creating an organization. Please try again. | 作成処理エラー時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | アクセス拒否（403） |
| フィーチャーフラグ無効 | アクセス拒否（403） |
| バリデーションエラー | フォームにエラーメッセージを表示 |
| ネットワークエラー | アラートでエラーメッセージを表示 |
| パス重複 | バリデーションエラーとして処理 |

## 備考

- 組織URLは一度作成すると変更が困難なため、慎重に設定する必要がある
- パスは2文字以上255文字以下で、特定のパターン（`Gitlab::PathRegex::NAMESPACE_FORMAT_REGEX_JS`）に従う必要がある
- 説明文はMarkdown形式で入力可能であり、プレビュー機能が提供される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | organization.rb | `app/models/organizations/organization.rb` | バリデーションルール（行54-66） |
| 1-2 | organization_detail.rb | `app/models/organizations/organization_detail.rb` | 詳細情報の構造 |

**読解のコツ**: `validates :path` の制約条件（uniqueness, length）を確認すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | newアクション |
| 2-2 | application_controller.rb | `app/controllers/organizations/application_controller.rb` | authorize_create_organization! |

**主要処理フロー**:
1. **行25-27**: `def new` - 権限チェック後に画面表示
2. **行26**: `authorize_create_organization!` - 権限確認

#### Step 3: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/organizations/organizations/new.html.haml` | Vue.jsマウントポイント |
| 3-2 | app.vue | `app/assets/javascripts/organizations/new/components/app.vue` | メインコンポーネント |
| 3-3 | new_edit_form.vue | `app/assets/javascripts/organizations/shared/components/new_edit_form.vue` | 共通フォーム |

**主要処理フロー**:
- **行35-55**: `onSubmit` - GraphQL Mutationの実行
- **行42-55**: `organizationCreateMutation` - 組織作成API呼び出し

#### Step 4: GraphQL Mutationを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | organization_create.mutation.graphql | `app/assets/javascripts/organizations/new/graphql/mutations/organization_create.mutation.graphql` | Mutation定義 |

### プログラム呼び出し階層図

```
new.html.haml
    │
    └─ #js-organizations-new (Vue mount point)
           │
           └─ OrganizationNewApp (app.vue)
                  │
                  ├─ FormErrorsAlert (エラー表示)
                  │
                  └─ NewEditForm
                         │
                         ├─ 組織名入力
                         ├─ OrganizationUrlField
                         ├─ Markdown Editor (説明)
                         ├─ AvatarUploadDropzone
                         │
                         └─ onSubmit
                                │
                                └─ GraphQL Mutation: organizationCreate
```

### データフロー図

```
[入力]                    [処理]                           [出力]

フォーム入力 ───▶ Vue.js onSubmit
                      │
                      ├─ クライアントバリデーション
                      │
                      └─ GraphQL Mutation
                              │
                              ├─ Organizations::CreateService
                              │
                              └─▶ 成功: 詳細画面へリダイレクト
                                  失敗: エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | コントローラー | リクエスト処理 |
| new.html.haml | `app/views/organizations/organizations/new.html.haml` | ビュー | マウントポイント |
| app.vue | `app/assets/javascripts/organizations/new/components/app.vue` | Vue | メインコンポーネント |
| new_edit_form.vue | `app/assets/javascripts/organizations/shared/components/new_edit_form.vue` | Vue | フォームコンポーネント |
| organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | ヘルパー | app_data生成 |
| organization.rb | `app/models/organizations/organization.rb` | モデル | データ構造・バリデーション |
| organizations.rb | `config/routes/organizations.rb` | ルーティング | URL定義（行6） |
