# 画面設計書 184-組織詳細

## 概要

本ドキュメントは、GitLabの組織（Organization）詳細画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：組織詳細画面は、組織のトップページとして機能し、組織の概要情報、所属グループ・プロジェクトの統計、最近のアクティビティを一覧表示する。組織管理者やメンバーが組織の全体像を把握し、関連リソースへ効率的にアクセスするためのハブとなる画面である。

**画面へのアクセス方法**：組織一覧画面（182-組織一覧）から組織をクリックするか、直接URL `/-/organizations/:organization_path` にアクセスする。

**主要な操作・処理内容**：
1. 組織の基本情報（名前、説明、アバター）の表示
2. 関連統計（グループ数、プロジェクト数、ユーザー数）の表示
3. 所属グループ・プロジェクトへの遷移リンク
4. ユーザー管理画面への遷移リンク
5. 最近のグループ・プロジェクト一覧の表示

**画面遷移**：
- 遷移元：組織一覧画面（182-組織一覧）、ヘッダーナビゲーション
- 遷移先：組織グループ・プロジェクト画面（186）、組織ユーザー画面（185）、組織設定画面（188）

**権限による表示制御**：
- `read_organization` 権限を持つユーザーが閲覧可能
- 公開組織の場合、未ログインユーザーも閲覧可能（`skip_before_action :authenticate_user!`）
- 統計カードは権限に応じて表示される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 134 | 組織管理 | 主機能 | 組織のトップページ表示 |

## 画面種別

詳細

## URL/ルーティング

- パス: `/-/organizations/:organization_path`
- HTTPメソッド: GET
- コントローラー: `Organizations::OrganizationsController#show`

## 入出力項目

この画面は表示専用であり、ユーザー入力項目はない。

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 組織アバター | 画像 | 128px サイズの組織アバター |
| 組織名 | 見出し | 組織の表示名 |
| 組織説明 | テキスト | HTML形式の説明文 |
| グループ数 | カード | 組織内のグループ総数 |
| プロジェクト数 | カード | 組織内のプロジェクト総数 |
| ユーザー数 | カード | 組織内のユーザー総数 |
| グループ・プロジェクト一覧 | セクション | 最近のグループ・プロジェクト表示 |

## イベント仕様

### 1-統計カード（Groups/Projects）押下

1. 組織グループ・プロジェクト画面（186-組織グループ・プロジェクト）へ遷移

### 2-統計カード（Users）押下

1. 組織ユーザー画面（185-組織ユーザー）へ遷移

### 3-グループ・プロジェクトリンク押下

1. 各グループまたはプロジェクトの詳細画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | organizations | SELECT | 組織情報の取得 |
| 画面表示 | organization_details | SELECT | 組織詳細の取得 |
| 画面表示 | groups | SELECT | グループ数の集計 |
| 画面表示 | projects | SELECT | プロジェクト数の集計 |
| 画面表示 | organization_users | SELECT | ユーザー数の集計 |

### テーブル別更新項目詳細

この画面では参照のみを行い、データベースの更新は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| なし | - | - | この画面にはユーザー向けメッセージはない |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 組織が存在しない | 404エラーページを表示 |
| 権限不足 | アクセス拒否（403） |
| データ取得エラー | エラーメッセージを表示 |

## 備考

- 組織説明はHTMLとしてサニタイズされた状態（`description_html`）で表示される
- 統計情報は `OrganizationAssociationCounter` サービスクラスで計算される
- パフォーマンス考慮のため、大量のグループ・プロジェクトがある場合は一部のみ表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | organization.rb | `app/models/organizations/organization.rb` | 関連の定義、delegateメソッド |
| 1-2 | organization_detail.rb | `app/models/organizations/organization_detail.rb` | description_html, avatar_url |

**読解のコツ**: `delegate :description, :description_html, :avatar, :avatar_url` の委譲先を確認すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | showアクション、before_action |

**主要処理フロー**:
1. **行14**: `before_action :authorize_read_organization!` - 権限チェック
2. **行19**: `skip_before_action :authenticate_user!` - 認証スキップ
3. **行29**: `def show; end` - 空のアクション

#### Step 3: ヘルパーとデータ準備を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | organization_show_app_data |

**主要処理フロー**:
- **行15-23**: `organization_show_app_data` - Vueに渡すデータの構築

#### Step 4: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | show.html.haml | `app/views/organizations/organizations/show.html.haml` | マウントポイント |
| 4-2 | app.vue | `app/assets/javascripts/organizations/show/components/app.vue` | メインコンポーネント |
| 4-3 | organization_avatar.vue | `app/assets/javascripts/organizations/show/components/organization_avatar.vue` | アバター表示 |
| 4-4 | association_counts.vue | `app/assets/javascripts/organizations/show/components/association_counts.vue` | 統計カード |

### プログラム呼び出し階層図

```
show.html.haml
    │
    └─ #js-organizations-show (Vue mount point)
           │
           └─ OrganizationShowApp (app.vue)
                  │
                  ├─ OrganizationAvatar
                  │      └─ アバター画像表示
                  │
                  ├─ OrganizationDescription
                  │      └─ HTML説明文表示
                  │
                  ├─ AssociationCounts
                  │      └─ AssociationCountCard (x3)
                  │             ├─ Groups
                  │             ├─ Projects
                  │             └─ Users
                  │
                  └─ GroupsAndProjects
                         └─ 最近のリソース一覧
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLアクセス ───▶ OrganizationsController#show
                      │
                      ├─ authorize_read_organization!
                      │
                      └─ organization_show_app_data
                              │
                              ├─ organization.slice(...)
                              │
                              ├─ association_counts
                              │      └─ OrganizationAssociationCounter
                              │
                              └─▶ Vue.js コンポーネント
                                      │
                                      └─▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| organizations_controller.rb | `app/controllers/organizations/organizations_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/organizations/organizations/show.html.haml` | ビュー | マウントポイント |
| app.vue | `app/assets/javascripts/organizations/show/components/app.vue` | Vue | メインコンポーネント |
| organization_avatar.vue | `app/assets/javascripts/organizations/show/components/organization_avatar.vue` | Vue | アバター表示 |
| association_counts.vue | `app/assets/javascripts/organizations/show/components/association_counts.vue` | Vue | 統計カード |
| organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | ヘルパー | app_data生成 |
| organization.rb | `app/models/organizations/organization.rb` | モデル | データ構造 |
| organization_association_counter.rb | `app/services/organizations/organization_association_counter.rb` | サービス | 統計計算 |
