# 画面設計書 188-組織設定

## 概要

本ドキュメントは、GitLabの組織設定画面（General settings）の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：組織の管理者が組織の基本設定を変更するための画面である。組織名、URL、説明、アバター、可視性レベルなどの設定を行うことができる。また、組織の削除などの高度な操作も提供される。組織の運用ポリシーに合わせて適切な設定を維持するために重要な画面である。

**画面へのアクセス方法**：組織のサイドナビゲーションから「Settings」>「General」を選択、または直接URL `/-/organizations/:organization_path/settings/general` にアクセスする。

**主要な操作・処理内容**：
1. 組織名の変更
2. 組織URLの変更
3. 説明の編集（Markdown対応）
4. アバター画像の変更
5. 可視性レベルの変更
6. 組織の削除（Advanced settings）

**画面遷移**：
- 遷移元：組織詳細画面（184-組織詳細）、サイドナビゲーション
- 遷移先：設定保存後は同画面に留まる、削除後は組織一覧画面（182）へ

**権限による表示制御**：
- `admin_organization` 権限を持つユーザーのみがアクセス可能
- 権限がない場合はアクセス拒否（403）となる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 134 | 組織管理 | 主機能 | 組織の全般設定 |

## 画面種別

設定

## URL/ルーティング

- パス: `/-/organizations/:organization_path/settings/general`
- HTTPメソッド: GET
- コントローラー: `Organizations::SettingsController#general`

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 説明 |
|--------|--------|----------|------|----------|------|
| 組織名 | name | String | Yes | テキスト（最大255文字） | 組織の表示名 |
| 組織URL | path | String | Yes | テキスト（2-255文字） | URLパス |
| 説明 | description | Text | No | テキストエリア（Markdown） | 組織の説明文 |
| アバター | avatar | File | No | 画像ファイル | 組織のアバター画像 |
| 可視性レベル | visibility_level | Integer | Yes | ラジオボタン | Private/Internal/Public |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | 見出し | "General settings" |
| 設定検索 | 検索フィールド | 設定項目の検索 |
| Organization settings セクション | 折りたたみパネル | 基本設定 |
| Visibility level セクション | 折りたたみパネル | 可視性設定 |
| Advanced settings セクション | 折りたたみパネル | 高度な設定（削除等） |

## イベント仕様

### 1-Organization settings 保存

1. 組織名、URL、説明、アバターを入力
2. GraphQL Mutation で更新リクエストを送信
3. 成功時、成功メッセージを表示
4. 失敗時、エラーメッセージを表示

### 2-Visibility level 変更

1. 可視性レベルを選択
2. GraphQL Mutation で更新リクエストを送信
3. 成功時、成功メッセージを表示

### 3-組織削除（Advanced settings）

1. 削除ボタンをクリック
2. 確認ダイアログを表示
3. 確認後、GraphQL Mutation で削除リクエストを送信
4. 成功時、組織一覧画面へリダイレクト

### 4-設定検索

1. 検索キーワードを入力
2. マッチする設定セクションをハイライト表示
3. 該当セクションを自動展開

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 基本設定保存 | organizations | UPDATE | 組織名、パスの更新 |
| 基本設定保存 | organization_details | UPDATE | 説明、アバターの更新 |
| 可視性変更 | organizations | UPDATE | 可視性レベルの更新 |
| 組織削除 | organizations | DELETE | 組織の削除 |
| 組織削除 | organization_users | DELETE | 関連するユーザー関連の削除 |
| 組織削除 | groups | UPDATE/DELETE | 関連グループの処理 |

### テーブル別更新項目詳細

#### organizations

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 組織名 |
| UPDATE | path | フォーム入力値 | URLパス |
| UPDATE | visibility_level | 選択値 | 0:Private/10:Internal/20:Public |
| UPDATE | updated_at | 現在時刻 | 更新日時 |

#### organization_details

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | description | フォーム入力値 | 説明文 |
| UPDATE | avatar | アップロードファイル | アバター画像 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | Organization was successfully updated. | 更新成功時 |
| MSG-002 | エラー | An error occurred updating the organization. Please try again. | 更新失敗時 |
| MSG-003 | 警告 | This action cannot be undone. | 削除確認時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | アクセス拒否（403） |
| バリデーションエラー | エラーメッセージを表示 |
| パス重複 | バリデーションエラーとして処理 |
| 削除失敗 | エラーメッセージを表示 |

## 備考

- 設定検索機能は `SearchSettings` コンポーネントで提供される
- 各設定セクションは折りたたみ可能で、デフォルトでは Organization settings のみ展開
- URLの変更は影響が大きいため、変更時は警告を表示することが推奨される
- 組織削除は関連するすべてのリソースに影響するため、十分な確認が必要

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | organization.rb | `app/models/organizations/organization.rb` | バリデーション、可視性レベル |

**読解のコツ**: `visibility_level_field` メソッドと `Gitlab::VisibilityLevel` モジュールを確認すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | settings_controller.rb | `app/controllers/organizations/settings_controller.rb` | generalアクション |

**主要処理フロー**:
1. **行7**: `before_action :authorize_admin_organization!` - 権限チェック
2. **行9**: `def general; end` - 空のアクション

#### Step 3: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | organization_settings_general_app_data |

**主要処理フロー**:
- **行29-34**: `organization_settings_general_app_data` - Vue用データ準備

#### Step 4: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | general.html.haml | `app/views/organizations/settings/general.html.haml` | マウントポイント |
| 4-2 | app.vue | `app/assets/javascripts/organizations/settings/general/components/app.vue` | メインコンポーネント |
| 4-3 | organization_settings.vue | `app/assets/javascripts/organizations/settings/general/components/organization_settings.vue` | 基本設定 |
| 4-4 | visibility_level.vue | `app/assets/javascripts/organizations/settings/general/components/visibility_level.vue` | 可視性設定 |
| 4-5 | advanced_settings.vue | `app/assets/javascripts/organizations/settings/general/components/advanced_settings.vue` | 高度な設定 |

**主要処理フロー**:
- **行17-24**: `sectionsExpandedState` - セクション展開状態管理
- **行30-52**: 各セクションの展開/折りたたみ処理

### プログラム呼び出し階層図

```
general.html.haml
    │
    └─ #js-organizations-settings-general (Vue mount point)
           │
           └─ OrganizationSettingsGeneralApp (app.vue)
                  │
                  ├─ SearchSettings
                  │      └─ 設定検索機能
                  │
                  ├─ OrganizationSettings (展開: true)
                  │      ├─ 名前入力
                  │      ├─ URL入力
                  │      ├─ 説明入力
                  │      └─ アバターアップロード
                  │
                  ├─ VisibilityLevel (展開: false)
                  │      └─ 可視性選択
                  │
                  └─ AdvancedSettings (展開: false)
                         └─ 組織削除
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLアクセス ───▶ SettingsController#general
                      │
                      ├─ authorize_admin_organization!
                      │
                      └─ organization_settings_general_app_data
                              │
                              └─▶ Vue.js App
                                      │
                                      └─▶ 設定画面表示

設定変更 ────────▶ GraphQL Mutation
                      │
                      ├─ バリデーション
                      │
                      └─▶ 成功: メッセージ表示
                          失敗: エラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| settings_controller.rb | `app/controllers/organizations/settings_controller.rb` | コントローラー | リクエスト処理 |
| general.html.haml | `app/views/organizations/settings/general.html.haml` | ビュー | マウントポイント |
| app.vue | `app/assets/javascripts/organizations/settings/general/components/app.vue` | Vue | メインコンポーネント |
| organization_settings.vue | `app/assets/javascripts/organizations/settings/general/components/organization_settings.vue` | Vue | 基本設定 |
| visibility_level.vue | `app/assets/javascripts/organizations/settings/general/components/visibility_level.vue` | Vue | 可視性設定 |
| advanced_settings.vue | `app/assets/javascripts/organizations/settings/general/components/advanced_settings.vue` | Vue | 高度な設定 |
| organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | ヘルパー | app_data生成 |
