# 画面設計書 189-プロジェクト編集

## 概要

本ドキュメントは、GitLabの組織配下プロジェクト編集画面の設計を記述したものである。

### 本画面の処理概要

**業務上の目的・背景**：組織に所属するプロジェクトの基本情報（名前、説明）を編集するための画面である。組織のコンテキスト内でプロジェクトを管理することで、組織全体のリソース管理を一元化できる。通常のプロジェクト設定画面とは異なり、組織ナビゲーション配下に配置されている。

**画面へのアクセス方法**：組織グループ・プロジェクト画面（186）からプロジェクトの編集リンクをクリック、または直接URL `/-/organizations/:organization_path/projects/:namespace_id/:project_id/edit` にアクセスする。

**主要な操作・処理内容**：
1. プロジェクト名の変更
2. プロジェクト説明の編集（Markdown対応）
3. 変更の保存
4. 編集のキャンセル

**画面遷移**：
- 遷移元：組織グループ・プロジェクト画面（186-組織グループ・プロジェクト）
- 遷移先：保存成功時は同画面を再表示、キャンセル時はプロジェクト一覧へ

**権限による表示制御**：
- `view_edit_page` 権限を持つユーザーのみがアクセス可能
- 権限がない場合はアクセス拒否（403）となる

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | プロジェクト編集 | 主機能 | 組織配下プロジェクトの編集 |

## 画面種別

編集

## URL/ルーティング

- パス: `/-/organizations/:organization_path/projects/:namespace_id/:project_id/edit`
- HTTPメソッド: GET（画面表示）
- コントローラー: `Organizations::ProjectsController#edit`
- REST API: `updateProject`（更新処理）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 説明 |
|--------|--------|----------|------|----------|------|
| プロジェクト名 | name | String | Yes | テキスト | プロジェクトの表示名 |
| プロジェクト説明 | description | Text | No | テキストエリア（Markdown） | プロジェクトの説明文 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ページタイトル | 見出し | "Edit project: {project_name}" |
| プロジェクト名入力 | テキスト入力 | 現在の名前がプリフィルされる |
| 説明入力 | テキストエリア | 現在の説明がプリフィルされる（Markdown対応） |
| 保存ボタン | ボタン | "Save changes" |
| キャンセルリンク | リンク | プロジェクト一覧へ戻る |

## イベント仕様

### 1-保存ボタン押下

1. クライアントサイドバリデーションを実行
2. REST API `updateProject` を呼び出し
3. 成功時、成功メッセージを表示し画面を再表示
4. 失敗時（バリデーションエラー）、エラーメッセージをフィールドに表示

### 2-キャンセルボタン押下

1. 組織グループ・プロジェクト画面（display=projects）へ遷移

### 3-フィールド入力

1. 入力時にサーバーバリデーションエラーをクリア

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | projects | SELECT | プロジェクト情報の取得 |
| 保存ボタン押下 | projects | UPDATE | プロジェクト情報の更新 |

### テーブル別更新項目詳細

#### projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | プロジェクト名 |
| UPDATE | description | フォーム入力値 | 説明文 |
| UPDATE | updated_at | 現在時刻 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | Project was successfully updated. | 更新成功時 |
| MSG-002 | エラー | An error occurred updating this project. Please try again. | 更新失敗時 |
| MSG-003 | エラー | {field_name} {error_message} | バリデーションエラー時 |

## 例外処理

| 例外パターン | 処理内容 |
|-------------|----------|
| 権限不足 | アクセス拒否（403） |
| プロジェクト未存在 | 404エラーページを表示 |
| バリデーションエラー | フィールドにエラーメッセージを表示 |
| ネットワークエラー | アラートでエラーメッセージを表示 |

## 備考

- この画面はREST APIを使用してプロジェクトを更新する（GraphQLではない）
- 説明フィールドはMarkdown形式をサポートし、プレビュー機能が提供される
- サーバーバリデーションエラーは `serverValidations` オブジェクトで管理される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | name, descriptionのバリデーション |

**読解のコツ**: プロジェクトの基本バリデーションルールを確認すること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects_controller.rb | `app/controllers/organizations/projects_controller.rb` | editアクション |

**主要処理フロー**:
1. **行5**: `before_action :authorize_project_view_edit_page!` - 権限チェック
2. **行9**: `def edit; end` - 空のアクション
3. **行13-16**: `project` - プロジェクトの取得

#### Step 3: ヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | organization_projects_edit_app_data |

**主要処理フロー**:
- **行70-76**: `organization_projects_edit_app_data` - Vue用データ準備

#### Step 4: フロントエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.html.haml | `app/views/organizations/projects/edit.html.haml` | マウントポイント |
| 4-2 | app.vue | `app/assets/javascripts/organizations/projects/edit/components/app.vue` | メインコンポーネント |

**主要処理フロー**:
- **行19-24**: inject - 初期データの注入
- **行26-68**: `onSubmit` - REST API呼び出し

### プログラム呼び出し階層図

```
edit.html.haml
    │
    └─ #js-organizations-projects-edit (Vue mount point)
           │
           └─ OrganizationProjectsEditApp (app.vue)
                  │
                  ├─ inject: projectsOrganizationPath
                  ├─ inject: previewMarkdownPath
                  ├─ inject: project
                  │
                  └─ NewEditForm (プロジェクト編集フォーム)
                         │
                         ├─ プロジェクト名入力
                         ├─ 説明入力 (Markdown)
                         │
                         └─ onSubmit
                                │
                                └─ REST API: updateProject
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLアクセス ───▶ ProjectsController#edit
                      │
                      ├─ authorize_project_view_edit_page!
                      │
                      └─ organization_projects_edit_app_data
                              │
                              └─▶ Vue.js App
                                      │
                                      └─▶ フォーム表示

フォーム送信 ─────▶ onSubmit
                      │
                      └─ updateProject (REST API)
                              │
                              ├─ バリデーション
                              │
                              └─▶ 成功: メッセージ表示
                                  失敗: エラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| projects_controller.rb | `app/controllers/organizations/projects_controller.rb` | コントローラー | リクエスト処理 |
| edit.html.haml | `app/views/organizations/projects/edit.html.haml` | ビュー | マウントポイント |
| app.vue | `app/assets/javascripts/organizations/projects/edit/components/app.vue` | Vue | メインコンポーネント |
| new_edit_form.vue | `app/assets/javascripts/projects/components/new_edit_form.vue` | Vue | フォームコンポーネント |
| organization_helper.rb | `app/helpers/organizations/organization_helper.rb` | ヘルパー | app_data生成 |
| rest_api.js | `app/assets/javascripts/rest_api.js` | JavaScript | REST API呼び出し |
