# 画面設計書 194-SSHキー詳細

## 概要

本ドキュメントは、SSHキー詳細画面の設計書である。個別のSSHキーの詳細情報を表示する画面の仕様を定義する。

### 本画面の処理概要

登録済みの個別SSHキーの詳細情報を表示する画面である。キーの用途タイプ、作成日、最終使用日、有効期限、公開鍵本体、フィンガープリント（MD5/SHA256）を確認できる。

**業務上の目的・背景**：開発者はSSHキーの管理において、キーの状態確認（いつ作成され、いつ最後に使用されたか、期限切れかどうか）が重要である。また、サーバー側でキーを確認する際にフィンガープリントの照合が必要となる。本画面はこれらの情報を一元的に確認するために必要である。

**画面へのアクセス方法**：
1. SSHキー一覧画面でキーのタイトルをクリック
2. または URL `/-/user_settings/ssh_keys/:id` に直接アクセス

**主要な操作・処理内容**：
1. SSHキーの詳細情報の表示
2. 公開鍵のコピー
3. SSHキーの削除

**画面遷移**：
- 遷移元: SSHキー一覧画面
- 遷移先: SSHキー一覧画面（削除後）

**権限による表示制御**：
- ログイン必須
- 自身のSSHキーのみ表示可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | SSHキー管理 | 主機能 | SSHキーの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

```
GET /-/user_settings/ssh_keys/:id
```

## 入出力項目

本画面は詳細表示のみで入力項目はない。

## 表示項目

### キー詳細テーブル

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| タイトル | @key.title | キーのタイトル（ページヘッダー） |
| 用途タイプ | @key.usage_type | 認証&署名 / 認証のみ / 署名のみ |
| 作成日 | @key.created_at | キー登録日時 |
| 最終使用日 | @key.last_used_at | 最後に使用された日時（未使用: "Never"） |
| 有効期限 | @key.expires_at | 有効期限（無期限: "Never"、期限切れ: 赤字表示） |
| SSH公開鍵 | @key.key | 公開鍵全文 |
| MD5フィンガープリント | @key.fingerprint | MD5形式のフィンガープリント |
| SHA256フィンガープリント | @key.fingerprint_sha256 | SHA256形式のフィンガープリント |

### 警告表示

| 項目名 | 条件 | 説明 |
|--------|------|------|
| 弱いキー警告 | @ssh_public_key_warning | 脆弱なアルゴリズム使用時に表示 |

## イベント仕様

### 1-公開鍵コピー

**トリガー**: コピーボタン押下

**処理フロー**:
1. クリップボードに公開鍵をコピー
2. フィードバック表示

### 2-SSHキー削除

**トリガー**: 削除ボタン押下

**処理フロー**:
1. 削除確認モーダルを表示
2. 確認後、DELETE リクエスト
3. `Keys::DestroyService` でキーを削除
4. SSHキー一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | keys | SELECT | キー情報の取得 |
| 削除 | keys | DELETE | キーの削除 |

### テーブル別更新項目詳細

#### keys（表示時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | user_id = current_user.id AND id = params[:id] | キー取得条件 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-001 | 警告 | Warning! Insecure key. %{message} | 弱いキー検出時 |
| MSG-002 | 情報 | Expired | 有効期限切れ時 |
| MSG-003 | 情報 | Never | 未使用/無期限時 |

## 例外処理

| 例外 | 発生条件 | 対応処理 |
|-----|---------|---------|
| 未認証 | ログインしていない | ログイン画面へリダイレクト |
| 404 Not Found | 指定されたキーが存在しない | 404ページ表示 |
| 403 Forbidden | 他ユーザーのキーにアクセス | アクセス拒否 |

## 備考

- FIPSモードではMD5フィンガープリントは生成されず、SHA256のみ表示される
- 脆弱なアルゴリズム（短いRSAキー等）の場合、警告が表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | key.rb | `app/models/key.rb` | Keyモデルの属性を確認 |

**読解のコツ**: `fingerprint_md5` は `fingerprint` のエイリアスである。`public_key` メソッドで `Gitlab::SSHPublicKey` オブジェクトを取得できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ssh_keys_controller.rb | `app/controllers/user_settings/ssh_keys_controller.rb` | show アクションを確認 |

**主要処理フロー**:
1. **13-16行目**: `show` アクション
2. **14行目**: `current_user.keys.find(params[:id])` でキー取得
3. **15行目**: `public_key.weak_key_warning` で弱いキー警告を取得

#### Step 3: ビューレイヤーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/user_settings/ssh_keys/show.html.haml` | 画面構造（パーシャルレンダリング） |
| 3-2 | _key_details.html.haml | `app/views/user_settings/ssh_keys/_key_details.html.haml` | 詳細表示のメイン実装 |

**主要処理フロー**:
- **3-8行目**: 弱いキー警告の表示
- **10-13行目**: ページヘッダー（タイトル、削除ボタン）
- **15-40行目**: キー詳細テーブル
- **45-50行目**: SSH公開鍵の表示・コピーボタン
- **52-64行目**: フィンガープリント表示

### プログラム呼び出し階層図

```
UserSettings::SshKeysController#show
    │
    ├─ current_user.keys.find(params[:id])
    │      └─ @key
    │
    └─ @key.public_key.weak_key_warning
           └─ @ssh_public_key_warning

render 'show'
    │
    └─ render '_key_details'
           ├─ PageHeadingComponent (タイトル)
           ├─ CrudComponent (キー詳細テーブル)
           │      └─ 用途タイプ、作成日、最終使用日、有効期限
           ├─ CrudComponent (SSH公開鍵)
           │      └─ clipboard_button
           └─ CrudComponent (フィンガープリント)
                  ├─ MD5
                  └─ SHA256
```

### データフロー図

```
[入力]               [処理]                    [出力]

params[:id] ───▶ keys.find(id) ───▶ @key
    │                  │
    │                  └─ public_key.weak_key_warning ───▶ @ssh_public_key_warning
    │
    └───────────────────────────────────────────────────▶ _key_details.html.haml
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ssh_keys_controller.rb | `app/controllers/user_settings/ssh_keys_controller.rb` | コントローラー | リクエスト処理 |
| show.html.haml | `app/views/user_settings/ssh_keys/show.html.haml` | テンプレート | 詳細画面 |
| _key_details.html.haml | `app/views/user_settings/ssh_keys/_key_details.html.haml` | パーシャル | 詳細表示 |
| key.rb | `app/models/key.rb` | モデル | SSHキーデータ定義 |
| ssh_public_key.rb | `lib/gitlab/ssh_public_key.rb` | ライブラリ | 公開鍵パース・検証 |
| user_settings.rb | `config/routes/user_settings.rb` | 設定 | ルーティング定義 |
